---
generated_at: 2026-01-14 21:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-注文詳細取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - 13行目: MapGet定義
- E-02: `src/Ordering.API/Apis/OrdersApi.cs` - 80-91行目: GetOrderAsyncメソッド
- E-03: `src/Ordering.API/Apis/OrdersApi.cs` - 84行目: Queries.GetOrderAsync呼び出し
- E-04: `src/Ordering.API/Apis/OrdersApi.cs` - 85行目: Ok返却
- E-05: `src/Ordering.API/Apis/OrdersApi.cs` - 89行目: NotFound返却
- E-06: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 6-35行目: GetOrderAsync実装
- E-07: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 8-10行目: Include(OrderItems)
- E-08: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 12-13行目: KeyNotFoundException
- E-09: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 15-34行目: DTO変換
- E-10: `src/Ordering.API/Application/Queries/OrderViewModel.cs` - 11-24行目: Order record定義
- E-11: `src/Ordering.API/Application/Queries/OrderViewModel.cs` - 3-9行目: Orderitem record定義
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 20行目: 機能No.19定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /api/orders/{orderId}で注文詳細を取得する | E-01 | ○ |
| C-02 | GetOrderAsyncがエントリーポイント | E-02 | ○ |
| C-03 | OrderQueries.GetOrderAsyncを呼び出す | E-03 | ○ |
| C-04 | 成功時はOk(Order)を返却する | E-04 | ○ |
| C-05 | 注文が存在しない場合はNotFoundを返却 | E-05 | ○ |
| C-06 | Include(OrderItems)でEager Loading | E-07 | ○ |
| C-07 | 注文がnullの場合KeyNotFoundExceptionをスロー | E-08 | ○ |
| C-08 | ドメインエンティティからDTOに変換 | E-09 | ○ |
| C-09 | Order DTOにOrderNumber, Date, Status等が含まれる | E-10 | ○ |
| C-10 | Orderitem DTOにProductName, Units, UnitPrice, PictureUrlが含まれる | E-11 | ○ |
| C-11 | order.GetTotal()で合計金額を計算 | E-09 (26行目) | ○ |
| C-12 | OrderStatus.ToString()でステータスを文字列化 | E-09 (25行目) | ○ |
| C-13 | 機能番号19は注文詳細取得機能である | E-12 | ○ |
| C-14 | CQRSパターンでクエリを分離 | E-06 (IOrderQueries経由) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がソースコードに基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OrdersApi.cs 80-91行目のGetOrderAsyncが設計書の処理フローと一致しているか
- [ ] OrderQueries.csのGetOrderAsync実装が正しく記載されているか
- [ ] Order, Orderitem DTOの構造が正しく記載されているか
