---
generated_at: 2026-01-14 21:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ユーザー注文履歴取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - 14行目: MapGet("/")定義
- E-02: `src/Ordering.API/Apis/OrdersApi.cs` - 93-98行目: GetOrdersByUserAsyncメソッド
- E-03: `src/Ordering.API/Apis/OrdersApi.cs` - 95行目: GetUserIdentity呼び出し
- E-04: `src/Ordering.API/Apis/OrdersApi.cs` - 96行目: GetOrdersFromUserAsync呼び出し
- E-05: `src/Ordering.API/Apis/OrdersApi.cs` - 97行目: Ok返却
- E-06: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 37-49行目: GetOrdersFromUserAsync実装
- E-07: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 40行目: IdentityGuidでフィルタ
- E-08: `src/Ordering.API/Application/Queries/OrderQueries.cs` - 46行目: Sum集計
- E-09: `src/Ordering.API/Application/Queries/OrderViewModel.cs` - 26-32行目: OrderSummary record定義
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 21行目: 機能No.20定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 23行目: 関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /api/ordersでユーザー注文履歴を取得する | E-01 | ○ |
| C-02 | GetOrdersByUserAsyncがエントリーポイント | E-02 | ○ |
| C-03 | IdentityService.GetUserIdentity()でユーザーIDを取得 | E-03 | ○ |
| C-04 | GetOrdersFromUserAsyncを呼び出す | E-04 | ○ |
| C-05 | 成功時はOk(orders)を返却する | E-05 | ○ |
| C-06 | GetOrdersFromUserAsyncはユーザーの注文を取得 | E-06 | ○ |
| C-07 | Buyer.IdentityGuidでユーザーをフィルタ | E-07 | ○ |
| C-08 | Sum(UnitPrice * Units)で合計金額を計算 | E-08 | ○ |
| C-09 | OrderSummaryにOrderNumber, Date, Status, Totalが含まれる | E-09 | ○ |
| C-10 | 機能番号20はユーザー注文履歴取得機能である | E-10 | ○ |
| C-11 | 注文履歴画面から利用される | E-11 | ○ |
| C-12 | IEnumerableで複数注文を返却 | E-02, E-06 | ○ |
| C-13 | CQRSパターンでクエリを分離 | E-06 (IOrderQueries経由) | ○ |
| C-14 | 自分自身の注文履歴のみ取得可能 | E-07 (IdentityGuidフィルタ) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がソースコードに基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OrdersApi.cs 93-98行目のGetOrdersByUserAsyncが設計書の処理フローと一致しているか
- [ ] OrderQueries.csのGetOrdersFromUserAsync実装が正しく記載されているか
- [ ] OrderSummary DTOの構造が正しく記載されているか
