---
generated_at: 2026-01-14 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-注文発送処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - APIエンドポイント定義（51-78行目）
- E-02: `src/Ordering.API/Application/Commands/ShipOrderCommand.cs` - コマンド定義（3行目）
- E-03: `src/Ordering.API/Application/Commands/ShipOrderCommandHandler.cs` - コマンドハンドラ（19-29行目）
- E-04: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 注文エンティティ（130-140行目）
- E-05: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs` - ステータス列挙型（6-14行目）
- E-06: `src/Ordering.API/Application/DomainEventHandlers/OrderShippedDomainEventHandler.cs` - ドメインイベントハンドラ（23-32行目）
- E-07: `src/Ordering.API/Application/Validations/ShipOrderCommandValidator.cs` - バリデーション（7行目）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（22行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントはPUT /api/orders/shipである | E-01（12行目） | ○ |
| C-02 | ShipOrderCommandはOrderNumberのみを持つ | E-02（3行目） | ○ |
| C-03 | x-requestidヘッダーが必須である | E-01（52-53行目） | ○ |
| C-04 | 空のGUIDは不正として400を返す | E-01（56-59行目） | ○ |
| C-05 | IdentifiedCommandでラップして冪等性を保証 | E-01（61行目） | ○ |
| C-06 | 注文が存在しない場合はfalseを返す | E-03（22-25行目） | ○ |
| C-07 | Order.SetShippedStatus()を呼び出す | E-03（27行目） | ○ |
| C-08 | Paidステータスの注文のみ発送可能 | E-04（132行目） | ○ |
| C-09 | Paid以外のステータスでは例外をスローする | E-04（134行目） | ○ |
| C-10 | ステータスをShippedに変更する | E-04（137行目） | ○ |
| C-11 | Descriptionに「The order was shipped.」を設定 | E-04（138行目） | ○ |
| C-12 | OrderShippedDomainEventを発行する | E-04（139行目） | ○ |
| C-13 | ドメインイベントハンドラが統合イベントを発行する | E-06（30-31行目） | ○ |
| C-14 | 購買者情報を取得して統合イベントに含める | E-06（28行目） | ○ |
| C-15 | OrderNumberのバリデーションはNotEmptyである | E-07（7行目） | ○ |
| C-16 | OrderStatusはShipped=5である | E-05（12行目） | ○ |
| C-17 | 本機能は注文管理カテゴリに属する | E-08（22行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 発送可能なステータスの条件（Paidのみ）が業務要件と一致しているか確認
- [ ] 統合イベント発行後の他マイクロサービスでの処理が適切か確認
- [ ] 管理者権限の検証が適切に実装されているか確認（現在のコードでは明示的な権限チェックなし）
