---
generated_at: 2026-01-14 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-カードタイプ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - APIエンドポイント定義（15行目, 100-104行目）
- E-02: `src/Ordering.API/Application/Queries/IOrderQueries.cs` - クエリインターフェース（9行目）
- E-03: `src/Ordering.API/Application/Queries/OrderQueries.cs` - クエリ実装（51-52行目）
- E-04: `src/Ordering.API/Application/Queries/OrderViewModel.cs` - CardType record定義（34-38行目）
- E-05: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/CardType.cs` - ドメインモデル（3-7行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（23行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントはGET /api/orders/cardtypesである | E-01（15行目） | ○ |
| C-02 | IOrderQueries.GetCardTypesAsync()を呼び出す | E-01（102行目）, E-02（9行目） | ○ |
| C-03 | CardTypesテーブルから全件取得する | E-03（52行目） | ○ |
| C-04 | IdとNameのみを返却する | E-03（52行目）, E-04（35-37行目） | ○ |
| C-05 | パラメータは不要である | E-01（100行目） | ○ |
| C-06 | JSON配列形式で返却する | E-01（103行目） | ○ |
| C-07 | CardTypeはId, Nameプロパティを持つ | E-04（35-37行目）, E-05（5-6行目） | ○ |
| C-08 | TypedResults.Okで成功レスポンスを返却 | E-01（103行目） | ○ |
| C-09 | CQRSパターンでクエリを分離している | E-02, E-03 | ○ |
| C-10 | 本機能は注文管理カテゴリに属する | E-06（23行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 返却されるカードタイプの種類が業務要件を満たしているか確認
- [ ] 認証要件が適切に設定されているか確認
- [ ] キャッシュ戦略（クライアント側、サーバー側）を検討する必要があるか確認
