---
generated_at: 2026-01-14 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-注文ステータス管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 注文エンティティ
- E-02: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs` - ステータス列挙型（6-14行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（24行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusは6種類のステータスを持つ | E-02（8-13行目） | ○ |
| C-02 | Submitted=1である | E-02（8行目） | ○ |
| C-03 | AwaitingValidation=2である | E-02（9行目） | ○ |
| C-04 | StockConfirmed=3である | E-02（10行目） | ○ |
| C-05 | Paid=4である | E-02（11行目） | ○ |
| C-06 | Shipped=5である | E-02（12行目） | ○ |
| C-07 | Cancelled=6である | E-02（13行目） | ○ |
| C-08 | 注文作成時にSubmittedを設定する | E-01（57行目） | ○ |
| C-09 | SetAwaitingValidationStatusはSubmittedからのみ遷移可能 | E-01（101行目） | ○ |
| C-10 | SetStockConfirmedStatusはAwaitingValidationからのみ遷移可能 | E-01（110行目） | ○ |
| C-11 | SetPaidStatusはStockConfirmedからのみ遷移可能 | E-01（121行目） | ○ |
| C-12 | SetShippedStatusはPaidからのみ遷移可能で、違反時は例外 | E-01（132-135行目） | ○ |
| C-13 | SetCancelledStatusはPaid/Shippedからは遷移不可で、違反時は例外 | E-01（144-148行目） | ○ |
| C-14 | SetCancelledStatusWhenStockIsRejectedはAwaitingValidationからのみ遷移可能 | E-01（157行目） | ○ |
| C-15 | 在庫不足キャンセル時に不足商品名を説明文に記録 | E-01（161-166行目） | ○ |
| C-16 | OrderStatusChangedToAwaitingValidationDomainEventを発行 | E-01（103行目） | ○ |
| C-17 | OrderStatusChangedToStockConfirmedDomainEventを発行 | E-01（112行目） | ○ |
| C-18 | OrderStatusChangedToPaidDomainEventを発行 | E-01（123行目） | ○ |
| C-19 | OrderShippedDomainEventを発行 | E-01（139行目） | ○ |
| C-20 | OrderCancelledDomainEventを発行 | E-01（152行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] ステータス遷移のビジネスルールが業務要件と一致しているか確認
- [ ] 各ステータス遷移で発行されるドメインイベントが適切か確認
- [ ] 例外スロー時のエラーメッセージが運用上適切か確認
- [ ] 在庫不足キャンセル時の説明文フォーマットが適切か確認
