---
generated_at: 2026-01-14 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-支払い完了処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentSucceededIntegrationEventHandler.cs` - 統合イベントハンドラ（8-23行目）
- E-02: `src/Ordering.API/Application/Commands/SetPaidOrderStatusCommand.cs` - コマンド定義（3行目）
- E-03: `src/Ordering.API/Application/Commands/SetPaidOrderStatusCommandHandler.cs` - コマンドハンドラ（19-32行目）
- E-04: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 注文エンティティ（119-128行目）
- E-05: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs` - ドメインイベントハンドラ（22-40行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（27行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderPaymentSucceededIntegrationEventを受信してコマンドを発行 | E-01（12, 21行目） | ○ |
| C-02 | SetPaidOrderStatusCommandはOrderNumberのみを持つ | E-02（3行目） | ○ |
| C-03 | 10秒の遅延シミュレーションを行う | E-03（22行目） | ○ |
| C-04 | 注文が存在しない場合はfalseを返す | E-03（25-28行目） | ○ |
| C-05 | Order.SetPaidStatus()を呼び出す | E-03（30行目） | ○ |
| C-06 | StockConfirmedステータスからのみPaidに遷移可能 | E-04（121行目） | ○ |
| C-07 | 条件を満たす場合にステータスをPaidに変更 | E-04（125行目） | ○ |
| C-08 | 説明文に模擬銀行口座情報を含むメッセージを設定 | E-04（126行目） | ○ |
| C-09 | OrderStatusChangedToPaidDomainEventを発行 | E-04（123行目） | ○ |
| C-10 | ドメインイベントハンドラが注文情報を取得 | E-05（26行目） | ○ |
| C-11 | ドメインイベントハンドラが購買者情報を取得 | E-05（27行目） | ○ |
| C-12 | 注文アイテムから在庫リストを作成 | E-05（29-30行目） | ○ |
| C-13 | OrderStatusChangedToPaidIntegrationEventを発行 | E-05（32-39行目） | ○ |
| C-14 | MediatR.Send()でコマンドを送信 | E-01（21行目） | ○ |
| C-15 | UnitOfWorkで永続化 | E-03（31行目） | ○ |
| C-16 | 本機能は注文管理カテゴリに属する | E-06（27行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 10秒の遅延シミュレーションが本番環境で適切か確認（設定可能にすべきか検討）
- [ ] 模擬銀行口座情報（説明文）が本番環境では実際の情報に置き換わるか確認
- [ ] Webhooks.APIへの通知が適切に処理されるか確認
- [ ] Paid状態からのキャンセル不可がUIレベルでも制御されているか確認
