---
generated_at: 2026-01-14 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-在庫不足キャンセル処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockRejectedIntegrationEventHandler.cs` - 統合イベントハンドラ（6-26行目）
- E-02: `src/Ordering.API/Application/Commands/SetStockRejectedOrderStatusCommand.cs` - コマンド定義（3行目）
- E-03: `src/Ordering.API/Application/Commands/SetStockRejectedOrderStatusCommandHandler.cs` - コマンドハンドラ（19-33行目）
- E-04: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 注文エンティティ（155-168行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（28行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStockRejectedIntegrationEventを受信してコマンドを発行 | E-01（15, 24行目） | ○ |
| C-02 | HasStock=falseの商品IDを抽出する | E-01（10-13行目） | ○ |
| C-03 | SetStockRejectedOrderStatusCommandはOrderNumberとOrderStockItemsを持つ | E-02（3行目） | ○ |
| C-04 | 10秒の遅延シミュレーションを行う | E-03（22行目） | ○ |
| C-05 | 注文が存在しない場合はfalseを返す | E-03（25-28行目） | ○ |
| C-06 | Order.SetCancelledStatusWhenStockIsRejected()を呼び出す | E-03（30行目） | ○ |
| C-07 | AwaitingValidationステータスからのみCancelledに遷移可能 | E-04（157行目） | ○ |
| C-08 | 条件を満たす場合にステータスをCancelledに変更 | E-04（159行目） | ○ |
| C-09 | 不足商品IDから商品名を抽出する | E-04（161-163行目） | ○ |
| C-10 | 商品名をカンマ区切りで結合する | E-04（165行目） | ○ |
| C-11 | 説明文に「The product items don't have stock:」を含むメッセージを設定 | E-04（166行目） | ○ |
| C-12 | MediatR.Send()でコマンドを送信 | E-01（24行目） | ○ |
| C-13 | UnitOfWorkで永続化 | E-03（32行目） | ○ |
| C-14 | このメソッドではドメインイベントを発行しない | E-04（155-168行目：AddDomainEventの呼び出しなし） | ○ |
| C-15 | 本機能は注文管理カテゴリに属する | E-05（28行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 在庫不足キャンセル時にドメインイベントを発行しないことが業務要件と一致しているか確認
- [ ] 不足商品名の表示形式が顧客にわかりやすいか確認
- [ ] 在庫不足キャンセルと顧客起因キャンセルの区別がUIレベルで適切か確認
