---
generated_at: 2026-01-14 21:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-ユーザーログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（2秒以内）**：具体的な数値根拠なし
  2. **ロックアウト期間の詳細**：デフォルト設定値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-02: `src/Identity.API/Services/EFLoginService.cs`
- E-03: `src/Identity.API/Services/ILoginService.cs`
- E-04: `src/Identity.API/Models/ApplicationUser.cs`
- E-05: `src/Identity.API/Quickstart/Account/LoginInputModel.cs`
- E-06: `src/Identity.API/Quickstart/Account/LoginViewModel.cs`
- E-07: `src/Identity.API/Data/ApplicationDbContext.cs`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メールアドレスとパスワードでユーザー認証を行う | E-01 (95行目), E-02 | ○ |
| C-02 | EFLoginServiceがログインサービスを提供 | E-02, E-03 | ○ |
| C-03 | FindByUsernameでメールアドレス検索 | E-02 (14-17行目) | ○ |
| C-04 | ValidateCredentialsでパスワード検証 | E-02 (19-22行目) | ○ |
| C-05 | SignInAsync/SignInで認証状態確立 | E-02 (24-32行目) | ○ |
| C-06 | AllowAnonymous属性で匿名アクセス許可 | E-01 (7行目) | ○ |
| C-07 | ValidateAntiForgeryToken属性でCSRF対策 | E-01 (60行目) | ○ |
| C-08 | SecurityHeaders属性でセキュリティヘッダー付与 | E-01 (6行目) | ○ |
| C-09 | lockoutOnFailure: trueでロックアウト有効 | E-01 (95行目) | ○ |
| C-10 | UserLoginSuccessEvent発行 | E-01 (99行目) | ○ |
| C-11 | UserLoginFailureEvent発行 | E-01 (130行目) | ○ |
| C-12 | BuildLoginViewModelAsyncでビューモデル構築 | E-01 (206-262行目) | ○ |
| C-13 | 外部認証プロバイダーサポート | E-01 (229-237行目) | ○ |
| C-14 | ReturnUrlのローカルURL検証 | E-01 (115行目) | ○ |
| C-15 | ApplicationUserがIdentityUserを継承 | E-04 (4行目) | ○ |
| C-16 | ApplicationUserにカード情報フィールド | E-04 (7-15行目) | ○ |
| C-17 | ApplicationUserに住所フィールド | E-04 (17-25行目) | ○ |
| C-18 | LoginInputModelにRequired属性 | E-05 (9-12行目) | ○ |
| C-19 | LoginInputModelにRememberLogin | E-05 (13行目) | ○ |
| C-20 | LoginViewModelがLoginInputModelを継承 | E-06 (7行目) | ○ |
| C-21 | ApplicationDbContextがIdentityDbContextを継承 | E-07 (8行目) | ○ |
| C-22 | 画面No.6,9がログイン画面として関連 | E-09 | ○ |
| C-23 | 機能No.31が認証・認可カテゴリに分類 | E-08 | ○ |
| C-24 | ログイン処理は2秒以内の応答 | **根拠なし** | △ |
| C-25 | アカウントロックアウト期間の詳細設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（2秒以内）は一般的なWeb標準を参照した推定値であり、プロジェクト固有の要件定義書での確認が必要
  - 候補：非機能要件定義書 / パフォーマンステスト結果 / SLA文書
- アカウントロックアウトの詳細設定（ロックアウト期間、失敗回数閾値）はASP.NET Core Identityのデフォルト値を使用と推定
  - 候補：appsettings.json / Program.cs / ASP.NET Core Identity公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証処理の基本フローは十分な根拠あり
- 1: 中リスク - パフォーマンス要件の具体的な根拠がないため、負荷テスト時に確認が必要
- 0: 低リスク - セキュリティ機能（CSRF対策、ロックアウト）は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AccountController.Login (POST)メソッドの認証フローが正しく記載されているか確認
- [ ] EFLoginServiceの各メソッドの役割が正確に記載されているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] パフォーマンス要件の妥当性を非機能要件と照合
- [ ] ロックアウト設定がプロジェクトのセキュリティポリシーと整合しているか確認
