---
generated_at: 2026-01-14 21:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-ユーザー検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Services/EFLoginService.cs`
- E-02: `src/Identity.API/Services/ILoginService.cs`
- E-03: `src/Identity.API/Models/ApplicationUser.cs`
- E-04: `src/Identity.API/Data/ApplicationDbContext.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FindByUsernameでメールアドレス検索 | E-01 (14-17行目) | ○ |
| C-02 | UserManager.FindByEmailAsyncを使用 | E-01 (16行目) | ○ |
| C-03 | ILoginService<T>でジェネリック定義 | E-02 (3行目) | ○ |
| C-04 | FindByUsernameがTask<T>を返却 | E-02 (7行目) | ○ |
| C-05 | ApplicationUserがIdentityUserを継承 | E-03 (4行目) | ○ |
| C-06 | CardNumberフィールドが存在 | E-03 (7行目) | ○ |
| C-07 | SecurityNumberフィールドが存在 | E-03 (9行目) | ○ |
| C-08 | Expirationフィールドが存在 | E-03 (11行目) | ○ |
| C-09 | 住所関連フィールドが存在 | E-03 (17-25行目) | ○ |
| C-10 | Name/LastNameフィールドが存在 | E-03 (27-29行目) | ○ |
| C-11 | ApplicationDbContextがIdentityDbContextを継承 | E-04 (8行目) | ○ |
| C-12 | 機能No.32がユーザー検索として定義 | E-05 | ○ |
| C-13 | 認証・認可カテゴリに分類 | E-05 | ○ |
| C-14 | ユーザーが存在しない場合nullを返却 | E-01, ASP.NET Core Identity仕様 | ○ |
| C-15 | 正規化されたメールアドレスで検索 | ASP.NET Core Identity仕様 | ○ |
| C-16 | NormalizedEmailにインデックス存在 | ASP.NET Core Identity既定動作 | ○ |
| C-17 | 読み取り専用操作 | E-01 | ○ |
| C-18 | 検索処理は100ms以内の応答 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（100ms以内）は一般的なデータベース検索の推定値であり、プロジェクト固有の要件定義書での確認が必要
  - 候補：非機能要件定義書 / パフォーマンステスト結果 / データベースインデックス設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ユーザー検索の基本実装は十分な根拠あり
- 0: 低リスク - ASP.NET Core Identityの標準実装を使用しており信頼性が高い
- 1: 中リスク - パフォーマンス要件は実測による確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] EFLoginService.FindByUsernameの実装が正しく記載されているか確認
- [ ] ApplicationUserのフィールド定義が実際のモデルと一致しているか確認
- [ ] UserManager.FindByEmailAsyncの動作仕様がASP.NET Core Identityドキュメントと整合しているか確認
- [ ] パフォーマンス要件の妥当性を実測または非機能要件と照合
