---
generated_at: 2026-01-14 21:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：33-認証情報検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **PBKDF2の反復回数設定**：プロジェクト固有の設定値確認が必要
  2. **パフォーマンス要件（100-500ms）**：実測による確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Services/EFLoginService.cs`
- E-02: `src/Identity.API/Services/ILoginService.cs`
- E-03: `src/Identity.API/Models/ApplicationUser.cs`
- E-04: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: ASP.NET Core Identity公式ドキュメント（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ValidateCredentialsでパスワード検証 | E-01 (19-22行目) | ○ |
| C-02 | UserManager.CheckPasswordAsyncを使用 | E-01 (21行目) | ○ |
| C-03 | ILoginService<T>でValidateCredentials定義 | E-02 (5行目) | ○ |
| C-04 | 戻り値がTask<bool> | E-02 (5行目) | ○ |
| C-05 | ApplicationUserがIdentityUserを継承 | E-03 (4行目) | ○ |
| C-06 | PasswordHashはIdentityUserから継承 | E-06 (ASP.NET Core Identity仕様) | ○ |
| C-07 | AccountControllerでPasswordSignInAsync使用 | E-04 (95行目) | ○ |
| C-08 | 機能No.33が認証情報検証として定義 | E-05 | ○ |
| C-09 | 認証・認可カテゴリに分類 | E-05 | ○ |
| C-10 | PBKDF2-SHA256がデフォルトで使用 | E-06 | ○ |
| C-11 | タイミング攻撃対策が実装 | E-06 (ASP.NET Core Identity標準機能) | ○ |
| C-12 | ソルトがパスワードハッシュに含まれる | E-06 | ○ |
| C-13 | データベースアクセスなし（引数オブジェクト使用） | E-01 | ○ |
| C-14 | bool結果を返却 | E-01 (21行目) | ○ |
| C-15 | PBKDF2の反復回数設定 | **根拠なし** | △ |
| C-16 | 検証処理は100-500msで完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PBKDF2の反復回数はASP.NET Core Identityのデフォルト値（10,000回）を使用と推定、プロジェクト固有のカスタマイズ有無は要確認
  - 候補：Program.cs / appsettings.json / ASP.NET Core Identityオプション設定
- パフォーマンス要件（100-500ms）は一般的なPBKDF2処理時間の推定値、実測での確認が必要
  - 候補：パフォーマンステスト結果 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パスワード検証の基本実装は十分な根拠あり
- 0: 低リスク - ASP.NET Core Identityの標準実装を使用しておりセキュリティは確保
- 1: 中リスク - PBKDF2の反復回数がセキュリティ要件を満たすか確認が必要
- 1: 中リスク - パフォーマンス要件は実測による確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] EFLoginService.ValidateCredentialsの実装が正しく記載されているか確認
- [ ] UserManager.CheckPasswordAsyncの動作仕様がASP.NET Core Identityドキュメントと整合しているか確認
- [ ] PBKDF2の反復回数がプロジェクトのセキュリティポリシーと整合しているか確認
- [ ] パフォーマンス要件の妥当性を実測または非機能要件と照合
