---
generated_at: 2026-01-14 21:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：34-サインイン処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **クッキー有効期限設定**：具体的な設定値の確認が必要
  2. **パフォーマンス要件（50ms以内）**：実測による確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Services/EFLoginService.cs`
- E-02: `src/Identity.API/Services/ILoginService.cs`
- E-03: `src/Identity.API/Models/ApplicationUser.cs`
- E-04: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: ASP.NET Core Identity公式ドキュメント（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SignInでサインイン状態確立 | E-01 (24-27行目) | ○ |
| C-02 | SignInAsyncでカスタムプロパティ対応 | E-01 (29-32行目) | ○ |
| C-03 | SignInManager.SignInAsyncを使用 | E-01 (26, 31行目) | ○ |
| C-04 | ILoginService<T>でSignIn/SignInAsync定義 | E-02 (9, 11行目) | ○ |
| C-05 | SignInは永続ログイン=true固定 | E-01 (26行目) | ○ |
| C-06 | authenticationMethod引数をサポート | E-01 (29行目), E-02 (11行目) | ○ |
| C-07 | AccountControllerでSignInManager使用 | E-04 (11, 95行目) | ○ |
| C-08 | SignOutAsyncでログアウト処理 | E-04 (175行目) | ○ |
| C-09 | 機能No.34がサインイン処理として定義 | E-05 | ○ |
| C-10 | 画面No.9,14,15,18が関連 | E-06 | ○ |
| C-11 | HttpOnlyクッキーを使用 | E-07 (ASP.NET Core Identity標準) | ○ |
| C-12 | Secureフラグを設定 | E-07 | ○ |
| C-13 | DataProtection APIで暗号化 | E-07 | ○ |
| C-14 | ClaimsPrincipalが構築される | E-07 | ○ |
| C-15 | 認証・認可カテゴリに分類 | E-05 | ○ |
| C-16 | データベースアクセスなし | E-01 | ○ |
| C-17 | クッキー有効期限の具体的な設定値 | **根拠なし** | △ |
| C-18 | サインイン処理は50ms以内の応答 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- クッキー有効期限の具体的な設定値はASP.NET Core Identityのデフォルト値または設定ファイルでの確認が必要
  - 候補：Program.cs / appsettings.json / CookieAuthenticationOptions設定
- パフォーマンス要件（50ms以内）は一般的なセッション管理処理の推定値、実測での確認が必要
  - 候補：パフォーマンステスト結果 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サインイン処理の基本実装は十分な根拠あり
- 0: 低リスク - ASP.NET Core Identityの標準実装を使用しておりセキュリティは確保
- 1: 中リスク - クッキー有効期限がセキュリティポリシーと整合しているか確認が必要
- 0: 低リスク - パフォーマンス要件は軽量処理のため問題なし

## 6) レビュアーチェックリスト（最小）
- [ ] EFLoginService.SignIn/SignInAsyncの実装が正しく記載されているか確認
- [ ] SignInManager.SignInAsyncの動作仕様がASP.NET Core Identityドキュメントと整合しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] クッキー有効期限設定がプロジェクトのセキュリティポリシーと整合しているか確認
