---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：35-Webhook一覧取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（500ms以内）**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-02: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-03: `src/Webhooks.API/Model/WebhookType.cs`
- E-04: `src/Webhooks.API/Infrastructure/WebhooksContext.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /api/webhooksでサブスクリプション一覧取得 | E-01 (13-18行目) | ○ |
| C-02 | ユーザーIDでフィルタリング | E-01 (16行目) | ○ |
| C-03 | ClaimsPrincipalからユーザーID取得 | E-01 (15行目) | ○ |
| C-04 | TypedResults.Ok(data)で返却 | E-01 (17行目) | ○ |
| C-05 | WebhookSubscriptionにId, Type, Date, DestUrl, Token, UserId | E-02 (5-13行目) | ○ |
| C-06 | DestUrlにRequired属性 | E-02 (10行目) | ○ |
| C-07 | UserIdにRequired属性 | E-02 (13行目) | ○ |
| C-08 | WebhookType列挙型（CatalogItemPriceChange, OrderShipped, OrderPaid） | E-03 (5-7行目) | ○ |
| C-09 | DbSet<WebhookSubscription> Subscriptions | E-04 (10行目) | ○ |
| C-10 | UserIdにインデックス | E-04 (16行目) | ○ |
| C-11 | Typeにインデックス | E-04 (17行目) | ○ |
| C-12 | 機能No.35がWebhook一覧取得として定義 | E-05 | ○ |
| C-13 | Webhook管理カテゴリに分類 | E-05 | ○ |
| C-14 | 画面No.21（ホーム画面）が関連 | E-06 | ○ |
| C-15 | ルートグループ/api/webhooks | E-01 (11行目) | ○ |
| C-16 | Minimal APIsで実装 | E-01 | ○ |
| C-17 | Entity Framework Coreによるデータアクセス | E-04 | ○ |
| C-18 | 検索処理は500ms以内の応答 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（500ms以内）は一般的なWeb API応答時間の推定値、プロジェクト固有の要件定義書での確認が必要
  - 候補：非機能要件定義書 / パフォーマンステスト結果 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API実装の基本構造は十分な根拠あり
- 0: 低リスク - ユーザースコープによるデータ分離が実装済み
- 0: 低リスク - インデックス設定によりパフォーマンス最適化済み

## 6) レビュアーチェックリスト（最小）
- [ ] WebHooksApi.csのGET /エンドポイント実装が正しく記載されているか確認
- [ ] WebhookSubscriptionのフィールド定義が実際のモデルと一致しているか確認
- [ ] WebhooksContextのインデックス設定が正しく記載されているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] パフォーマンス要件の妥当性を非機能要件と照合
