---
generated_at: 2026-01-14 21:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：37-Webhook登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（3秒以内）**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-02: `src/Webhooks.API/Model/WebhookSubscriptionRequest.cs`
- E-03: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-04: `src/Webhooks.API/Model/WebhookType.cs`
- E-05: `src/Webhooks.API/Extensions/RouteHandlerBuilderExtensions.cs`
- E-06: `src/Webhooks.API/Services/IGrantUrlTesterService.cs`
- E-07: `src/Webhooks.API/Services/GrantUrlTesterService.cs`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /api/webhooksで登録 | E-01 (35-64行目) | ○ |
| C-02 | Grant URL検証を実行 | E-01 (41行目) | ○ |
| C-03 | grantUrlTester.TestGrantUrlを呼び出し | E-01 (41行目) | ○ |
| C-04 | サブスクリプションエンティティ作成 | E-01 (45-52行目) | ○ |
| C-05 | DateTime.UtcNowで登録日時記録 | E-01 (47行目) | ○ |
| C-06 | user.GetUserId()でユーザーID取得 | E-01 (51行目) | ○ |
| C-07 | context.Add(subscription)でDB追加 | E-01 (54行目) | ○ |
| C-08 | SaveChangesAsync()で保存 | E-01 (55行目) | ○ |
| C-09 | 201 Created + Locationヘッダー返却 | E-01 (57行目) | ○ |
| C-10 | Grant検証失敗時400 Bad Request | E-01 (61行目) | ○ |
| C-11 | ValidateWebhookSubscriptionRequestフィルター | E-01 (64行目) | ○ |
| C-12 | WebhookSubscriptionRequestにUrl, Token, Event, GrantUrl | E-02 (5-8行目) | ○ |
| C-13 | IValidatableObjectを実装 | E-02 (3行目) | ○ |
| C-14 | Uri.IsWellFormedUriStringでURL検証 | E-02 (12-19行目) | ○ |
| C-15 | Enum.TryParseでイベントタイプ検証 | E-02 (22-25行目) | ○ |
| C-16 | エンドポイントフィルターでバリデーション実行 | E-05 (5-25行目) | ○ |
| C-17 | TypedResults.ValidationProblemでエラー返却 | E-05 (20行目) | ○ |
| C-18 | 機能No.37がWebhook登録として定義 | E-08 | ○ |
| C-19 | 画面No.22（Webhook追加画面）が関連 | E-09 | ○ |
| C-20 | IGrantUrlTesterService.TestGrantUrlインターフェース | E-06 (5行目) | ○ |
| C-21 | Enum.Parseでイベントタイプ変換 | E-01 (50行目) | ○ |
| C-22 | 登録処理は3秒以内の応答 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（3秒以内）は外部Grant URL検証を含む推定値、プロジェクト固有の要件定義書での確認が必要
  - 候補：非機能要件定義書 / パフォーマンステスト結果 / SLA文書 / Grant URL検証のタイムアウト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 登録処理の基本構造は十分な根拠あり
- 0: 低リスク - バリデーションロジックが詳細に実装済み
- 0: 低リスク - Grant URL検証によるセキュリティ対策が実装済み
- 1: 中リスク - 外部通信を含むためパフォーマンス要件の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] WebHooksApi.csのPOSTエンドポイント実装が正しく記載されているか確認
- [ ] WebhookSubscriptionRequestのバリデーションロジックが正しく記載されているか確認
- [ ] ValidateWebhookSubscriptionRequestフィルターの動作が正しく記載されているか確認
- [ ] Grant URL検証との連携が正しく記載されているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] パフォーマンス要件の妥当性を非機能要件と照合
