---
generated_at: 2026-01-14 21:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：39-Webhook送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **リトライ機能の将来的な追加**：設計判断の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/Services/WebhooksSender.cs`
- E-02: `src/Webhooks.API/Services/IWebhooksSender.cs`
- E-03: `src/Webhooks.API/Services/WebhooksRetriever.cs`
- E-04: `src/Webhooks.API/Services/IWebhooksRetriever.cs`
- E-05: `src/Webhooks.API/Model/WebhookData.cs`
- E-06: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-07: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-08: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs`
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SendAllで並列送信 | E-01 (5-11行目) | ○ |
| C-02 | IHttpClientFactoryを使用 | E-01 (3行目) | ○ |
| C-03 | HttpClientで送信 | E-01 (7, 32行目) | ○ |
| C-04 | Task.WhenAllで並列実行 | E-01 (10行目) | ○ |
| C-05 | X-eshop-whtokenヘッダー付与 | E-01 (24行目) | ○ |
| C-06 | トークンが非空の場合のみヘッダー付与 | E-01 (22-25行目) | ○ |
| C-07 | POST method使用 | E-01 (18行目) | ○ |
| C-08 | application/json Content-Type | E-01 (19行目) | ○ |
| C-09 | IWebhooksSender.SendAllインターフェース | E-02 (5行目) | ○ |
| C-10 | GetSubscriptionsOfTypeでタイプ別取得 | E-03 (5-8行目) | ○ |
| C-11 | WHERE Type = @type でフィルタリング | E-03 (7行目) | ○ |
| C-12 | WebhookData.When = DateTime.UtcNow | E-05 (13行目) | ○ |
| C-13 | WebhookData.Payload = JsonSerializer.Serialize | E-05 (15行目) | ○ |
| C-14 | WebhookData.Type = hookType.ToString() | E-05 (14行目) | ○ |
| C-15 | OrderStatusChangedToPaidIntegrationEventHandlerでOrderPaid処理 | E-07 (8-17行目) | ○ |
| C-16 | retriever.GetSubscriptionsOfType呼び出し | E-07 (10行目) | ○ |
| C-17 | new WebhookData()でデータ構築 | E-07 (14行目) | ○ |
| C-18 | sender.SendAll()呼び出し | E-07 (16行目) | ○ |
| C-19 | OrderStatusChangedToShippedIntegrationEventHandlerでOrderShipped処理 | E-08 (8-17行目) | ○ |
| C-20 | 機能No.39がWebhook送信として定義 | E-09 | ○ |
| C-21 | Webhook管理カテゴリに分類 | E-09 | ○ |
| C-22 | リトライ機能の将来的な追加が望ましい | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ機能の追加に関する設計判断は、アーキテクチャ方針やプロダクトバックログでの確認が必要
  - 候補：アーキテクチャ設計書 / プロダクトバックログ / 技術負債管理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 送信処理の基本構造は十分な根拠あり
- 0: 低リスク - 並列送信によるパフォーマンス最適化が実装済み
- 1: 中リスク - Fire-and-Forget実装のため、送信失敗時の検出・リトライが課題
- 0: 低リスク - トークンヘッダーによる認証が実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] WebhooksSender.SendAllの並列処理が正しく記載されているか確認
- [ ] OnSendDataのHTTPリクエスト構築が正しく記載されているか確認
- [ ] X-eshop-whtokenヘッダーの付与条件が正しく記載されているか確認
- [ ] 統合イベントハンドラーとの連携が正しく記載されているか確認
- [ ] リトライ機能の要否についてアーキテクチャ方針と照合
