---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：41-カタログ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値目標**：具体的な応答時間の記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/Catalog/Catalog.razor` - メインページコンポーネント
- E-02: `src/WebAppComponents/Catalog/CatalogSearch.razor` - フィルターコンポーネント
- E-03: `src/WebAppComponents/Catalog/CatalogListItem.razor` - 商品カードコンポーネント
- E-04: `src/WebAppComponents/Services/CatalogService.cs` - API通信サービス
- E-05: `src/WebAppComponents/Catalog/CatalogItem.cs` - データ型定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルートURL"/"にマッピングされている | E-01 1行目 `@page "/"` | ○ |
| C-02 | ページサイズは9件 | E-01 38行目 `const int PageSize = 9` | ○ |
| C-03 | ストリームレンダリングを使用 | E-01 4行目 `@attribute [StreamRendering]` | ○ |
| C-04 | page, brand, typeのクエリパラメータを受け取る | E-01 40-47行目 SupplyParameterFromQuery属性 | ○ |
| C-05 | CatalogService.GetCatalogItemsで商品一覧を取得 | E-01 56行目、E-04 17-22行目 | ○ |
| C-06 | 並列でブランド・タイプを取得 | E-02 57-59行目 Task.WhenAll | ○ |
| C-07 | GetBrandsでブランド一覧を取得 | E-04 38-43行目 | ○ |
| C-08 | GetTypesでタイプ一覧を取得 | E-04 45-50行目 | ○ |
| C-09 | 商品詳細画面への遷移 | E-03 5行目 ItemHelper.Url(Item) | ○ |
| C-10 | IProductImageUrlProviderで画像URL取得 | E-03 7行目 ProductImages.GetProductImageUrl | ○ |
| C-11 | ページ番号未指定時は1として扱う | E-01 57行目 Page.GetValueOrDefault(1) | ○ |
| C-12 | APIへのページインデックスは0始まり | E-01 57行目 - 1 で変換 | ○ |
| C-13 | CatalogResultはPageIndex, PageSize, Count, Dataを持つ | E-05 14行目 record定義 | ○ |
| C-14 | CatalogItemはId, Name等のプロパティを持つ | E-05 3-12行目 record定義 | ○ |
| C-15 | CatalogBrandはId, Brandを持つ | E-05 15行目 record定義 | ○ |
| C-16 | CatalogItemTypeはId, Typeを持つ | E-05 16行目 record定義 | ○ |
| C-17 | remoteServiceBaseUrlは"api/catalog/" | E-04 9行目 | ○ |
| C-18 | brandパラメータでフィルタリング可能 | E-04 61-62行目 クエリパラメータ組み立て | ○ |
| C-19 | typeパラメータでフィルタリング可能 | E-04 56-58行目 クエリパラメータ組み立て | ○ |
| C-20 | フィルター選択時にURLクエリパラメータを変更 | E-02 64-74行目 BrandUri/TypeUri | ○ |
| C-21 | ページネーション計算でMath.Ceilingを使用 | E-01 52行目 | ○ |
| C-22 | 認証不要の公開画面 | E-01 Authorize属性なし | ○ |
| C-23 | 商品一覧取得機能と連携 | E-06 画面No1, 機能No1 | ○ |
| C-24 | 商品タイプ一覧取得機能と連携 | E-06 画面No1, 機能No9 | ○ |
| C-25 | 具体的な応答時間要件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値目標
  - 候補：NFR（非機能要件）定義書 / SLA定義書 / 性能テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様の大部分はソースコードから直接確認可能
- 1: 中リスク - パフォーマンス要件の数値目標が未定義のため、本番環境での性能問題発生時に基準がない

## 6) レビュアーチェックリスト（最小）
- [ ] ページサイズ9件は業務要件として適切か
- [ ] フィルター条件の組み合わせパターンが網羅されているか
- [ ] 商品画像URLの取得方法が本番環境で正しく動作するか
- [ ] ストリームレンダリングの挙動がユーザー体験として適切か
