---
generated_at: 2026-01-14 21:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-注文履歴画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/Orders.razor` - メインページコンポーネント
- E-02: `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` - リアルタイム更新
- E-03: `src/WebApp/Services/OrderingService.cs` - 注文API通信
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL /user/orders でルーティング | E-01 1行目 `@page "/user/orders"` | ○ |
| C-02 | 認証必須 | E-01 2行目 `@attribute [Authorize]` | ○ |
| C-03 | ストリームレンダリング使用 | E-01 3行目 `@attribute [StreamRendering]` | ○ |
| C-04 | OrdersRefreshOnStatusChangeコンポーネント使用 | E-01 8行目 `<OrdersRefreshOnStatusChange />` | ○ |
| C-05 | OnInitializedAsyncで注文取得 | E-01 54-57行目 | ○ |
| C-06 | OrderingService.GetOrdersを呼び出し | E-01 56行目 | ○ |
| C-07 | OrderRecord型でOrderNumber, Date, Status, Total | E-03 21-25行目 | ○ |
| C-08 | 注文なし時のメッセージ表示 | E-01 16-17行目 | ○ |
| C-09 | 価格は小数点2桁表示 | E-01 38行目 `.ToString("0.00")` | ○ |
| C-10 | ステータス小文字でCSSクラス | E-01 41行目 `order.Status.ToLower()` | ○ |
| C-11 | InteractiveServerレンダリング | E-02 1行目 `@rendermode InteractiveServer` | ○ |
| C-12 | OnAfterRenderAsyncでSignalR購読 | E-02 10-20行目 | ○ |
| C-13 | GetBuyerIdAsyncでbuyerID取得 | E-02 14行目 | ○ |
| C-14 | SubscribeToOrderStatusNotifications呼び出し | E-02 17行目 | ○ |
| C-15 | HandleOrderStatusChangedでNav.Refresh | E-02 27行目 | ○ |
| C-16 | IDisposable実装で購読解除 | E-02 6, 37-40行目 | ○ |
| C-17 | 例外時はDispatchExceptionAsync | E-02 33行目 | ○ |
| C-18 | ユーザー注文履歴取得機能(No.20)と連携 | E-04 画面No5, 機能No20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様の全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SignalR接続が切断された場合の再接続処理があるか
- [ ] 注文履歴の件数が多い場合のページネーションがあるか
- [ ] ステータス表示の日本語化/多言語対応が必要か
- [ ] Nav.Refresh()による画面リロードのユーザー体験が適切か
