---
generated_at: 2026-01-14 21:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-AIチャットボット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Chatbot/Chatbot.razor` - チャットUIコンポーネント
- E-02: `src/WebApp/Components/Chatbot/ChatState.cs` - AI対話ロジック
- E-03: `src/WebAppComponents/Services/CatalogService.cs` - 商品検索API
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InteractiveServerRenderMode prerender:false | E-01 1行目 | ○ |
| C-02 | IChatClientの存在確認 | E-01 56-57行目 `GetService<IChatClient>` | ○ |
| C-03 | 設定不足時にメッセージ表示 | E-01 28-30行目 `missingConfiguration` | ○ |
| C-04 | ChatState初期化 | E-01 60行目 `new ChatState(...)` | ○ |
| C-05 | SendMessageAsyncでメッセージ送信 | E-01 68-79行目 | ○ |
| C-06 | ChatClient.GetResponseAsyncを呼び出し | E-02 78行目 | ○ |
| C-07 | AIFunctionFactory.Createでツール登録 | E-02 43-47行目 | ○ |
| C-08 | 4つのツール関数（GetUserInfo, SearchCatalog, AddToCart, GetCartContents） | E-02 43-47行目 | ○ |
| C-09 | システムプロンプトでAdventureWorks専用 | E-02 52-60行目 | ○ |
| C-10 | 話題制限「AdventureWorks以外は拒否」 | E-02 54-59行目 | ○ |
| C-11 | GetUserInfoでClaimsPrincipal参照 | E-02 96-115行目 | ○ |
| C-12 | SearchCatalogでセマンティック検索 | E-02 117-134行目, E-03 31-36行目 | ○ |
| C-13 | 検索結果上限8件 | E-02 122行目 `0, 8, productDescription` | ○ |
| C-14 | AddToCartでBasketState.AddAsync | E-02 136-153行目 | ○ |
| C-15 | 未認証時のエラーメッセージ | E-02 145-147行目 `Unauthenticated` | ○ |
| C-16 | GetCartContentsでBasketState.GetBasketItemsAsync | E-02 155-167行目 | ○ |
| C-17 | エラー時にログ出力 | E-02 169-177行目 `_logger.LogError` | ○ |
| C-18 | AI応答エラー時にエラーメッセージ表示 | E-02 90行目 `unexpected error` | ○ |
| C-19 | MessageProcessor.AllowImagesで画像処理 | E-01 24行目 | ○ |
| C-20 | JSモジュールでスクロール制御 | E-01 84行目 `scrollToEnd` | ○ |
| C-21 | JSモジュールでEnterキー送信 | E-01 89行目 `submitOnEnter` | ○ |
| C-22 | AI商品検索機能(No.6)と連携 | E-04 画面No8, 機能No6 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - AI機能はOpenAI/Azure OpenAIの設定が必要で、未設定時は機能無効
- 1: 中リスク - AIの応答内容の品質管理が必要（不適切な応答の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] Azure OpenAI/OpenAIのAPI設定手順が文書化されているか
- [ ] AIの応答が不適切な場合の対処方法があるか
- [ ] セマンティック検索の精度が業務要件を満たしているか
- [ ] カート追加の未認証エラーメッセージがユーザーフレンドリーか
