---
generated_at: 2026-01-14 22:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/LogIn.razor` - ログインリダイレクト処理
- E-02: `src/WebApp/Components/Pages/Item/ItemPage.razor` - ログインリダイレクト呼び出し元
- E-03: `src/WebApp/Components/Layout/UserMenu.razor` - ログインリンク
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL /user/login でルーティング | E-01 1行目 `@page "/user/login"` | ○ |
| C-02 | 認証必須（[Authorize]属性） | E-01 3行目 `@attribute [Authorize]` | ○ |
| C-03 | returnUrlをクエリパラメータで受け取り | E-01 5-6行目 SupplyParameterFromQuery | ○ |
| C-04 | returnUrl未指定時は"/"にデフォルト | E-01 13行目 `ReturnUrl ?? "/"` | ○ |
| C-05 | 絶対URLは"/"に変換 | E-01 14-15行目 `url.IsAbsoluteUri ? "/" : returnUrl` | ○ |
| C-06 | Nav.NavigateToでリダイレクト | E-01 15行目 | ○ |
| C-07 | Urlメソッドでログイン用URL生成 | E-01 19-20行目 | ○ |
| C-08 | returnUrlをUriエスケープ | E-01 20行目 `Uri.EscapeDataString` | ○ |
| C-09 | ToBaseRelativePathで相対パス取得 | E-01 20行目 `nav.ToBaseRelativePath(nav.Uri)` | ○ |
| C-10 | ItemPageからログインリダイレクト | E-02 94行目 `Pages.User.LogIn.Url(Nav)` | ○ |
| C-11 | UserMenuでログインリンク | E-03 23行目 `href="@Pages.User.LogIn.Url(Nav)"` | ○ |
| C-12 | UriKind.RelativeOrAbsoluteでURI解析 | E-01 14行目 | ○ |
| C-13 | HttpContextをCascadingParameter | E-01 8-9行目 | ○ |
| C-14 | base.OnInitializedAsyncを呼び出し | E-01 16行目 | ○ |
| C-15 | ユーザーログイン機能(No.31)と連携 | E-04 画面No6, 機能No31 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リダイレクト処理はシンプルで、セキュリティ対策（相対URLのみ許可）も実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] オープンリダイレクト攻撃に対する防御が十分か（絶対URL→"/"変換）
- [ ] Identity.APIとの認証連携が正しく設定されているか
- [ ] returnUrlが長すぎる場合の処理が適切か
- [ ] 認証失敗時のユーザー体験が適切か
