---
generated_at: 2026-01-14 22:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-ログアウト処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/LogOut.razor` - ログアウトエンドポイント
- E-02: `src/WebApp/Components/Layout/UserMenu.razor` - ログアウトUI
- E-03: `src/WebApp/Services/LogOutService.cs` - ログアウト処理実装
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL /user/logout でエンドポイント定義 | E-01 1行目 `@page "/user/logout"` | ○ |
| C-02 | LogOut.razorはUIなし（フォーム受付のみ） | E-01 2-5行目 コメント | ○ |
| C-03 | UserMenuにログアウトフォーム | E-02 15-18行目 | ○ |
| C-04 | AuthorizeView内に配置 | E-02 8-21行目 | ○ |
| C-05 | action="user/logout"でPOST送信 | E-02 15行目 | ○ |
| C-06 | AntiforgeryTokenでCSRF対策 | E-02 16行目 `<AntiforgeryToken />` | ○ |
| C-07 | LogOutAsyncで@onsubmit処理 | E-02 15行目 `@onsubmit="LogOutAsync"` | ○ |
| C-08 | LogOutService.LogOutAsyncを呼び出し | E-02 32行目 | ○ |
| C-09 | HttpContextをCascadingParameter | E-02 28-29行目 | ○ |
| C-10 | SignOutAsync Cookie認証 | E-03 11行目 `CookieAuthenticationDefaults.AuthenticationScheme` | ○ |
| C-11 | SignOutAsync OpenIdConnect認証 | E-03 12行目 `OpenIdConnectDefaults.AuthenticationScheme` | ○ |
| C-12 | using Microsoft.AspNetCore.Authentication.Cookies | E-03 2行目 | ○ |
| C-13 | using Microsoft.AspNetCore.Authentication.OpenIdConnect | E-03 3行目 | ○ |
| C-14 | ログアウト処理機能(No.48)と連携 | E-04 画面No7, 機能No48 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログアウト処理はシンプルでセキュリティ対策（CSRF、両認証のサインアウト）も実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] Cookie認証とOpenID Connect両方のサインアウトが正しく実行されるか
- [ ] Identity.APIのログアウト完了画面からの戻り先が正しいか
- [ ] AntiforgeryTokenの検証が有効か
- [ ] ログアウト後のセッション残存がないか
