---
generated_at: 2026-01-14 22:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-ホーム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/Home/Home.razor` - ホーム画面メインコンポーネント
- E-02: `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` - 登録済みWebhook一覧
- E-03: `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` - 受信メッセージ一覧
- E-04: `src/WebhookClient/Services/WebHooksClient.cs` - Webhook API通信
- E-05: `src/WebhookClient/Services/HooksRepository.cs` - 受信メッセージ管理
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL / でルーティング | E-01 1行目 `@page "/"` | ○ |
| C-02 | AuthorizeViewで認証状態切替 | E-01 8-17行目 | ○ |
| C-03 | 認証済み時にRegisteredHooks表示 | E-01 10行目 `<RegisteredHooks />` | ○ |
| C-04 | 未認証時にログイン促進メッセージ | E-01 14-16行目 | ○ |
| C-05 | ReceivedMessages表示 | E-01 22行目 `<ReceivedMessages />` | ○ |
| C-06 | add-webhookへのリンク | E-01 11行目 `href="add-webhook"` | ○ |
| C-07 | QuickGridで一覧表示（RegisteredHooks） | E-02 9-13行目 | ○ |
| C-08 | Date列がデフォルトソート降順 | E-02 10行目 `IsDefaultSortColumn` `Descending` | ○ |
| C-09 | WebhooksClient.LoadWebhooksを呼び出し | E-02 25行目 | ○ |
| C-10 | QuickGridで一覧表示（ReceivedMessages） | E-03 9-13行目 | ○ |
| C-11 | HooksRepository.Subscribeで購読 | E-03 30行目 | ○ |
| C-12 | HooksRepository.GetAllでデータ取得 | E-03 35行目 | ○ |
| C-13 | OnMessageReceivedAsyncで更新 | E-03 37-47行目 | ○ |
| C-14 | IDisposable実装で購読解除 | E-03 3, 49-52行目 | ○ |
| C-15 | LoadWebhooksでGET /api/webhooks | E-04 10-13行目 | ○ |
| C-16 | ConcurrentQueueでメッセージ管理 | E-05 7行目 | ○ |
| C-17 | AddNewで購読者に通知 | E-05 10-28行目 | ○ |
| C-18 | Webhook一覧取得機能(No.35)と連携 | E-06 画面No21, 機能No35 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様の全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HooksRepositoryのインメモリ実装が本番環境で問題ないか
- [ ] 大量の受信メッセージがある場合のメモリ使用量が適切か
- [ ] 購読解除のDispose処理が確実に実行されるか
- [ ] Webhooks.APIとの認証連携が正しく動作するか
