---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-Webhook登録画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/AddWebhook.razor` - Webhook登録画面
- E-02: `src/WebhookClient/Services/WebHooksClient.cs` - Webhook API通信
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL /add-webhook でルーティング | E-01 1行目 `@page "/add-webhook"` | ○ |
| C-02 | WebhookClientOptionsからデフォルトトークン取得 | E-01 3, 30行目 | ○ |
| C-03 | トークン入力フィールド | E-01 14行目 `@bind="@token"` | ○ |
| C-04 | Registerボタンでフォーム送信 | E-01 16行目 | ○ |
| C-05 | トークン空時は処理中断 | E-01 35-38行目 | ○ |
| C-06 | baseUrlはSelfUrlまたはNav.BaseUri | E-01 41-43行目 | ○ |
| C-07 | grantUrl = {baseUrl}check | E-01 44行目 | ○ |
| C-08 | url = {baseUrl}webhook-received | E-01 45行目 | ○ |
| C-09 | Event = "OrderPaid"固定 | E-01 49行目 | ○ |
| C-10 | WebhookSubscriptionRequestを作成 | E-01 47-53行目 | ○ |
| C-11 | WebhooksClient.AddWebHookAsync呼び出し | E-01 55行目 | ○ |
| C-12 | 成功時にホーム画面へリダイレクト | E-01 58行目 `Nav.NavigateTo("")` | ○ |
| C-13 | 失敗時にエラーメッセージ表示 | E-01 62行目 | ○ |
| C-14 | エラーメッセージにステータスコードと理由含む | E-01 62行目 `StatusCode`, `ReasonPhrase` | ○ |
| C-15 | AddWebHookAsyncでPOST /api/webhooks | E-02 7行目 | ○ |
| C-16 | Webhook登録機能(No.37)と連携 | E-03 画面No22, 機能No37 | ○ |
| C-17 | Grant URL検証機能(No.40)と連携 | E-03 画面No22, 機能No40 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様の全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SelfUrl設定が本番環境で正しく構成されているか
- [ ] Grant URL検証が正しく動作するか（/checkエンドポイントの実装確認）
- [ ] エラーメッセージがユーザーフレンドリーか
- [ ] トークンの保管・管理方法が適切か
