---
generated_at: 2026-01-14 21:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-受信メッセージ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor`（1-55行目）
- E-02: `src/WebhookClient/Services/HooksRepository.cs`（1-49行目）
- E-03: `src/WebhookClient/Services/WebHookReceived.cs`（1-11行目）
- E-04: `src/WebhookClient/Endpoints/WebhookEndpoints.cs`（31-53行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（51行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`（52行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HooksRepositoryから受信済みWebhookメッセージ一覧を取得 | E-01（30行目）, E-02（30-33行目） | ○ |
| C-02 | QuickGridコンポーネントでソート可能なテーブル形式で表示 | E-01（10-14行目） | ○ |
| C-03 | HooksRepositoryの変更通知をサブスクライブ | E-01（30行目）, E-02（35-39行目） | ○ |
| C-04 | 新規メッセージ受信時に画面をリアルタイム更新 | E-01（37-48行目）, E-02（13-25行目） | ○ |
| C-05 | コンポーネント破棄時にサブスクリプションをDispose | E-01（50-53行目） | ○ |
| C-06 | WebHookReceivedにWhen, Data, Tokenプロパティがある | E-03（5-9行目） | ○ |
| C-07 | ConcurrentQueueでスレッドセーフにメッセージを保持 | E-02（7行目） | ○ |
| C-08 | 画面機能マッピングでホーム画面と関連 | E-05（51行目） | ○ |
| C-09 | /webhook-receivedエンドポイントでWebhookを受信 | E-04（31-53行目） | ○ |
| C-10 | トークン検証により不正なWebhook送信を防止 | E-04（37行目） | ○ |
| C-11 | IDisposable実装でサブスクリプション解除 | E-01（2行目） | ○ |
| C-12 | StateHasChanged()で画面を再描画 | E-01（42行目） | ○ |
| C-13 | 例外発生時はDispatchExceptionAsyncで処理 | E-01（46行目） | ○ |
| C-14 | インメモリストレージを使用（データベース操作なし） | E-02（7行目） | ○ |
| C-15 | Subscribeメソッドでコールバック関数を登録 | E-02（35-39行目） | ○ |
| C-16 | AddNewメソッドでメッセージ追加と購読者への通知 | E-02（10-28行目） | ○ |
| C-17 | OnChangeSubscriptionでDispose時に購読解除 | E-02（42-47行目） | ○ |
| C-18 | パフォーマンス要件（画面初期表示1秒以内、リアルタイム更新0.5秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] インメモリストレージの永続化要件を確認（アプリ再起動時のデータ消失）
- [ ] トークン検証の設定がProduction環境で適切に構成されているか確認
