---
generated_at: 2026-01-14 21:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-登録済みWebhook表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor`（1-28行目）
- E-02: `src/WebhookClient/Services/WebhooksClient.cs`（1-15行目）
- E-03: `src/WebhookClient/Services/WebhookResponse.cs`（1-9行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（52行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（53行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebhooksClient.LoadWebhooks()でWebhook一覧を取得 | E-01（25行目）, E-02（10-13行目） | ○ |
| C-02 | QuickGridコンポーネントでソート可能なテーブル形式で表示 | E-01（9-13行目） | ○ |
| C-03 | Date, DestUrl, Token列を表示 | E-01（10-12行目）, E-03（5-7行目） | ○ |
| C-04 | Date列で降順デフォルトソート | E-01（10行目）InitialSortDirection="@SortDirection.Descending" | ○ |
| C-05 | GET /api/webhooksエンドポイントを呼び出し | E-02（12行目） | ○ |
| C-06 | WebhookResponseにDate, DestUrl, Tokenプロパティがある | E-03（5-7行目） | ○ |
| C-07 | HttpClientを使用したAPI呼び出し | E-02（3行目） | ○ |
| C-08 | 画面機能マッピングでホーム画面と関連 | E-04（52行目） | ○ |
| C-09 | OnInitializedAsyncでLoadWebhooksを呼び出し | E-01（23-26行目） | ○ |
| C-10 | データがない場合「None registered」を表示 | E-01（17行目） | ○ |
| C-11 | IQueryableに変換してQuickGridにバインド | E-01（25行目）.AsQueryable() | ○ |
| C-12 | IsDefaultSortColumn="true"でデフォルトソート列を指定 | E-01（10行目） | ○ |
| C-13 | 各列でSortable="@true"によりソート可能 | E-01（10-12行目） | ○ |
| C-14 | パフォーマンス要件（画面表示2秒以内、API応答1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] トークン情報の画面表示が機密性の観点で問題ないか確認
- [ ] ユーザースコープのフィルタリングがWebhooks.API側で適切に実装されているか確認
