---
generated_at: 2026-01-14 21:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：53-統合イベント発行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EventBus/Abstractions/IEventBus.cs`（1-7行目）
- E-02: `src/EventBus/Events/IntegrationEvent.cs`（1-17行目）
- E-03: `src/EventBusRabbitMQ/RabbitMQEventBus.cs`（1-322行目）
- E-04: `src/EventBusRabbitMQ/EventBusOptions.cs`（1-8行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（54行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IEventBus.PublishAsyncでイベントを発行 | E-01（5行目） | ○ |
| C-02 | IntegrationEventにId, CreationDateプロパティがある | E-02（12-15行目） | ○ |
| C-03 | Exchange名は"eshop_event_bus" | E-03（20行目） | ○ |
| C-04 | イベント型名をルーティングキーとして使用 | E-03（33行目） | ○ |
| C-05 | DeliveryMode.Persistentで永続化 | E-03（77行目） | ○ |
| C-06 | RetryCountでリトライ回数を設定（デフォルト10） | E-04（6行目） | ○ |
| C-07 | 指数バックオフでリトライ | E-03（316-318行目） | ○ |
| C-08 | BrokerUnreachableExceptionでリトライ | E-03（307行目） | ○ |
| C-09 | SocketExceptionでリトライ | E-03（307行目） | ○ |
| C-10 | JsonSerializer.SerializeToUtf8Bytesでシリアライズ | E-03（223行目） | ○ |
| C-11 | OpenTelemetryコンテキストをヘッダーに注入 | E-03（86行目） | ○ |
| C-12 | BasicPublishAsyncでメッセージ発行 | E-03（97-102行目） | ○ |
| C-13 | Exchangeをdirect型で宣言 | E-03（49行目） | ○ |
| C-14 | RabbitMQ接続からチャネルを作成 | E-03（40行目） | ○ |
| C-15 | SubscriptionClientNameでキュー名を設定 | E-04（5行目） | ○ |
| C-16 | mandatory: trueで発行 | E-03（100行目） | ○ |
| C-17 | ActivitySourceでトレーシング | E-03（59行目） | ○ |
| C-18 | messaging.systemタグに"rabbitmq"を設定 | E-03（119行目） | ○ |
| C-19 | ResiliencePipelineBuilderでリトライポリシー構築 | E-03（312-314行目） | ○ |
| C-20 | パフォーマンス要件（100ms以内、1000メッセージ/秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] RabbitMQ接続設定（ホスト、認証情報等）が適切に管理されているか確認
- [ ] リトライ回数・間隔がProduction環境で適切か確認
- [ ] TLS接続の要否を確認
