---
generated_at: 2026-01-14 21:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：54-統合イベント購読

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EventBus/Abstractions/IIntegrationEventHandler.cs`（1-15行目）
- E-02: `src/EventBus/Extensions/EventBusBuilderExtensions.cs`（1-41行目）
- E-03: `src/EventBus/Abstractions/EventBusSubscriptionInfo.cs`（1-24行目）
- E-04: `src/EventBusRabbitMQ/RabbitMQEventBus.cs`（132-295行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（55行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IIntegrationEventHandler<T>がHandle(T @event)を定義 | E-01（6行目） | ○ |
| C-02 | 非ジェネリック版Handleへの委譲実装 | E-01（8行目） | ○ |
| C-03 | AddSubscription<T, TH>でサブスクリプション登録 | E-02（20-38行目） | ○ |
| C-04 | KeyedTransientでハンドラをDI登録 | E-02（27行目） | ○ |
| C-05 | EventTypes辞書にイベント型名と型の対応を追加 | E-02（35行目） | ○ |
| C-06 | EventBusSubscriptionInfoでイベント型マッピング管理 | E-03（8行目） | ○ |
| C-07 | OnMessageReceivedでメッセージ受信処理 | E-04（132-181行目） | ○ |
| C-08 | OpenTelemetryコンテキストを抽出 | E-04（145行目） | ○ |
| C-09 | ルーティングキーからイベント型を特定 | E-04（156行目）, E-04（192行目） | ○ |
| C-10 | ProcessEventでハンドラを実行 | E-04（183-208行目） | ○ |
| C-11 | GetKeyedServicesで全ハンドラを取得 | E-04（204行目） | ○ |
| C-12 | 順次ハンドラを実行 | E-04（204-207行目）foreach | ○ |
| C-13 | BasicAckAsyncでメッセージ確認 | E-04（180行目） | ○ |
| C-14 | 例外発生時もAck | E-04（178-180行目）コメント参照 | ○ |
| C-15 | StartAsyncでコンシューマー開始 | E-04（226-295行目） | ○ |
| C-16 | キュー宣言（durable: true） | E-04（260行目） | ○ |
| C-17 | QueueBindAsyncでキューをExchangeにバインド | E-04（281-284行目） | ○ |
| C-18 | AsyncEventingBasicConsumerでメッセージ受信 | E-04（270行目） | ○ |
| C-19 | イベント型名が未登録時は警告ログ | E-04（194行目） | ○ |
| C-20 | DeserializeMessageでJSONデシリアライズ | E-04（199行目）, E-04（213-216行目） | ○ |
| C-21 | Dead Letter Exchange未実装（コメントあり） | E-04（178-179行目） | ○ |
| C-22 | パフォーマンス要件（500ms以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Dead Letter Exchange未実装のため、障害時のメッセージロスト可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] Dead Letter Exchange実装の要否を確認
- [ ] 複数ハンドラの並列実行の要否を確認（現在は順次実行）
- [ ] ハンドラ実行失敗時のリトライポリシーを確認
