---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：55-RabbitMQ連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EventBusRabbitMQ/RabbitMqDependencyInjectionExtensions.cs`（1-47行目）
- E-02: `src/EventBusRabbitMQ/RabbitMQEventBus.cs`（1-322行目）
- E-03: `src/EventBusRabbitMQ/EventBusOptions.cs`（1-8行目）
- E-04: `src/EventBusRabbitMQ/RabbitMQTelemetry.cs`（1-13行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（56行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddRabbitMqEventBusでDI登録 | E-01（17-40行目） | ○ |
| C-02 | AddRabbitMQClientでAspire接続を追加 | E-01（21行目） | ○ |
| C-03 | OpenTelemetryトレーシングを設定 | E-01（24-28行目） | ○ |
| C-04 | EventBusOptionsを設定セクションからバインド | E-01（31行目） | ○ |
| C-05 | RabbitMQTelemetryをシングルトン登録 | E-01（34行目） | ○ |
| C-06 | RabbitMQEventBusをIEventBusとして登録 | E-01（35行目） | ○ |
| C-07 | IHostedServiceとして同インスタンスを登録 | E-01（37行目） | ○ |
| C-08 | 設定セクション名は"EventBus" | E-01（15行目） | ○ |
| C-09 | Exchange名は"eshop_event_bus" | E-02（20行目） | ○ |
| C-10 | direct型Exchangeを使用 | E-02（49行目）, E-02（255行目） | ○ |
| C-11 | Queue宣言（durable: true） | E-02（260行目） | ○ |
| C-12 | LongRunningタスクで接続処理 | E-02（292行目） | ○ |
| C-13 | ActivitySourceName = "EventBusRabbitMQ" | E-04（8行目） | ○ |
| C-14 | DefaultTextMapPropagatorを使用 | E-04（11行目） | ○ |
| C-15 | SubscriptionClientNameでキュー名を設定 | E-03（5行目）, E-02（25行目） | ○ |
| C-16 | RetryCountでリトライ回数を設定（デフォルト10） | E-03（6行目） | ○ |
| C-17 | ResiliencePipelineでリトライポリシー構築 | E-02（22行目）, E-02（302-320行目） | ○ |
| C-18 | AsyncEventingBasicConsumerでメッセージ受信 | E-02（270行目） | ○ |
| C-19 | イベント型ごとにQueueBind | E-02（279-285行目） | ○ |
| C-20 | コンシューマーチャネルを作成 | E-02（246行目） | ○ |
| C-21 | IConnectionをDIから取得 | E-02（235行目） | ○ |
| C-22 | パフォーマンス要件（接続5秒以内、発行100ms以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] RabbitMQ接続文字列の管理方法（シークレット管理）を確認
- [ ] TLS設定の要否を確認
- [ ] クラスタ構成時の設定を確認
