---
generated_at: 2026-01-14 21:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-イベントログ保存

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/IntegrationEventLogEF/Services/IntegrationEventLogService.cs`（1-92行目）
- E-02: `src/IntegrationEventLogEF/Services/IIntegrationEventLogService.cs`（1-11行目）
- E-03: `src/IntegrationEventLogEF/IntegrationEventLogEntry.cs`（1-41行目）
- E-04: `src/IntegrationEventLogEF/EventStateEnum.cs`（1-11行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（57行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SaveEventAsync(IntegrationEvent, IDbContextTransaction)メソッド定義 | E-02（6行目） | ○ |
| C-02 | transactionがnullの場合ArgumentNullException | E-01（36行目） | ○ |
| C-03 | IntegrationEventLogEntry生成 | E-01（38行目） | ○ |
| C-04 | UseTransactionで同一トランザクションを使用 | E-01（40行目） | ○ |
| C-05 | DbSet.Addでエンティティ追加 | E-01（41行目） | ○ |
| C-06 | SaveChangesAsyncで保存 | E-01（43行目） | ○ |
| C-07 | EventIdにイベントのIdを設定 | E-03（13行目） | ○ |
| C-08 | EventTypeNameにイベント型のFullNameを設定 | E-03（15行目） | ○ |
| C-09 | ContentにJSONシリアライズ結果を保存 | E-03（16行目） | ○ |
| C-10 | State = NotPublished | E-03（17行目） | ○ |
| C-11 | TimesSent = 0 | E-03（18行目） | ○ |
| C-12 | TransactionIdを設定 | E-03（19行目） | ○ |
| C-13 | NotPublished = 0 | E-04（5行目） | ○ |
| C-14 | InProgress = 1 | E-04（6行目） | ○ |
| C-15 | Published = 2 | E-04（7行目） | ○ |
| C-16 | PublishedFailed = 3 | E-04（8行目） | ○ |
| C-17 | JSONシリアライズオプション（インデント付き） | E-03（7行目）WriteIndented = true | ○ |
| C-18 | パフォーマンス要件（50ms以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] IntegrationEventLogテーブルのインデックス設計を確認
- [ ] イベント内容に機密情報が含まれる場合の暗号化要否を確認
- [ ] トランザクションタイムアウト設定を確認
