---
generated_at: 2026-01-14 21:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：58-埋め込みベクトル生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Services/CatalogAI.cs`（1-77行目）
- E-02: `src/Catalog.API/Services/ICatalogAI.cs`（1-19行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EmbeddingDimensions = 384 | E-01（9行目） | ○ |
| C-02 | IEmbeddingGenerator<string, Embedding<float>>をDI注入 | E-01（10行目） | ○ |
| C-03 | IsEnabled => _embeddingGenerator is not null | E-01（25行目） | ○ |
| C-04 | GetEmbeddingAsync(CatalogItem)でCatalogItemToStringを呼び出し | E-01（30行目） | ○ |
| C-05 | AI無効時はnullを返却 | E-01（29-31行目）, E-01（57-58行目） | ○ |
| C-06 | GenerateVectorAsyncでベクトル生成 | E-01（61行目） | ○ |
| C-07 | [0..EmbeddingDimensions]で384次元に切り詰め | E-01（62行目） | ○ |
| C-08 | new Vector(embedding)で返却 | E-01（69行目） | ○ |
| C-09 | CatalogItemToString = "{Name} {Description}" | E-01（75行目） | ○ |
| C-10 | Stopwatch.GetTimestampで計測開始 | E-01（59行目） | ○ |
| C-11 | LogLevel.Traceで生成時間を出力 | E-01（64-67行目） | ○ |
| C-12 | ICatalogAI.IsEnabledプロパティ定義 | E-02（8行目） | ○ |
| C-13 | ICatalogAI.GetEmbeddingAsync(string)定義 | E-02（11行目） | ○ |
| C-14 | ICatalogAI.GetEmbeddingAsync(CatalogItem)定義 | E-02（14行目） | ○ |
| C-15 | Pgvector.Vector型を使用 | E-01（3行目）using Pgvector, E-01（69行目） | ○ |
| C-16 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] Embedding API（Azure OpenAI/Ollama）の設定が適切か確認
- [ ] 次元数（384）がEmbeddingモデルの出力次元と整合しているか確認
- [ ] API呼び出し時のタイムアウト設定を確認
