---
generated_at: 2026-01-14 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-AI商品検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Catalog.API/Apis/CatalogApi.cs`
- E-02: `src/Catalog.API/Model/CatalogItem.cs`
- E-03: `src/Catalog.API/Services/ICatalogAI.cs`
- E-04: `src/Catalog.API/Services/CatalogAI.cs`
- E-05: `src/Catalog.API/Infrastructure/CatalogContext.cs`
- E-06: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogItemEntityTypeConfiguration.cs`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | V1 APIエンドポイント `/items/withsemanticrelevance/{text}` | E-01 (53行目) | ○ |
| C-02 | V2 APIエンドポイント `/items/withsemanticrelevance` | E-01 (60行目) | ○ |
| C-03 | V1はminlength(1)制約 | E-01 (53行目) | ○ |
| C-04 | V2は[Required, MinLength(1)]属性 | E-01 (240行目) | ○ |
| C-05 | AI無効時に商品名検索フォールバック | E-01 (245-248行目) | ○ |
| C-06 | ベクトル生成失敗時にフォールバック | E-01 (253-256行目) | ○ |
| C-07 | CatalogAI.GetEmbeddingAsyncで埋め込み生成 | E-01 (251行目) | ○ |
| C-08 | IsEnabledで有効性チェック | E-01 (245行目), E-04 (25行目) | ○ |
| C-09 | EmbeddingDimensions = 384 | E-04 (9行目) | ○ |
| C-10 | GenerateVectorAsyncでベクトル生成 | E-04 (61行目) | ○ |
| C-11 | 384次元に切り詰め | E-04 (62行目) | ○ |
| C-12 | CosineDistanceでソート | E-01 (268行目, 282行目) | ○ |
| C-13 | Embedding != nullでフィルタ | E-01 (267行目, 281行目) | ○ |
| C-14 | Debug時に距離ログ出力 | E-01 (264-277行目) | ○ |
| C-15 | EmbeddingプロパティはVector型 | E-02 (40行目) | ○ |
| C-16 | EmbeddingはJsonIgnore | E-02 (39行目) | ○ |
| C-17 | pgvector拡張を有効化 | E-05 (20行目) | ○ |
| C-18 | カラム型はvector(384) | E-06 (13-14行目) | ○ |
| C-19 | V1はパスパラメータでtext指定 | E-01 (53行目: {text}) | ○ |
| C-20 | V2はクエリパラメータでtext指定 | E-01 (60行目, 240行目) | ○ |
| C-21 | Results型はOkまたはRedirect | E-01 (237行目) | ○ |
| C-22 | フォールバック時はGetItemsByName呼び出し | E-01 (247行目, 255行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: AI機能フォールバック - 低リスク、ソースコードで確認済み
- 1: AI Embedding Service設定 - 中リスク、環境構成によりサービス接続確認が必要
- 0: pgvector拡張 - 低リスク、CatalogContextで設定確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AI機能無効時のフォールバック動作確認
- [ ] 埋め込み生成失敗時のフォールバック動作確認
- [ ] セマンティック検索結果の妥当性確認（類似度順）
- [ ] Embeddingがnullの商品が除外されることの確認
- [ ] 大量データでのpgvectorクエリパフォーマンス確認
