---
generated_at: 2026-01-14 21:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：60-HybridAppカタログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/HybridApp/Components/Pages/Catalog/Catalog.razor`（1-62行目）
- E-02: `src/HybridApp/Components/Pages/Catalog/CatalogSearch.razor`（1-76行目）
- E-03: `src/HybridApp/Services/CatalogService.cs`（1-70行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（62-63行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（61行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @page "/"でルートページ | E-01（1行目） | ○ |
| C-02 | PageSize = 9 | E-01（37行目） | ○ |
| C-03 | クエリパラメータPage, BrandId, ItemTypeIdの定義 | E-01（39-46行目） | ○ |
| C-04 | GetVisiblePageIndexesでページ番号を計算 | E-01（50-51行目） | ○ |
| C-05 | OnParametersSetAsyncでデータ取得 | E-01（53-59行目） | ○ |
| C-06 | CatalogService.GetCatalogItemsを呼び出し | E-01（55-59行目）, E-03（19-24行目） | ○ |
| C-07 | remoteServiceBaseUrl = "api/catalog/" | E-03（10行目） | ○ |
| C-08 | api-version=2.0を使用 | E-03（15行目）, E-03（22行目） | ○ |
| C-09 | httpClient.GetFromJsonAsyncでAPI呼び出し | E-03（22行目） | ○ |
| C-10 | GetBrandsメソッドでブランド一覧取得 | E-02（57行目）, E-03（40-45行目） | ○ |
| C-11 | GetTypesメソッドでタイプ一覧取得 | E-02（58行目）, E-03（47-52行目） | ○ |
| C-12 | 並列でブランド・タイプを取得 | E-02（59行目）Task.WhenAll | ○ |
| C-13 | BrandUriでブランドフィルタ用URLを生成 | E-02（64-68行目） | ○ |
| C-14 | TypeUriでタイプフィルタ用URLを生成 | E-02（70-74行目） | ○ |
| C-15 | フィルタ変更時はページをnullにリセット | E-02（66行目）, E-02（72行目） | ○ |
| C-16 | ページインデックスは0ベース | E-01（56行目）Page.GetValueOrDefault(1) - 1 | ○ |
| C-17 | 画面機能マッピングで関連画面と対応 | E-04（62-63行目） | ○ |
| C-18 | パフォーマンス要件（画面表示2秒以内、API応答1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、明示的な要件定義が存在しない
  - 候補：要件定義書 / 性能テスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が妥当か確認
- [ ] モバイル環境でのネットワーク遅延を考慮した設計か確認
- [ ] オフライン対応の要否を確認
- [ ] カート機能（コメントアウト部分）の実装予定を確認
