---
generated_at: 2026-01-14 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：61-HybridApp商品詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/HybridApp/Components/Pages/Item/ItemPage.razor` - 商品詳細表示コンポーネント
- E-02: `src/HybridApp/Services/CatalogService.cs` - カタログサービス実装
- E-03: `src/HybridApp/Services/ProductImageUrlProvider.cs` - 画像URL生成サービス
- E-04: `src/HybridApp/MauiProgram.cs` - MAUIアプリケーション設定
- E-05: `src/HybridApp/Services/CatalogJsonContext.cs` - JSONシリアライゼーションコンテキスト
- E-06: `src/WebAppComponents/Catalog/CatalogItem.cs` - 商品データモデル
- E-07: `src/WebAppComponents/Services/ICatalogService.cs` - カタログサービスインターフェース
- E-08: `src/WebAppComponents/Services/IProductImageUrlProvider.cs` - 画像URLプロバイダーインターフェース
- E-09: `src/Catalog.API/Apis/CatalogApi.cs` - APIエンドポイント定義
- E-10: `src/HybridApp/MainPage.xaml` - BlazorWebView定義
- E-11: `src/HybridApp/Components/Routes.razor` - ルーター設定
- E-12: `src/HybridApp/HybridApp.csproj` - プロジェクト設定
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-15: `src/WebAppComponents/Catalog/CatalogListItem.razor` - カタログリストアイテムコンポーネント
- E-16: `src/WebAppComponents/Item/ItemHelper.cs` - アイテムURLヘルパー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルートパス `/item/{itemId:int}` でアクセス可能 | E-01（1行目: `@page "/item/{itemId:int}"`) | ○ |
| C-02 | CatalogServiceを依存性注入で使用 | E-01（3行目: `@inject eShop.HybridApp.Services.CatalogService CatalogService`) | ○ |
| C-03 | IProductImageUrlProviderを依存性注入で使用 | E-01（6行目: `@inject IProductImageUrlProvider ProductImages`) | ○ |
| C-04 | NavigationManagerを依存性注入で使用 | E-01（5行目: `@inject NavigationManager Nav`) | ○ |
| C-05 | 商品情報はCatalogItem?型のitem変数に格納 | E-01（41行目: `private CatalogItem? item;`) | ○ |
| C-06 | 商品未発見フラグnotFoundを使用 | E-01（44行目: `private bool notFound;`) | ○ |
| C-07 | ItemIdはパラメータとしてルートから受け取る | E-01（46-47行目: `[Parameter] public int ItemId { get; set; }`) | ○ |
| C-08 | OnInitializedAsyncでデータ取得を行う | E-01（52-65行目: OnInitializedAsyncメソッド定義） | ○ |
| C-09 | CatalogService.GetCatalogItem(ItemId)で商品取得 | E-01（57行目: `item = await CatalogService.GetCatalogItem(ItemId);`) | ○ |
| C-10 | 404エラー時はnotFoundをtrueに設定 | E-01（60-64行目: catchブロックで`notFound = true;`) | ○ |
| C-11 | PageTitleに商品名を表示 | E-01（10行目: `<PageTitle>@item.Name | AdventureWorks</PageTitle>`) | ○ |
| C-12 | ヘッダータイトルに商品名を表示 | E-01（11行目: `<SectionContent SectionName="page-header-title">@item.Name</SectionContent>`) | ○ |
| C-13 | ヘッダーサブタイトルにブランド名を表示 | E-01（12行目: `<SectionContent SectionName="page-header-subtitle">@item.CatalogBrand?.Brand</SectionContent>`) | ○ |
| C-14 | 商品画像をProductImageUrlProviderで取得 | E-01（15行目: `<img src="@ProductImages.GetProductImageUrl(item.Id)" />`) | ○ |
| C-15 | 価格は小数点2桁で表示 | E-01（22行目: `$@item.Price.ToString("0.00")`) | ○ |
| C-16 | CatalogServiceはICatalogServiceを実装 | E-02（8行目: `public class CatalogService(HttpClient httpClient) : ICatalogService`) | ○ |
| C-17 | APIベースURLは"api/catalog/" | E-02（10行目: `private readonly string remoteServiceBaseUrl = "api/catalog/";`) | ○ |
| C-18 | GetCatalogItemはitems/{id}?api-version=2.0にリクエスト | E-02（15行目: `var uri = $"{remoteServiceBaseUrl}items/{id}?api-version=2.0";`) | ○ |
| C-19 | GetFromJsonAsyncでJSONデシリアライズ | E-02（16行目: `return httpClient.GetFromJsonAsync(uri, CatalogJsonContext.Default.CatalogItem);`) | ○ |
| C-20 | ProductImageUrlProviderはMobileBffHostを使用 | E-03（8行目: `=> $"{MauiProgram.MobileBffHost}api/catalog/items/{productId}/pic?api-version=2.0";`) | ○ |
| C-21 | AndroidではMobileBffHostは10.0.2.2:11632 | E-04（9行目: `internal static string MobileBffHost = DeviceInfo.Platform == DevicePlatform.Android ? "http://10.0.2.2:11632/" : "http://localhost:11632/";`) | ○ |
| C-22 | その他プラットフォームではlocalhost:11632 | E-04（9行目: 同上） | ○ |
| C-23 | CatalogServiceはHttpClientで登録 | E-04（30行目: `builder.Services.AddHttpClient<CatalogService>(o => o.BaseAddress = new(MobileBffHost));`) | ○ |
| C-24 | ProductImageUrlProviderはSingletonで登録 | E-04（31行目: `builder.Services.AddSingleton<WebAppComponents.Services.IProductImageUrlProvider, ProductImageUrlProvider>();`) | ○ |
| C-25 | CatalogJsonContextはCatalogItem等をシリアライズ対象に定義 | E-05（6-11行目: JsonSerializable属性） | ○ |
| C-26 | CatalogItemはId,Name,Description,Price,CatalogBrand等を持つrecord | E-06（3-12行目: record定義） | ○ |
| C-27 | ICatalogServiceはGetCatalogItemメソッドを定義 | E-07（9行目: `Task<CatalogItem?> GetCatalogItem(int id);`) | ○ |
| C-28 | IProductImageUrlProviderはGetProductImageUrlメソッドを定義 | E-08（10行目: `string GetProductImageUrl(int productId);`) | ○ |
| C-29 | API側のGetItemByIdは/items/{id:int}にマッピング | E-09（36行目: `api.MapGet("/items/{id:int}", GetItemById)`) | ○ |
| C-30 | API側はCatalogBrandをIncludeでEager Loading | E-09（183行目: `var item = await services.Context.CatalogItems.Include(ci => ci.CatalogBrand).SingleOrDefaultAsync(ci => ci.Id == id);`) | ○ |
| C-31 | API側はitem==nullでNotFoundを返す | E-09（185-188行目: NotFound返却処理） | ○ |
| C-32 | BlazorWebViewはwwwroot/index.htmlをホスト | E-10（8行目: `<BlazorWebView x:Name="blazorWebView" HostPage="wwwroot/index.html">`) | ○ |
| C-33 | RoutesコンポーネントがルートコンポーネントとしてRouter使用 | E-11（1行目: `<Router AppAssembly="@typeof(MauiProgram).Assembly">`) | ○ |
| C-34 | HybridAppはnet10.0-android,ios,maccatalyst,windowsをターゲット | E-12（4-5行目: TargetFrameworks） | ○ |
| C-35 | 機能一覧でNo.61はHybridApp商品詳細として定義 | E-13, E-14（機能一覧・画面機能マッピングで確認） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張にソースコードまたは設計ドキュメントによる根拠が存在

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての主張がソースコードで検証可能
- 注意点:
  - カート追加機能がコメントアウトされている（将来的な機能拡張予定）
  - 認証機能が未実装（将来的にOIDC統合予定）
  - 本番環境でのHTTPS使用については設定ファイルで確認が必要

## 6) レビュアーチェックリスト（最小）
- [x] ルーティング定義が正しいか（/item/{itemId:int}）
- [x] CatalogService.GetCatalogItemの呼び出しが正しいか
- [x] エラーハンドリング（404）が適切か
- [x] ProductImageUrlProviderのURL生成が正しいか
- [x] MobileBffHostのプラットフォーム別設定が正しいか
- [x] DIコンテナへのサービス登録が正しいか
- [x] JSONシリアライゼーションコンテキストの設定が正しいか
- [ ] 本番環境でのHTTPS設定を確認（本ドキュメント範囲外）
- [ ] 将来的なカート追加機能の統合方針を確認（コメントアウト部分）
