---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての画面はソースコードから直接確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-02: `src/WebApp/Components/Pages/Item/ItemPage.razor`
- E-03: `src/WebApp/Components/Pages/Cart/CartPage.razor`
- E-04: `src/WebApp/Components/Pages/Checkout/Checkout.razor`
- E-05: `src/WebApp/Components/Pages/User/Orders.razor`
- E-06: `src/WebApp/Components/Pages/User/LogIn.razor`
- E-07: `src/WebApp/Components/Pages/User/LogOut.razor`
- E-08: `src/WebApp/Components/Chatbot/Chatbot.razor`
- E-09: `src/Identity.API/Views/Account/Login.cshtml`
- E-10: `src/Identity.API/Views/Account/Logout.cshtml`
- E-11: `src/Identity.API/Views/Account/LoggedOut.cshtml`
- E-12: `src/Identity.API/Views/Account/AccessDenied.cshtml`
- E-13: `src/Identity.API/Views/Home/Index.cshtml`
- E-14: `src/Identity.API/Views/Consent/Index.cshtml`
- E-15: `src/Identity.API/Views/Grants/Index.cshtml`
- E-16: `src/Identity.API/Views/Diagnostics/Index.cshtml`
- E-17: `src/Identity.API/Views/Device/UserCodeCapture.cshtml`
- E-18: `src/Identity.API/Views/Device/UserCodeConfirmation.cshtml`
- E-19: `src/Identity.API/Views/Device/Success.cshtml`
- E-20: `src/Identity.API/Views/Shared/Error.cshtml`
- E-21: `src/WebhookClient/Components/Pages/Home/Home.razor`
- E-22: `src/WebhookClient/Components/Pages/AddWebhook.razor`
- E-23: `src/WebhookClient/Components/Pages/LogIn.razor`
- E-24: `src/WebhookClient/Components/Pages/Error.razor`
- E-25: `src/HybridApp/Components/Pages/Catalog/Catalog.razor`
- E-26: `src/HybridApp/Components/Pages/Item/ItemPage.razor`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebApp カタログ画面（/）が存在する | E-01 | ○ |
| C-02 | WebApp 商品詳細画面（/item/{id}）が存在する | E-02 | ○ |
| C-03 | WebApp カート画面（/cart）が存在し認証必須 | E-03 | ○ |
| C-04 | WebApp チェックアウト画面（/checkout）が存在し認証必須 | E-04 | ○ |
| C-05 | WebApp 注文履歴画面（/user/orders）が存在し認証必須 | E-05 | ○ |
| C-06 | WebApp ログイン画面（/user/login）が存在する | E-06 | ○ |
| C-07 | WebApp ログアウト画面（/user/logout）が存在する | E-07 | ○ |
| C-08 | WebApp チャットボット機能が存在する | E-08 | ○ |
| C-09 | Identity.API ログイン画面が存在する | E-09 | ○ |
| C-10 | Identity.API ログアウト画面が存在する | E-10 | ○ |
| C-11 | Identity.API ログアウト完了画面が存在する | E-11 | ○ |
| C-12 | Identity.API アクセス拒否画面が存在する | E-12 | ○ |
| C-13 | Identity.API ホーム画面が存在する | E-13 | ○ |
| C-14 | Identity.API 同意画面が存在する | E-14 | ○ |
| C-15 | Identity.API 権限管理画面が存在する | E-15 | ○ |
| C-16 | Identity.API 診断画面が存在する | E-16 | ○ |
| C-17 | Identity.API デバイスコード入力画面が存在する | E-17 | ○ |
| C-18 | Identity.API デバイス確認画面が存在する | E-18 | ○ |
| C-19 | Identity.API デバイス認証成功画面が存在する | E-19 | ○ |
| C-20 | Identity.API エラー画面が存在する | E-20 | ○ |
| C-21 | WebhookClient ホーム画面（/）が存在する | E-21 | ○ |
| C-22 | WebhookClient Webhook追加画面（/add-webhook）が存在する | E-22 | ○ |
| C-23 | WebhookClient ログイン画面（/login）が存在する | E-23 | ○ |
| C-24 | WebhookClient エラー画面（/Error）が存在する | E-24 | ○ |
| C-25 | HybridApp カタログ画面（/）が存在する | E-25 | ○ |
| C-26 | HybridApp 商品詳細画面（/item/{id}）が存在する | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - すべての画面はソースコードのRazorファイルおよびcshtmlファイルから直接確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての画面情報はソースコードから直接抽出されており、高い信頼性を持つ
- 画面遷移図はコード内のナビゲーション処理（Nav.NavigateTo、href属性、リダイレクト処理）から推測
- 一部の遷移は暗黙的なユーザー操作に基づく推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面のルートパス（@page ディレクティブ）が正しく記載されているか確認
- [ ] 認証必須（@attribute [Authorize]）の画面が正しく特定されているか確認
- [ ] 画面遷移図のフロー（特に認証リダイレクト）が実際の動作と一致するか確認
- [ ] HybridAppの機能制限（カート機能未実装）が正しく記載されているか確認
- [ ] WebhookClientの権限分離（認証済み/未認証でのUI切り替え）が正しいか確認
