# 画面遷移図

## eShop システム全体の画面遷移

```mermaid
flowchart TB
    subgraph WebApp["WebApp（メインECサイト）"]
        WA_Catalog["カタログ画面<br/>/"]
        WA_Item["商品詳細画面<br/>/item/{id}"]
        WA_Cart["カート画面<br/>/cart"]
        WA_Checkout["チェックアウト画面<br/>/checkout"]
        WA_Orders["注文履歴画面<br/>/user/orders"]
        WA_Login["ログイン画面<br/>/user/login"]
        WA_Logout["ログアウト画面<br/>/user/logout"]
        WA_Chatbot["チャットボット<br/>（フローティング）"]
    end

    subgraph Identity["Identity.API（認証サーバー）"]
        ID_Login["ログイン画面"]
        ID_Logout["ログアウト画面"]
        ID_LoggedOut["ログアウト完了画面"]
        ID_Consent["同意画面"]
        ID_Grants["権限管理画面"]
        ID_Diagnostics["診断画面"]
        ID_Home["ホーム画面"]
        ID_Error["エラー画面"]
        ID_AccessDenied["アクセス拒否画面"]
        subgraph DeviceFlow["デバイスフロー"]
            ID_DeviceCode["デバイスコード入力画面"]
            ID_DeviceConfirm["デバイス確認画面"]
            ID_DeviceSuccess["デバイス認証成功画面"]
        end
    end

    subgraph Webhook["WebhookClient（Webhook管理）"]
        WH_Home["ホーム画面<br/>/"]
        WH_AddWebhook["Webhook追加画面<br/>/add-webhook"]
        WH_Login["ログイン画面<br/>/login"]
        WH_Error["エラー画面<br/>/Error"]
    end

    subgraph HybridApp["HybridApp（MAUIアプリ）"]
        HA_Catalog["カタログ画面<br/>/"]
        HA_Item["商品詳細画面<br/>/item/{id}"]
    end

    %% WebApp内部の遷移
    WA_Catalog -->|商品選択| WA_Item
    WA_Item -->|カートに追加| WA_Cart
    WA_Item -->|未ログイン時| WA_Login
    WA_Cart -->|チェックアウト| WA_Checkout
    WA_Cart -->|買い物を続ける| WA_Catalog
    WA_Checkout -->|注文確定| WA_Orders
    WA_Checkout -->|戻る| WA_Cart
    WA_Catalog <-->|チャット呼び出し| WA_Chatbot

    %% WebAppとIdentityの連携
    WA_Login -->|認証リダイレクト| ID_Login
    ID_Login -->|認証成功| WA_Catalog
    ID_Login -->|同意必要| ID_Consent
    ID_Consent -->|同意後| WA_Catalog
    WA_Logout -->|ログアウト処理| ID_Logout
    ID_Logout -->|確認| ID_LoggedOut
    ID_LoggedOut -->|リダイレクト| WA_Catalog

    %% Identity内部の遷移
    ID_Home -->|診断| ID_Diagnostics
    ID_Home -->|権限管理| ID_Grants
    ID_DeviceCode -->|コード確認| ID_DeviceConfirm
    ID_DeviceConfirm -->|認証成功| ID_DeviceSuccess

    %% WebhookClient内部の遷移
    WH_Home -->|Webhook追加| WH_AddWebhook
    WH_AddWebhook -->|登録成功| WH_Home
    WH_Login -->|認証後| WH_Home

    %% WebhookClientとIdentityの連携
    WH_Login -->|認証リダイレクト| ID_Login
    ID_Login -->|認証成功| WH_Home

    %% HybridApp内部の遷移
    HA_Catalog -->|商品選択| HA_Item
    HA_Item -->|戻る| HA_Catalog
```

## WebApp 詳細遷移図

```mermaid
flowchart LR
    subgraph Public["未認証でアクセス可能"]
        Catalog["カタログ画面<br/>/"]
        Item["商品詳細画面<br/>/item/{id}"]
    end

    subgraph Auth["認証必須"]
        Cart["カート画面<br/>/cart"]
        Checkout["チェックアウト画面<br/>/checkout"]
        Orders["注文履歴画面<br/>/user/orders"]
    end

    subgraph UserActions["ユーザーアクション"]
        Login["ログイン<br/>/user/login"]
        Logout["ログアウト<br/>/user/logout"]
    end

    Catalog -->|商品クリック| Item
    Item -->|カートに追加<br/>（認証済み）| Cart
    Item -->|カートに追加<br/>（未認証）| Login
    Login -->|認証成功| Item
    Cart -->|チェックアウト| Checkout
    Cart -->|買い物を続ける| Catalog
    Checkout -->|注文確定| Orders
    Checkout -->|戻る| Cart
    Orders -->|買い物を続ける| Catalog

    Catalog -->|フィルタ変更| Catalog
    Catalog -->|ページ移動| Catalog
```

## Identity.API 認証フロー

```mermaid
flowchart TB
    subgraph StandardAuth["標準認証フロー"]
        Login["ログイン画面"]
        Consent["同意画面"]
        LoggedOut["ログアウト完了画面"]
    end

    subgraph Management["管理機能"]
        Home["ホーム画面"]
        Grants["権限管理画面"]
        Diagnostics["診断画面"]
    end

    subgraph DeviceAuth["デバイスフロー認証"]
        DeviceCode["コード入力画面"]
        DeviceConfirm["確認画面"]
        DeviceSuccess["成功画面"]
    end

    subgraph Errors["エラー処理"]
        Error["エラー画面"]
        AccessDenied["アクセス拒否画面"]
    end

    Login -->|同意必要| Consent
    Login -->|認証成功| ReturnToClient["クライアントに戻る"]
    Consent -->|許可| ReturnToClient
    Consent -->|拒否| Error

    Home -->|セッション確認| Diagnostics
    Home -->|権限確認| Grants
    Grants -->|権限取り消し| Grants

    DeviceCode -->|コード検証| DeviceConfirm
    DeviceConfirm -->|許可| DeviceSuccess
    DeviceConfirm -->|拒否| Error
```

## WebhookClient 遷移図

```mermaid
flowchart TB
    Login["ログイン画面<br/>/login"]
    Home["ホーム画面<br/>/"]
    AddWebhook["Webhook追加画面<br/>/add-webhook"]
    Error["エラー画面<br/>/Error"]

    Login -->|認証成功| Home
    Home -->|Webhook追加| AddWebhook
    AddWebhook -->|登録成功| Home
    AddWebhook -->|登録失敗| AddWebhook
    Home -->|エラー発生| Error
    AddWebhook -->|エラー発生| Error
```

## HybridApp 遷移図

```mermaid
flowchart LR
    Catalog["カタログ画面<br/>/"]
    Item["商品詳細画面<br/>/item/{id}"]

    Catalog -->|商品選択| Item
    Item -->|戻る| Catalog
    Catalog -->|フィルタ変更| Catalog
    Catalog -->|ページ移動| Catalog
```

## 画面カテゴリ別サマリー

| カテゴリ | 画面数 | 主な機能 |
|---------|--------|----------|
| WebApp | 8 | ECサイトのメイン機能（カタログ、カート、チェックアウト、注文履歴） |
| Identity.API | 12 | 認証・認可機能（ログイン、同意、権限管理、デバイスフロー） |
| WebhookClient | 4 | Webhook管理機能（登録、受信メッセージ確認） |
| HybridApp | 2 | MAUIハイブリッドアプリ（カタログ閲覧のみ） |
