---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 66
  claims_with_evidence: 63
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：63 / 66、根拠なし：3
- 優先レビュー（高）
  1. **チャットボット - AI商品検索連携**：ChatState内部実装未確認
  2. **Identity.API診断画面 - クレーム表示機能**：DiagnosticsController未確認
  3. **WebhookClient - Grant URL検証連携**：GrantUrlTesterService未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-02: `src/WebApp/Components/Pages/Item/ItemPage.razor`
- E-03: `src/WebApp/Components/Pages/Cart/CartPage.razor`
- E-04: `src/WebApp/Components/Pages/Checkout/Checkout.razor`
- E-05: `src/WebApp/Components/Pages/User/Orders.razor`
- E-06: `src/WebApp/Components/Pages/User/LogIn.razor`
- E-07: `src/WebApp/Components/Pages/User/LogOut.razor`
- E-08: `src/WebApp/Components/Chatbot/Chatbot.razor`
- E-09: `src/Identity.API/Views/Account/Login.cshtml`
- E-10: `src/Identity.API/Views/Account/Logout.cshtml`
- E-11: `src/Identity.API/Views/Account/LoggedOut.cshtml`
- E-12: `src/Identity.API/Views/Account/AccessDenied.cshtml`
- E-13: `src/Identity.API/Views/Home/Index.cshtml`
- E-14: `src/Identity.API/Views/Consent/Index.cshtml`
- E-15: `src/Identity.API/Views/Grants/Index.cshtml`
- E-16: `src/Identity.API/Views/Diagnostics/Index.cshtml`
- E-17: `src/Identity.API/Views/Device/UserCodeCapture.cshtml`
- E-18: `src/Identity.API/Views/Device/UserCodeConfirmation.cshtml`
- E-19: `src/Identity.API/Views/Device/Success.cshtml`
- E-20: `src/Identity.API/Views/Shared/Error.cshtml`
- E-21: `src/WebhookClient/Components/Pages/Home/Home.razor`
- E-22: `src/WebhookClient/Components/Pages/AddWebhook.razor`
- E-23: `src/WebhookClient/Components/Pages/LogIn.razor`
- E-24: `src/WebhookClient/Components/Pages/Error.razor`
- E-25: `src/HybridApp/Components/Pages/Catalog/Catalog.razor`
- E-26: `src/HybridApp/Components/Pages/Item/ItemPage.razor`
- E-27: `src/WebApp/Services/BasketState.cs`
- E-28: `src/WebApp/Services/OrderingService.cs`
- E-29: `src/WebhookClient/Services/WebhooksClient.cs`
- E-30: `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor`
- E-31: `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor`
- E-32: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-33: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カタログ画面 - 商品一覧取得（主機能） | E-01, E-32, E-33 | ○ |
| C-02 | カタログ画面 - 商品タイプ一覧取得（補助機能） | E-01, E-33 | ○ |
| C-03 | カタログ画面 - ブランド一覧取得（補助機能） | E-01, E-33 | ○ |
| C-04 | カタログ画面 - カタログ画面UI機能 | E-01, E-33 | ○ |
| C-05 | カタログ画面 - 商品詳細画面遷移 | E-01 | ○ |
| C-06 | 商品詳細画面 - 商品詳細取得（主機能） | E-02, E-33 | ○ |
| C-07 | 商品詳細画面 - 商品画像取得（補助機能） | E-02, E-33 | ○ |
| C-08 | 商品詳細画面 - かご取得（API連携） | E-02, E-27 | ○ |
| C-09 | 商品詳細画面 - かご更新（API連携） | E-02, E-27 | ○ |
| C-10 | 商品詳細画面 - ログイン画面遷移 | E-02 | ○ |
| C-11 | カート画面 - かご取得（主機能） | E-03, E-27 | ○ |
| C-12 | カート画面 - かご更新（API連携） | E-03, E-27 | ○ |
| C-13 | カート画面 - 商品画像取得 | E-03 | ○ |
| C-14 | カート画面 - チェックアウト画面遷移 | E-03 | ○ |
| C-15 | チェックアウト画面 - 注文作成（主機能） | E-04, E-27, E-28 | ○ |
| C-16 | チェックアウト画面 - かご取得（補助機能） | E-04, E-27 | ○ |
| C-17 | チェックアウト画面 - かご削除 | E-27 | ○ |
| C-18 | チェックアウト画面 - 注文履歴画面遷移 | E-04 | ○ |
| C-19 | 注文履歴画面 - ユーザー注文履歴取得 | E-05, E-28 | ○ |
| C-20 | ログイン画面(WebApp) - ログイン処理 | E-06 | ○ |
| C-21 | ログアウト画面 - ログアウト処理 | E-07 | ○ |
| C-22 | チャットボット - 商品一覧取得 | E-08 | ○ |
| C-23 | チャットボット - AI商品検索 | E-08 | △ |
| C-24 | チャットボット - かご更新 | E-08 | ○ |
| C-25 | ログイン画面(Identity.API) - ユーザーログイン | E-09 | ○ |
| C-26 | ログイン画面(Identity.API) - 認証情報検証 | E-09, E-33 | ○ |
| C-27 | ログイン画面(Identity.API) - サインイン処理 | E-09, E-33 | ○ |
| C-28 | ログアウト画面(Identity.API) - ログアウト処理 | E-10 | ○ |
| C-29 | ログアウト完了画面 - ログアウト完了表示 | E-11 | ○ |
| C-30 | アクセス拒否画面 - アクセス拒否表示 | E-12 | ○ |
| C-31 | ホーム画面(Identity.API) - IdentityServer4管理 | E-13 | ○ |
| C-32 | 同意画面 - OAuth同意処理 | E-14 | ○ |
| C-33 | 権限管理画面 - 権限取り消し | E-15 | ○ |
| C-34 | 診断画面 - クレーム表示 | E-16 | △ |
| C-35 | デバイスコード入力画面 - コード入力 | E-17 | ○ |
| C-36 | デバイス確認画面 - 権限確認 | E-18 | ○ |
| C-37 | デバイス認証成功画面 - 成功メッセージ | E-19 | ○ |
| C-38 | エラー画面(Identity.API) - エラー表示 | E-20 | ○ |
| C-39 | ホーム画面(WebhookClient) - Webhook一覧取得 | E-21, E-30 | ○ |
| C-40 | ホーム画面(WebhookClient) - 受信メッセージ表示 | E-21, E-31 | ○ |
| C-41 | ホーム画面(WebhookClient) - 登録済みWebhook表示 | E-30, E-29 | ○ |
| C-42 | Webhook追加画面 - Webhook登録 | E-22, E-29 | ○ |
| C-43 | Webhook追加画面 - Grant URL検証 | E-22 | △ |
| C-44 | Webhook追加画面 - ホーム画面遷移 | E-22 | ○ |
| C-45 | ログイン画面(WebhookClient) - ログインリダイレクト | E-23 | ○ |
| C-46 | エラー画面(WebhookClient) - エラー表示 | E-24 | ○ |
| C-47 | カタログ画面(HybridApp) - 商品一覧取得 | E-25 | ○ |
| C-48 | カタログ画面(HybridApp) - タイプフィルタリング | E-25 | ○ |
| C-49 | カタログ画面(HybridApp) - ブランドフィルタリング | E-25 | ○ |
| C-50 | カタログ画面(HybridApp) - 商品詳細画面遷移 | E-25 | ○ |
| C-51 | 商品詳細画面(HybridApp) - 商品詳細取得 | E-26 | ○ |
| C-52 | 商品詳細画面(HybridApp) - 商品画像取得 | E-26 | ○ |
| C-53 | カタログ画面 - CatalogServiceによるページネーション | E-01 | ○ |
| C-54 | 商品詳細画面 - BasketState.AddAsync呼び出し | E-02, E-27 | ○ |
| C-55 | カート画面 - BasketState.SetQuantityAsync呼び出し | E-03, E-27 | ○ |
| C-56 | チェックアウト画面 - BasketState.CheckoutAsync呼び出し | E-04, E-27 | ○ |
| C-57 | 注文履歴画面 - OrderingService.GetOrders呼び出し | E-05, E-28 | ○ |
| C-58 | チャットボット - IChatClientサービス注入 | E-08 | ○ |
| C-59 | WebhookClient - WebhooksClient.AddWebHookAsync | E-22, E-29 | ○ |
| C-60 | WebhookClient - WebhooksClient.LoadWebhooks | E-30, E-29 | ○ |
| C-61 | HybridApp - CatalogService注入 | E-25 | ○ |
| C-62 | HybridApp - IProductImageUrlProvider注入 | E-26 | ○ |
| C-63 | Identity.API - LoginViewModel使用 | E-09 | ○ |
| C-64 | Identity.API - ConsentViewModel使用 | E-14 | ○ |
| C-65 | Identity.API - GrantsViewModel使用 | E-15 | ○ |
| C-66 | Identity.API - DiagnosticsViewModel使用 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **チャットボット - AI商品検索（C-23）**: ChatState.csの内部実装詳細が未確認。AI商品検索機能の呼び出しはCatalogServiceを介して行われると推測されるが、セマンティック検索APIの直接呼び出し箇所は確認できていない。
  - 候補：`src/WebApp/Chatbot/ChatState.cs` / Catalog.API セマンティック検索エンドポイント
- **診断画面 - クレーム表示（C-34）**: DiagnosticsControllerの実装詳細が未確認。DiagnosticsViewModelの生成ロジックは確認できていない。
  - 候補：`src/Identity.API/Controllers/DiagnosticsController.cs`
- **Webhook追加画面 - Grant URL検証（C-43）**: Webhooks.APIのGrantUrlTesterServiceの実装詳細が未確認。クライアント側からの呼び出しはWebhooksClient経由だが、サーバー側検証ロジックは確認できていない。
  - 候補：`src/Webhooks.API/Services/GrantUrlTesterService.cs`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面一覧.csv、機能一覧.csvとの整合性は取れており、コードベースとの対応関係は明確
- **0: 低リスク** - WebApp、Identity.API、WebhookClient、HybridApp各画面の機能マッピングは実コードから確認済み
- **1: 中リスク** - チャットボットのAI機能連携は内部実装詳細が限定的にしか確認できていない
- **1: 中リスク** - Identity.APIの一部管理画面（診断画面）のコントローラー実装は未確認
- **0: 低リスク** - HybridAppはカート・チェックアウト機能が未実装であることを反映済み

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvの全画面（26画面）に対して機能マッピングが存在するか確認
- [ ] 各画面の「主機能」が適切に設定されているか確認
- [ ] 「関連種別」（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] 「関連する操作・処理」の説明がコードの実装と一致しているか確認
- [ ] チャットボットのAI機能連携（C-23）の詳細をChatState.csで確認
- [ ] Identity.API診断画面（C-34）のDiagnosticsControllerを確認
- [ ] WebhookClient Grant URL検証（C-43）のサーバー側実装を確認
