# 画面設計書 1-カタログ画面

## 概要

本ドキュメントは、eShop WebAppのカタログ画面（トップページ）の設計仕様を定義する。商品一覧の表示、ブランド・タイプによるフィルタリング、ページネーション機能を提供するECサイトのメイン画面である。

### 本画面の処理概要

カタログ画面は、eShopのホームページとして機能し、ユーザーが商品を閲覧・検索するための中心的な画面である。

**業務上の目的・背景**：ECサイトにおいて、顧客が商品を発見し購入検討を開始するための入口となる最重要画面である。多数の商品を効率的に閲覧できるよう、ページネーションとフィルタリング機能を提供し、ユーザーが目的の商品に素早くアクセスできるようにすることで、購買行動を促進する。

**画面へのアクセス方法**：アプリケーションのルートURL（/）に直接アクセス、または他の画面からホームへのナビゲーションリンクをクリックすることでアクセスする。認証は不要で、未ログイン状態でも全機能を利用可能である。

**主要な操作・処理内容**：
1. 商品一覧の閲覧：9件ずつの商品がカード形式で表示され、商品名、価格、画像を確認できる
2. ブランドフィルタリング：特定ブランドの商品のみを絞り込み表示する
3. タイプフィルタリング：特定商品タイプ（カテゴリ）の商品のみを絞り込み表示する
4. ページネーション：複数ページにわたる商品一覧を前後に移動して閲覧する
5. 商品詳細への遷移：商品カードをクリックして詳細画面へ移動する

**画面遷移**：
- 遷移元：ログアウト完了画面、カート画面（買い物を続けるボタン）、注文履歴画面、認証成功後のリダイレクト
- 遷移先：商品詳細画面（商品カードクリック時）

**権限による表示制御**：本画面は認証不要であり、すべてのユーザーが同一の表示内容・操作を利用可能である。ログイン状態による表示差異はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 商品一覧取得 | 主機能 | CatalogServiceを使用してページネーション付き商品一覧を取得・表示 |
| 9 | 商品タイプ一覧取得 | 補助機能 | CatalogSearchコンポーネントでタイプフィルタリング用一覧を取得 |
| 10 | ブランド一覧取得 | 補助機能 | CatalogSearchコンポーネントでブランドフィルタリング用一覧を取得 |
| 41 | カタログ画面 | 主機能 | 商品一覧表示・フィルタリングのUI機能 |
| 42 | 商品詳細画面 | 遷移先機能 | CatalogListItemクリックで商品詳細画面へ遷移 |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/` |
| ルートパラメータ | なし |
| クエリパラメータ | `page`: ページ番号（省略時は1）、`brand`: ブランドID、`type`: 商品タイプID |

## 入出力項目

### 入力項目（クエリパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ページ番号 | page | int? | 任意 | 表示するページ番号（1始まり、省略時は1） |
| ブランドID | brand | int? | 任意 | フィルタリング対象のブランドID |
| 商品タイプID | type | int? | 任意 | フィルタリング対象の商品タイプID |

### 出力項目（API取得データ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 商品一覧 | List\<CatalogItem\> | 現在ページの商品データ（最大9件） |
| 総件数 | int | フィルタ条件に合致する商品の総数 |
| ブランド一覧 | IEnumerable\<CatalogBrand\> | フィルタ選択用のブランドマスタ |
| 商品タイプ一覧 | IEnumerable\<CatalogItemType\> | フィルタ選択用の商品タイプマスタ |

## 表示項目

### 商品カード（CatalogListItem）

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| 商品画像 | CatalogItem.PictureUrl | img要素 | IProductImageUrlProviderで取得 |
| 商品名 | CatalogItem.Name | テキスト | |
| 価格 | CatalogItem.Price | 通貨形式（$0.00） | 小数点以下2桁固定 |

### フィルタセクション（CatalogSearch）

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| ブランドフィルタ | CatalogBrand[] | タグ形式のリンク | 「All」を含む |
| タイプフィルタ | CatalogItemType[] | タグ形式のリンク | 「All」を含む |

### ページネーション

| 項目名 | 計算方法 | 表示形式 | 備考 |
|--------|---------|---------|------|
| ページリンク | Math.Ceiling(Count / PageSize) | NavLinkコンポーネント | 現在ページはactive-pageクラス |

## イベント仕様

### 1-商品カードクリック

商品カードをクリックすると、該当商品の詳細画面へ遷移する。

**トリガー**: CatalogListItem内のaタグクリック
**遷移先**: `/item/{商品ID}`
**データの流れ**:
1. CatalogListItem.razor内でItemHelper.Url(Item)が呼び出される
2. `item/{Item.Id}`形式のURLが生成される
3. 商品詳細画面（ItemPage.razor）へ遷移

### 2-ブランドフィルタ選択

特定ブランドのリンクをクリックすると、そのブランドの商品のみを表示する。

**トリガー**: CatalogSearch内のブランドタグクリック
**処理内容**:
1. クエリパラメータ`brand`に選択ブランドIDをセット
2. クエリパラメータ`page`をnullにリセット（1ページ目に戻る）
3. 画面が再読み込みされ、フィルタ条件で商品一覧を再取得

### 3-タイプフィルタ選択

特定商品タイプのリンクをクリックすると、そのタイプの商品のみを表示する。

**トリガー**: CatalogSearch内のタイプタグクリック
**処理内容**:
1. クエリパラメータ`type`に選択タイプIDをセット
2. クエリパラメータ`page`をnullにリセット（1ページ目に戻る）
3. 画面が再読み込みされ、フィルタ条件で商品一覧を再取得

### 4-ページネーションリンククリック

ページ番号リンクをクリックすると、該当ページの商品一覧を表示する。

**トリガー**: ページリンク（NavLink）クリック
**処理内容**:
1. クエリパラメータ`page`に選択ページ番号をセット（1ページ目はnull）
2. 既存のフィルタ条件（brand、type）は維持
3. 画面が再読み込みされ、該当ページの商品一覧を取得

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | Catalog | SELECT | 商品一覧を取得 |
| 画面表示 | CatalogBrand | SELECT | ブランドマスタを取得 |
| 画面表示 | CatalogType | SELECT | 商品タイプマスタを取得 |

※ 本画面はデータ参照のみであり、INSERT/UPDATE/DELETE操作は発生しない

### テーブル別更新項目詳細

#### Catalog（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | Id, Name, Description, Price, PictureUrl, CatalogBrandId, CatalogTypeId | CatalogBrandId = @brand AND CatalogTypeId = @type | ページネーション適用 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 読み込み中 | catalogResultがnullの間 | "Loading..." |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| API通信エラー | 例外がスローされる | 上位でハンドリング |
| 該当商品なし | 空の商品一覧が表示される | エラーメッセージは表示されない |

## 備考

- StreamRendering属性が付与されており、サーバーサイドでの段階的レンダリングが有効
- ページサイズは9件で固定（PageSize定数）
- フィルタ条件変更時は常に1ページ目に戻る設計
- 画像URLはIProductImageUrlProviderを通じて取得され、環境に応じたURL解決が行われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | 商品データの構造（Id, Name, Price等）とCatalogResult, CatalogBrand, CatalogItemTypeの定義を理解 |

**読解のコツ**: C# recordは不変データクラスの簡潔な定義方法。各プロパティはコンストラクタパラメータとして宣言される。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Catalog.razor | `src/WebApp/Components/Pages/Catalog/Catalog.razor` | ページのルーティング（@page "/"）、クエリパラメータのバインディング、OnInitializedAsyncでの初期データ取得 |

**主要処理フロー**:
1. **行1**: `@page "/"` - ルートURLへのルーティング定義
2. **行37-47**: クエリパラメータ（Page, BrandId, ItemTypeId）のバインディング定義
3. **行54-61**: `OnInitializedAsync`でCatalogService.GetCatalogItemsを呼び出し商品一覧を取得
4. **行21-24**: 取得した商品データをforeachでCatalogListItemコンポーネントに渡してレンダリング
5. **行28-31**: ページネーションリンクを動的に生成

#### Step 3: フィルタコンポーネントを理解する

ブランド・タイプフィルタの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CatalogSearch.razor | `src/WebAppComponents/Catalog/CatalogSearch.razor` | フィルタUI、ブランド/タイプ一覧の取得、フィルタ適用時のURL生成ロジック |

**主要処理フロー**:
- **行55-62**: `OnInitializedAsync`でGetBrands()とGetTypes()を並列実行してマスタデータ取得
- **行64-68**: `BrandUri`メソッドでブランドフィルタ用URLを生成（pageをnullにリセット）
- **行70-74**: `TypeUri`メソッドでタイプフィルタ用URLを生成

#### Step 4: 商品表示コンポーネントを理解する

個々の商品カードの表示ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CatalogListItem.razor | `src/WebAppComponents/Catalog/CatalogListItem.razor` | 商品カードのHTML構造、画像URL取得、詳細画面へのリンク生成 |

**主要処理フロー**:
- **行5**: `ItemHelper.Url(Item)`で商品詳細画面へのURLを生成
- **行7**: `ProductImages.GetProductImageUrl(Item)`で商品画像URLを取得
- **行10-11**: 商品名と価格をフォーマットして表示

#### Step 5: サービス層を理解する

バックエンドAPIとの通信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ICatalogService.cs | `src/WebAppComponents/Services/ICatalogService.cs` | サービスインターフェースの定義、利用可能なメソッド一覧 |
| 5-2 | CatalogService.cs | `src/WebAppComponents/Services/CatalogService.cs` | HTTP通信の実装、APIエンドポイントの構築、JSONデシリアライズ |

**主要処理フロー**:
- **行17-22**: `GetCatalogItems` - ページネーション・フィルタ付き商品一覧取得
- **行38-43**: `GetBrands` - ブランドマスタ取得
- **行45-50**: `GetTypes` - 商品タイプマスタ取得
- **行52-66**: `GetAllCatalogItemsUri` - フィルタ条件付きAPIエンドポイントURL構築

### プログラム呼び出し階層図

```
Catalog.razor (ページコンポーネント)
    │
    ├─ CatalogSearch.razor (フィルタコンポーネント)
    │      │
    │      └─ CatalogService.cs
    │             ├─ GetBrands() → HTTP GET /api/catalog/catalogBrands
    │             └─ GetTypes() → HTTP GET /api/catalog/catalogTypes
    │
    ├─ CatalogService.cs
    │      └─ GetCatalogItems() → HTTP GET /api/catalog/items?...
    │
    └─ CatalogListItem.razor (商品カードコンポーネント) × N件
           │
           ├─ ItemHelper.cs
           │      └─ Url() → 商品詳細URL生成
           │
           └─ IProductImageUrlProvider
                  └─ GetProductImageUrl() → 商品画像URL生成
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クエリパラメータ          Catalog.razor
 - page ─────────────────┬─ OnInitializedAsync ──────────▶ catalogResult
 - brand ────────────────┤                                    │
 - type ─────────────────┘                                    ▼
                                                          CatalogListItem × N
                              CatalogSearch.razor              │
                              │                                ▼
                              ├─ GetBrands() ────────────▶ ブランドフィルタUI
                              └─ GetTypes() ─────────────▶ タイプフィルタUI

                              ページネーション計算 ──────▶ ページリンク群
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Catalog.razor | `src/WebApp/Components/Pages/Catalog/Catalog.razor` | ソース | カタログ画面のメインページコンポーネント |
| CatalogSearch.razor | `src/WebAppComponents/Catalog/CatalogSearch.razor` | ソース | ブランド・タイプフィルタコンポーネント |
| CatalogListItem.razor | `src/WebAppComponents/Catalog/CatalogListItem.razor` | ソース | 商品カード表示コンポーネント |
| CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | ソース | 商品データモデル定義 |
| ICatalogService.cs | `src/WebAppComponents/Services/ICatalogService.cs` | ソース | カタログサービスインターフェース |
| CatalogService.cs | `src/WebAppComponents/Services/CatalogService.cs` | ソース | カタログAPI通信サービス実装 |
| IProductImageUrlProvider.cs | `src/WebAppComponents/Services/IProductImageUrlProvider.cs` | ソース | 商品画像URL取得インターフェース |
| ItemHelper.cs | `src/WebAppComponents/Item/ItemHelper.cs` | ソース | 商品関連ヘルパーユーティリティ |
