# 画面設計書 10-ログアウト画面（Identity.API）

## 概要

本ドキュメントは、eShop Identity.APIのログアウト画面の設計仕様を定義する。ログアウト確認画面を表示し、ユーザーのセッションを終了する処理を実行する画面である。

### 本画面の処理概要

Identity.APIのログアウト画面は、ユーザーにログアウトの確認を求め、承認後にセッションを終了する画面である。OpenID Connectのシングルログアウト（SLO）機能をサポートしている。

**業務上の目的・背景**：eShopシステム全体のセッション管理において、安全なログアウトフローを提供する。ログアウト確認画面を表示することで、悪意のあるサイトからの強制ログアウト攻撃を防止する。また、フェデレーションされた外部IdPとの連携ログアウトもサポートしている。

**画面へのアクセス方法**：クライアントアプリケーション（WebApp等）からのOpenID Connectログアウトリクエストによりリダイレクトされる。WebAppのUserMenuからのログアウト操作時に到達する。

**主要な操作・処理内容**：
1. ログアウト確認：「Would you like to logout of IdentityServer?」の確認メッセージを表示
2. ログアウト承認：「Yes」ボタンでログアウト処理を実行
3. セッション終了：SignInManager.SignOutAsyncでセッションをクリア
4. ログアウト完了画面表示：LoggedOut画面を表示し、クライアントへのリダイレクトリンクを提供

**画面遷移**：
- 遷移元：WebAppログアウト処理（OpenID Connectログアウト）
- 遷移先：ログアウト完了画面→クライアントアプリケーション（PostLogoutRedirectUri）

**権限による表示制御**：ログアウト確認画面はShowLogoutPromptフラグで制御される。適切に認証されたログアウトリクエストの場合、確認画面をスキップして直接ログアウト処理が実行される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | ログアウト処理 | 主機能 | ログアウト確認・セッション終了 |

## 画面種別

確認

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/Account/Logout` |
| ルートパラメータ | なし |
| クエリパラメータ | `logoutId`: ログアウトコンテキストID |

## 入出力項目

### 入力項目（クエリ/フォームパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ログアウトID | logoutId | string | 必須 | ログアウトコンテキスト識別子 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認表示フラグ | ShowLogoutPrompt | 確認画面表示の要否 |

## 表示項目

### ログアウト確認画面（Logout.cshtml）

| 項目名 | 表示内容 | 備考 |
|--------|---------|------|
| タイトル | "Logout" | h1タグ |
| 確認メッセージ | "Would you like to logut of IdentityServer?" | typoあり（logut→logout） |
| 確認ボタン | "Yes" | フォーム送信 |

### ログアウト完了画面（LoggedOut.cshtml）

| 項目名 | 条件 | 表示内容 | 備考 |
|--------|------|---------|------|
| タイトル | 常時 | "Logout" | h1タグ |
| 完了メッセージ | 常時 | "You are now logged out" | smallタグ |
| リダイレクトリンク | PostLogoutRedirectUri != null | "Click here to return to the {ClientName} application." | |
| サインアウトiframe | SignOutIframeUrl != null | 非表示iframe | フェデレーションログアウト用 |

## イベント仕様

### 1-ログアウト確認表示（GET）

ログアウト画面にアクセスすると、確認画面を表示する（または直接ログアウト実行）。

**トリガー**: GET /Account/Logout?logoutId={id}
**処理内容**:
1. AccountController.Logout(logoutId)が呼び出される
2. BuildLogoutViewModelAsyncでビューモデル構築
3. ShowLogoutPrompt == falseの場合、直接POST処理へ
4. ShowLogoutPrompt == trueの場合、確認画面を表示

**ShowLogoutPromptの判定**:
- 未認証ユーザー: false（確認不要）
- GetLogoutContextAsync().ShowSignoutPrompt == false: false（信頼できるリクエスト）
- それ以外: true（確認必要）

### 2-ログアウト実行（POST）

「Yes」ボタンをクリック（またはShowLogoutPrompt == false時の自動実行）すると、ログアウト処理が実行される。

**トリガー**: POST /Account/Logout（logoutIdをフォーム送信）
**処理内容**:
1. AccountController.Logout(LogoutInputModel)が呼び出される
2. BuildLoggedOutViewModelAsyncでビューモデル構築
3. 認証済みの場合：
   - SignInManager.SignOutAsyncでローカル認証クッキーを削除
   - UserLogoutSuccessEventを発行
4. TriggerExternalSignout == trueの場合：
   - 外部IdPのログアウトへリダイレクト
5. View("LoggedOut", vm)でログアウト完了画面を表示

**データの流れ**:
```
ユーザー → Yes ボタンクリック
                ↓
        AccountController.Logout (POST)
                ↓
        BuildLoggedOutViewModelAsync
                ↓
        SignInManager.SignOutAsync
                ↓
        UserLogoutSuccessEvent発行
                ↓
        (TriggerExternalSignout?)
                ├─ Yes → 外部IdPへリダイレクト
                └─ No → LoggedOut画面表示
```

### 3-クライアントへのリダイレクト

ログアウト完了後、PostLogoutRedirectUriへリダイレクトする。

**トリガー**: ログアウト完了画面表示後
**処理内容**:
- AutomaticRedirectAfterSignOut == trueの場合、JavaScriptで自動リダイレクト
- それ以外の場合、ユーザーがリンクをクリックしてリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース直接操作なし |

※ セッション情報はCookieベースであり、データベースには直接影響しない

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 確認メッセージ | Logout画面 | "Would you like to logut of IdentityServer?" |
| 完了メッセージ | LoggedOut画面 | "You are now logged out" |
| リダイレクト案内 | PostLogoutRedirectUri存在 | "Click here to return to the {ClientName} application." |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 無効なlogoutId | ログアウト処理は実行されるが、リダイレクト先が不明 | |

## 備考

- IdentityServer4（Duende IdentityServer）のQuickstartテンプレートをベースとしている
- ShowLogoutPromptでログアウト確認画面のスキップを制御（セキュリティ対策）
- SignOutIframeUrlは、フェデレーションされた他のアプリケーションのログアウトを連携するためのiframe
- AutomaticRedirectAfterSignOutでログアウト後の自動リダイレクトを制御
- TriggerExternalSignoutで外部IdP（Google、Azure AD等）との連携ログアウトを実行
- ViewData["signed-out"]でレイアウト側に匿名ユーザー状態を通知
- Logout.cshtmlの確認メッセージに"logut"のtypoがある（"logout"が正しい）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogoutViewModel.cs | `src/Identity.API/Quickstart/Account/LogoutViewModel.cs` | 確認画面用ビューモデル（ShowLogoutPrompt） |
| 1-2 | LoggedOutViewModel.cs | `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs` | 完了画面用ビューモデル（PostLogoutRedirectUri、AutomaticRedirectAfterSignOut等） |

**読解のコツ**: LogoutViewModelは確認画面、LoggedOutViewModelは完了画面で使用される別のモデル。TriggerExternalSignoutは外部IdP連携のフラグ。

#### Step 2: ビューを理解する

実際の画面表示を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Logout.cshtml | `src/Identity.API/Views/Account/Logout.cshtml` | 確認画面、logoutIdのhidden field |
| 2-2 | LoggedOut.cshtml | `src/Identity.API/Views/Account/LoggedOut.cshtml` | 完了画面、リダイレクトリンク、サインアウトiframe |

**主要処理フロー**:
- Logout.cshtml **行10**: logoutIdをhiddenで保持
- LoggedOut.cshtml **行14-20**: PostLogoutRedirectUri存在時のリダイレクトリンク
- LoggedOut.cshtml **行22-25**: SignOutIframeUrlによるフェデレーションログアウト
- LoggedOut.cshtml **行30-33**: AutomaticRedirectAfterSignOutによる自動リダイレクト

#### Step 3: コントローラーを理解する

ログアウト処理のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | Logout GET/POST、BuildLogoutViewModelAsync、BuildLoggedOutViewModelAsync |

**主要処理フロー**:
- **行146-160**: `Logout` (GET) - ビューモデル構築、ShowLogoutPrompt判定
- **行165-194**: `Logout` (POST) - サインアウト実行、イベント発行
- **行272-294**: `BuildLogoutViewModelAsync` - ShowLogoutPrompt判定ロジック
- **行296-332**: `BuildLoggedOutViewModelAsync` - ログアウト完了情報構築

### プログラム呼び出し階層図

```
AccountController (コントローラー)
    │
    ├─ Logout (GET)
    │      └─ BuildLogoutViewModelAsync
    │             └─ _interaction.GetLogoutContextAsync
    │                    │
    │                    └─ ShowLogoutPrompt判定
    │                           ├─ true → View(LogoutViewModel)
    │                           └─ false → Logout (POST)へ
    │
    └─ Logout (POST)
           ├─ BuildLoggedOutViewModelAsync
           │      └─ _interaction.GetLogoutContextAsync
           │
           ├─ _signInManager.SignOutAsync
           │
           ├─ _events.RaiseAsync(UserLogoutSuccessEvent)
           │
           └─ (TriggerExternalSignout?)
                  ├─ true → SignOut(外部IdP)
                  └─ false → View("LoggedOut", vm)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クエリパラメータ          AccountController
 - logoutId ──────────────┬─ Logout (GET)
                          │      │
                          │      └─ BuildLogoutViewModelAsync
                          │             │
                          │             ├─ ShowLogoutPrompt = true ─▶ 確認画面表示
                          │             │
                          │             └─ ShowLogoutPrompt = false ▶ Logout (POST)

フォーム送信              │
 - logoutId ──────────────┼─ Logout (POST)
                          │      │
                          │      ├─ SignOutAsync ─────────────────▶ Cookie削除
                          │      │
                          │      ├─ UserLogoutSuccessEvent ───────▶ イベント発行
                          │      │
                          │      └─ View("LoggedOut") ────────────▶ 完了画面表示
                          │                                              │
                          │                                              ▼
                          │                                        (自動リダイレクト or リンククリック)
                          │                                              │
                          │                                              ▼
                          └─────────────────────────────────────▶ クライアントへ戻る
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Logout.cshtml | `src/Identity.API/Views/Account/Logout.cshtml` | ビュー | ログアウト確認画面 |
| LoggedOut.cshtml | `src/Identity.API/Views/Account/LoggedOut.cshtml` | ビュー | ログアウト完了画面 |
| AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | ソース | ログアウト処理コントローラー |
| LogoutViewModel.cs | `src/Identity.API/Quickstart/Account/LogoutViewModel.cs` | ソース | 確認画面ビューモデル |
| LoggedOutViewModel.cs | `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs` | ソース | 完了画面ビューモデル |
| signout-redirect.js | `src/Identity.API/wwwroot/js/signout-redirect.js` | JavaScript | 自動リダイレクト処理 |
