# 画面設計書 11-ログアウト完了画面

## 概要

本ドキュメントは、Identity.APIのログアウト完了画面（LoggedOut）の画面設計書である。この画面はIdentityServer4の認証フローにおいて、ユーザーのログアウト処理が完了した後に表示される確認画面である。

### 本画面の処理概要

ログアウト完了画面は、ユーザーがIdentityServer4からログアウトした後に表示される確認画面であり、ログアウト処理の完了を通知し、クライアントアプリケーションへの復帰リンクを提供する。

**業務上の目的・背景**：OAuth2.0/OpenID Connect認証フローにおいて、ユーザーがセキュアにログアウトしたことを確認させる必要がある。本画面は、ログアウト処理が正常に完了したことをユーザーに通知し、元のクライアントアプリケーションへのスムーズな復帰を支援する。また、フェデレーション認証（複数のIdentity Provider連携）時の単一サインアウト（SLO）をサポートするiframeも提供している。

**画面へのアクセス方法**：本画面は直接アクセスする画面ではない。AccountControllerのLogout POST処理が完了した後に、自動的に表示される。WebAppやWebhookClientなどのクライアントアプリケーションでログアウト操作を行うと、Identity.APIのログアウト処理を経て本画面に到達する。

**主要な操作・処理内容**：
1. ログアウト完了メッセージの表示（"You are now logged out"）
2. クライアントアプリケーションへの復帰リンクの提供（PostLogoutRedirectUriが設定されている場合）
3. フェデレーション認証時のサインアウト用iframe表示（SignOutIframeUrlが設定されている場合）
4. 自動リダイレクト機能（AutomaticRedirectAfterSignOutが有効な場合）

**画面遷移**：
- 遷移元：ログアウト画面（AccountController.Logout POST処理）
- 遷移先：クライアントアプリケーション（PostLogoutRedirectUri）、または自動リダイレクト先

**権限による表示制御**：本画面は認証状態に関わらず表示される（AllowAnonymous）。ただし、ViewDataに"signed-out"フラグが設定され、レイアウトでは匿名ユーザーとして扱われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | ログアウト処理 | 補助機能 | ログアウト完了メッセージ・リダイレクト表示 |

## 画面種別

メッセージ表示（ログアウト完了確認）

## URL/ルーティング

- URL: `/Account/Logout`（POST処理後にView "LoggedOut"として表示）
- Controller: `AccountController`
- Action: `Logout` (POST) -> View("LoggedOut", vm)

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| PostLogoutRedirectUri | PostLogoutRedirectUri | string | 出力 | - | クライアントアプリへの復帰URL |
| ClientName | ClientName | string | 出力 | - | クライアントアプリ名 |
| SignOutIframeUrl | SignOutIframeUrl | string | 出力 | - | SLO用iframe URL |
| AutomaticRedirectAfterSignOut | AutomaticRedirectAfterSignOut | bool | 出力 | - | 自動リダイレクト有効フラグ |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Logout" |
| サブタイトル | smallテキスト | "You are now logged out" |
| 復帰リンク | アンカーリンク | PostLogoutRedirectUri設定時のみ表示 |
| クライアント名 | spanテキスト | ClientName |
| サインアウトiframe | 非表示iframe | SignOutIframeUrl設定時のみ表示 |

## イベント仕様

### 1-復帰リンククリック

ユーザーが復帰リンク（"here"リンク）をクリックすると、PostLogoutRedirectUriで指定されたクライアントアプリケーションへリダイレクトされる。

### 2-自動リダイレクト

AutomaticRedirectAfterSignOutがtrueの場合、ページ読み込み時にsignout-redirect.jsが実行され、PostLogoutRedirectUriへ自動リダイレクトされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面は表示専用であり、データベースへの直接的な操作は行わない。ログアウト処理自体はAccountController.Logoutで完了しており、認証Cookieの削除やセッション終了処理はそちらで実行される。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "You are now logged out" | 常時表示 |
| MSG-002 | "Click here to return to the {ClientName} application." | PostLogoutRedirectUri設定時 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| PostLogoutRedirectUri未設定 | 復帰リンクを非表示にし、ログアウト完了メッセージのみ表示 |
| SignOutIframeUrl未設定 | サインアウトiframeを非表示 |
| ClientName未取得 | 復帰リンクのテキストでClientNameを省略 |

## 備考

- AccountOptions.AutomaticRedirectAfterSignOutはデフォルトでtrueに設定されている
- SignOutIframeUrlはフェデレーション認証（外部IdP連携）時の単一サインアウト（SLO）をサポートするために使用される
- ViewDataに"signed-out"フラグを設定することで、レイアウト側でログイン状態に応じたUI切り替えが可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LoggedOutViewModel.cs | `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs` | ログアウト完了画面に渡されるデータ構造。PostLogoutRedirectUri、ClientName、SignOutIframeUrl、AutomaticRedirectAfterSignOut等のプロパティを確認 |
| 1-2 | AccountOptions.cs | `src/Identity.API/Quickstart/Account/AccountOptions.cs` | AutomaticRedirectAfterSignOut等のデフォルト設定値を確認 |

**読解のコツ**: LoggedOutViewModelはシンプルなPOCOクラスで、ログアウト処理の結果情報を保持する。TriggerExternalSignoutプロパティは計算プロパティであり、外部認証プロバイダーへのサインアウトが必要かを判定する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | Logout POSTアクション（行167-194）がView("LoggedOut", vm)を返す流れを確認 |

**主要処理フロー**:
1. **行167-168**: LogoutInputModelを受け取り、BuildLoggedOutViewModelAsyncを呼び出す
2. **行170**: BuildLoggedOutViewModelAsyncでログアウトコンテキストから情報を取得
3. **行172-178**: 認証済みユーザーの場合、SignOutAsyncでCookie削除、UserLogoutSuccessEventを発行
4. **行181-191**: 外部IdPへのサインアウトが必要な場合の処理
5. **行193**: View("LoggedOut", vm)でログアウト完了画面を表示

#### Step 3: ViewModelビルド処理を理解する

LoggedOutViewModelの生成ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | BuildLoggedOutViewModelAsync（行296-332）のロジックを確認 |

**主要処理フロー**:
- **行299**: IIdentityServerInteractionService.GetLogoutContextAsyncでログアウトコンテキストを取得
- **行301-308**: ViewModelの基本プロパティを設定（PostLogoutRedirectUri、ClientName、SignOutIframeUrl）
- **行310-328**: 外部IdPでのサインアウト処理判定（TriggerExternalSignout）

#### Step 4: ビュー表示を理解する

Razorビューでのデータ表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LoggedOut.cshtml | `src/Identity.API/Views/Account/LoggedOut.cshtml` | ViewModelのプロパティに基づく条件分岐表示を確認 |

**主要処理フロー**:
- **行1**: @model LoggedOutViewModelでViewModelを受け取る
- **行3-6**: ViewData["signed-out"]にtrueを設定（レイアウト用）
- **行14-20**: PostLogoutRedirectUriがnullでない場合のみ復帰リンクを表示
- **行22-25**: SignOutIframeUrlがnullでない場合のみiframeを表示
- **行30-33**: AutomaticRedirectAfterSignOutがtrueの場合、リダイレクトスクリプトを読み込む

### プログラム呼び出し階層図

```
AccountController.Logout(POST)
    │
    ├─ BuildLoggedOutViewModelAsync(logoutId)
    │      │
    │      └─ IIdentityServerInteractionService.GetLogoutContextAsync(logoutId)
    │             └─ LogoutContext（PostLogoutRedirectUri、ClientName等を含む）
    │
    ├─ SignInManager.SignOutAsync()
    │      └─ 認証Cookieの削除
    │
    ├─ IEventService.RaiseAsync(UserLogoutSuccessEvent)
    │      └─ ログアウト成功イベントの発行
    │
    └─ View("LoggedOut", LoggedOutViewModel)
           └─ LoggedOut.cshtml
                  ├─ 復帰リンク表示（条件付き）
                  ├─ SLO iframe表示（条件付き）
                  └─ signout-redirect.js読み込み（条件付き）
```

### データフロー図

```
[入力]                         [処理]                              [出力]

LogoutId ───────────────▶ GetLogoutContextAsync ───────────────▶ LogoutContext
                                    │
                                    ▼
                         BuildLoggedOutViewModelAsync
                                    │
                                    ▼
                         LoggedOutViewModel
                         - PostLogoutRedirectUri
                         - ClientName
                         - SignOutIframeUrl
                         - AutomaticRedirectAfterSignOut
                                    │
                                    ▼
                         LoggedOut.cshtml ───────────────────▶ HTML出力
                                    │
                                    ├─▶ 復帰リンク（条件付き）
                                    ├─▶ iframe（条件付き）
                                    └─▶ 自動リダイレクト（条件付き）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LoggedOut.cshtml | `src/Identity.API/Views/Account/LoggedOut.cshtml` | ビュー | ログアウト完了画面のRazorテンプレート |
| AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | コントローラー | ログアウト処理のエントリーポイント |
| LoggedOutViewModel.cs | `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs` | ViewModel | 画面表示用データモデル |
| AccountOptions.cs | `src/Identity.API/Quickstart/Account/AccountOptions.cs` | 設定 | 自動リダイレクト等のオプション設定 |
| signout-redirect.js | `src/Identity.API/wwwroot/js/signout-redirect.js` | JavaScript | 自動リダイレクト処理 |
