# 画面設計書 12-アクセス拒否画面

## 概要

本ドキュメントは、Identity.APIのアクセス拒否画面（AccessDenied）の画面設計書である。この画面はIdentityServer4の認証フローにおいて、ユーザーがアクセス権限を持たないリソースへアクセスしようとした際に表示されるエラー画面である。

### 本画面の処理概要

アクセス拒否画面は、認証・認可処理においてユーザーに適切な権限がない場合に表示されるシンプルなエラーメッセージ画面である。

**業務上の目的・背景**：OAuth2.0/OpenID Connect認証フローにおいて、認証は成功したがリソースへのアクセス権限が不足している場合がある。このような状況でユーザーに対して明確なフィードバックを提供し、不正アクセスを防止するとともに、ユーザー体験を損なわないようにすることが本画面の目的である。例えば、管理者専用ページに一般ユーザーがアクセスしようとした場合などに表示される。

**画面へのアクセス方法**：本画面は直接アクセスする画面ではない。ASP.NET CoreのAuthorize属性による認可チェックに失敗した場合、または認可ポリシーを満たさない場合に自動的にリダイレクトされる。URLは`/Account/AccessDenied`となる。

**主要な操作・処理内容**：
1. アクセス拒否メッセージの表示（"Access Denied"）
2. 権限不足の説明メッセージ表示（"You do not have access to that resource."）

**画面遷移**：
- 遷移元：認可チェックに失敗した任意の画面/リソース
- 遷移先：特に定義されていない（ユーザーはブラウザの戻るボタンや他のナビゲーションを使用）

**権限による表示制御**：本画面自体はAllowAnonymous属性により誰でもアクセス可能である。アクセス拒否という状況が権限不足を示すものであり、本画面の表示自体は権限を必要としない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | アクセス権限不足時のエラー表示 |

## 画面種別

エラー表示（アクセス拒否メッセージ）

## URL/ルーティング

- URL: `/Account/AccessDenied`
- Controller: `AccountController`
- Action: `AccessDenied` (GET)

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| - | - | - | - | - | 本画面はViewModelを使用しない静的表示 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Access Denied" |
| 説明メッセージ | pテキスト | "You do not have access to that resource." |

## イベント仕様

本画面にはユーザー操作可能なイベントは存在しない。表示専用の静的ページである。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面は静的なエラーメッセージを表示するのみであり、データベースへの操作は一切行わない。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Access Denied" | 常時表示（タイトル） |
| MSG-002 | "You do not have access to that resource." | 常時表示（説明） |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| - | 本画面自体がエラー表示画面であり、例外処理は特になし |

## 備考

- 本画面はViewModelを使用せず、静的なHTMLコンテンツを表示するシンプルな構造
- ASP.NET Coreのデフォルトのアクセス拒否パス（`/Account/AccessDenied`）に対応
- Bootstrap CSSクラス（container、lead）を使用したシンプルなレイアウト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はViewModelを使用しないシンプルな構造であるため、データ構造の理解は不要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| - | - | - | ViewModelなし（静的HTML） |

**読解のコツ**: 本画面は静的なエラーメッセージを表示するのみで、動的なデータバインディングは行われない。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | AccessDeniedアクション（行196-200）の実装を確認 |

**主要処理フロー**:
1. **行196-197**: HttpGet属性でGETリクエストを受け付け
2. **行198-199**: AccessDeniedアクションでView()を返却（ViewModelなし）

#### Step 3: ビュー表示を理解する

Razorビューでの静的表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AccessDenied.cshtml | `src/Identity.API/Views/Account/AccessDenied.cshtml` | シンプルな静的HTML構造を確認 |

**主要処理フロー**:
- **行2**: div.containerでBootstrapコンテナを定義
- **行3-4**: div.leadクラスでリードスタイルを適用
- **行4**: h1で"Access Denied"タイトルを表示
- **行5**: pで説明メッセージを表示

### プログラム呼び出し階層図

```
認可チェック失敗
    │
    ▼
リダイレクト: /Account/AccessDenied
    │
    ▼
AccountController.AccessDenied()
    │
    └─ View()
           │
           ▼
       AccessDenied.cshtml
           │
           └─ 静的HTML出力
                  ├─ "Access Denied"
                  └─ "You do not have access to that resource."
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認可失敗リダイレクト ───▶ AccountController.AccessDenied() ───▶ View()
                                                                   │
                                                                   ▼
                                                        AccessDenied.cshtml
                                                                   │
                                                                   ▼
                                                        静的HTMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AccessDenied.cshtml | `src/Identity.API/Views/Account/AccessDenied.cshtml` | ビュー | アクセス拒否画面のRazorテンプレート |
| AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | コントローラー | AccessDeniedアクションのエントリーポイント |
