# 画面設計書 13-ホーム画面

## 概要

本ドキュメントは、Identity.APIのホーム画面（Home/Index）の画面設計書である。この画面はIdentityServer4のウェルカムページとして機能し、ディスカバリードキュメントへのリンクや管理機能へのナビゲーションを提供する。

### 本画面の処理概要

ホーム画面は、IdentityServer4認証サーバーの管理者向けエントリーポイントとして機能するウェルカムページである。IdentityServerのメタデータや管理機能へのアクセスを提供する。

**業務上の目的・背景**：IdentityServer4を運用する管理者が、認証サーバーの状態確認やデバッグを行うためのポータルとして本画面が必要である。OAuth2.0/OpenID Connectのディスカバリードキュメント（`.well-known/openid-configuration`）へのアクセス、現在のセッション情報の診断、付与済み権限の管理など、認証サーバーの運用に必要な機能へのナビゲーションを一元的に提供する。なお、本画面は開発環境でのみ表示され、本番環境では404を返す。

**画面へのアクセス方法**：Identity.APIのルートURL（`/`）にアクセスすることで表示される。ただし、開発環境（Development）でのみアクセス可能であり、本番環境ではアクセスできない。

**主要な操作・処理内容**：
1. IdentityServerのバージョン情報表示
2. ディスカバリードキュメント（`.well-known/openid-configuration`）へのリンク提供
3. 診断画面（`/diagnostics`）へのリンク提供 - 現在のセッションのクレーム確認
4. 権限管理画面（`/grants`）へのリンク提供 - 付与済み権限の管理
5. GitHub上のソースコード・サンプルへの外部リンク提供

**画面遷移**：
- 遷移元：直接アクセス（Identity.APIルート）
- 遷移先：診断画面（/diagnostics）、権限管理画面（/grants）、ディスカバリードキュメント

**権限による表示制御**：AllowAnonymous属性により認証不要でアクセス可能。ただし、環境チェック（IsDevelopment）により開発環境でのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | IdentityServer4管理リンクへのナビゲーション |

## 画面種別

ポータル（ナビゲーション/ウェルカムページ）

## URL/ルーティング

- URL: `/` または `/Home/Index`
- Controller: `HomeController`
- Action: `Index` (GET)

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| - | - | - | - | - | 本画面はViewModelを使用しない静的表示 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| アイコン | img | icon.jpg（IdentityServerアイコン） |
| タイトル | h1テキスト | "Welcome to IdentityServer4" |
| バージョン | smallテキスト | Duende.IdentityServerのProductVersion |
| ディスカバリードキュメントリンク | aタグ | `~/.well-known/openid-configuration` |
| 診断画面リンク | aタグ | `~/diagnostics` |
| 権限管理画面リンク | aタグ | `~/grants` |
| GitHubリポジトリリンク | aタグ | 外部リンク（source code repository） |
| サンプルリンク | aタグ | 外部リンク（ready to use samples） |

## イベント仕様

### 1-ディスカバリードキュメントリンククリック

ユーザーが"discovery document"リンクをクリックすると、IdentityServerのOpenID Connect Discovery Endpoint（`/.well-known/openid-configuration`）へ遷移する。このエンドポイントはIdentityServerの設定情報をJSON形式で返却する。

### 2-診断画面リンククリック

ユーザーが"here"リンク（診断）をクリックすると、診断画面（`/diagnostics`）へ遷移する。現在のセッションのクレームとプロパティを確認できる。

### 3-権限管理画面リンククリック

ユーザーが"here"リンク（権限管理）をクリックすると、権限管理画面（`/grants`）へ遷移する。付与済みの権限を確認・取り消しできる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面はナビゲーション機能のみを提供し、データベースへの操作は行わない。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Welcome to IdentityServer4" | 常時表示（タイトル） |
| MSG-002 | "(version {version})" | 常時表示（バージョン情報） |
| MSG-003 | "IdentityServer publishes a discovery document..." | 常時表示（説明） |
| MSG-004 | "Click here to see the claims for your current session." | 常時表示 |
| MSG-005 | "Click here to manage your stored grants." | 常時表示 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| 本番環境でのアクセス | 404 NotFoundを返却し、ログに記録 |

## 備考

- 本画面は開発環境（IsDevelopment）でのみ表示される
- 本番環境でアクセスした場合、HomeControllerは404を返却する
- バージョン情報はDuende.IdentityServer.Hosting.IdentityServerMiddlewareアセンブリから動的に取得
- 画面タイトルは"IdentityServer4"となっているが、実際にはDuende IdentityServerが使用されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はViewModelを使用しないが、バージョン情報の取得ロジックを理解する必要がある。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Index.cshtml | `src/Identity.API/Views/Home/Index.cshtml` | Razor内でのバージョン情報取得方法を確認 |

**読解のコツ**: ビュー内で`System.Diagnostics.FileVersionInfo`を使用してアセンブリバージョンを動的に取得している。これはViewModelではなくRazor内のC#コードブロックで実装されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HomeController.cs | `src/Identity.API/Quickstart/Home/HomeController.cs` | Indexアクション（行24-34）の環境チェックロジックを確認 |

**主要処理フロー**:
1. **行24**: Indexアクションが呼び出される
2. **行26-29**: IsDevelopment()で開発環境かチェック
3. **行28**: 開発環境の場合、View()を返却
4. **行32-33**: 本番環境の場合、ログ出力してNotFound()を返却

#### Step 3: ビュー表示を理解する

Razorビューでの動的バージョン取得と静的表示を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Index.cshtml | `src/Identity.API/Views/Home/Index.cshtml` | バージョン情報取得とナビゲーションリンクを確認 |

**主要処理フロー**:
- **行1-2**: System.Diagnosticsのusing宣言
- **行4-5**: FileVersionInfoでIdentityServerMiddlewareのバージョンを取得、'+'で分割して最初の部分のみ使用
- **行8-12**: h1でタイトルとバージョンを表示
- **行14-31**: ulリストでナビゲーションリンクを提供

### プログラム呼び出し階層図

```
HTTP GET /
    │
    ▼
HomeController.Index()
    │
    ├─ IWebHostEnvironment.IsDevelopment()
    │      │
    │      ├─ true  ───▶ View()
    │      │                │
    │      │                ▼
    │      │          Index.cshtml
    │      │                │
    │      │                └─ HTML出力（ナビゲーションリンク付き）
    │      │
    │      └─ false ───▶ NotFound()
    │                        │
    │                        └─ 404レスポンス
    │
    └─ ILogger.LogInformation()（本番環境のみ）
```

### データフロー図

```
[入力]                    [処理]                              [出力]

HTTP GET / ─────────▶ HomeController.Index()
                              │
                              ▼
                    IsDevelopment() チェック
                              │
           ┌──────────────────┴──────────────────┐
           ▼                                      ▼
     開発環境: true                         本番環境: false
           │                                      │
           ▼                                      ▼
     View() 返却                          NotFound() 返却
           │                                      │
           ▼                                      ▼
     Index.cshtml                           404 レスポンス
           │
           ▼
FileVersionInfo.GetVersionInfo()
           │
           ▼
     HTML出力
     - バージョン情報
     - ナビゲーションリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Index.cshtml | `src/Identity.API/Views/Home/Index.cshtml` | ビュー | ホーム画面のRazorテンプレート |
| HomeController.cs | `src/Identity.API/Quickstart/Home/HomeController.cs` | コントローラー | ホーム画面のエントリーポイント |
| icon.jpg | `src/Identity.API/wwwroot/icon.jpg` | 静的ファイル | IdentityServerアイコン画像 |
