# 画面設計書 14-同意画面

## 概要

本ドキュメントは、Identity.APIの同意画面（Consent/Index）の画面設計書である。この画面はOAuth2.0/OpenID Connect認証フローにおいて、ユーザーがクライアントアプリケーションへの権限付与を確認・承認するための画面である。

### 本画面の処理概要

同意画面は、OAuth2.0認可フローにおいてクライアントアプリケーションがユーザーのリソースへアクセスする許可を求める際に表示される。ユーザーは要求されたスコープ（権限）を確認し、許可または拒否を選択できる。

**業務上の目的・背景**：OAuth2.0プロトコルでは、クライアントアプリケーションがユーザーのデータにアクセスする前に、ユーザーの明示的な同意を得ることが求められる。本画面はこの「同意」フローを実現し、ユーザーが自身のデータへのアクセス権限をコントロールできるようにする。例えば、WebAppやWebhookClientがIdentity.APIを通じてユーザー認証を行う際、初回アクセス時にどのスコープ（profile、email、API accessなど）を許可するか確認される。

**画面へのアクセス方法**：本画面は直接アクセスする画面ではない。OAuth2.0認可リクエストの処理中、クライアントアプリケーションが要求するスコープに対してユーザーの同意が必要な場合に、IdentityServerから自動的にリダイレクトされる。URLパラメータとしてreturnUrlが付与される。

**主要な操作・処理内容**：
1. クライアントアプリケーション情報の表示（名前、ロゴ、URL）
2. 要求されたIdentity Scopes（Personal Information）の一覧表示
3. 要求されたAPI Scopes（Application Access）の一覧表示
4. 各スコープのチェックボックスによる選択/解除
5. デバイス説明の入力（オプション）
6. 「Remember My Decision」チェックボックスで同意の記憶
7. 「Yes, Allow」ボタンで許可、「No, Do Not Allow」ボタンで拒否

**画面遷移**：
- 遷移元：ログイン画面（認証成功後、同意が必要な場合）
- 遷移先（許可時）：クライアントアプリケーション（returnUrl）
- 遷移先（拒否時）：クライアントアプリケーション（access_deniedエラー）

**権限による表示制御**：本画面はAuthorize属性により認証必須。ログイン済みユーザーのみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 主機能 | OAuth同意画面でクライアントへの権限付与確認 |
| 34 | サインイン処理 | 補助機能 | 同意後のサインイン処理 |

## 画面種別

確認/入力（権限同意フォーム）

## URL/ルーティング

- URL: `/Consent?returnUrl={encoded_url}`
- Controller: `ConsentController`
- Action: `Index` (GET/POST)

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| returnUrl | ReturnUrl | string | 入力 | ○ | 認可リクエストのreturn URL（hidden） |
| 同意スコープ | ScopesConsented | IEnumerable<string> | 入力 | △ | 許可時は1つ以上必須 |
| 同意を記憶 | RememberConsent | bool | 入力 | - | デフォルトtrue |
| デバイス説明 | Description | string | 入力 | - | 任意入力 |
| ボタン選択 | Button | string | 入力 | ○ | "yes" または "no" |

### 出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| クライアント名 | ClientName | string | 出力 | ○ | アプリケーション名 |
| クライアントURL | ClientUrl | string | 出力 | - | アプリケーションURL |
| クライアントロゴURL | ClientLogoUrl | string | 出力 | - | アプリケーションロゴ |
| 同意記憶許可 | AllowRememberConsent | bool | 出力 | ○ | 同意記憶の可否 |
| Identity Scopes | IdentityScopes | IEnumerable<ScopeViewModel> | 出力 | - | 個人情報スコープ一覧 |
| API Scopes | ApiScopes | IEnumerable<ScopeViewModel> | 出力 | - | APIアクセススコープ一覧 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| クライアントロゴ | img | ClientLogoUrl設定時のみ表示 |
| クライアント名 | h1テキスト | "{ClientName} is requesting your permission" |
| 説明文 | pテキスト | "Uncheck the permissions you do not wish to grant." |
| Identity Scopes一覧 | カード/チェックボックス | "Personal Information"セクション |
| API Scopes一覧 | カード/チェックボックス | "Application Access"セクション |
| デバイス説明入力 | テキストボックス | "Description or name of device" |
| 同意記憶チェック | チェックボックス | "Remember My Decision" |
| 許可ボタン | ボタン | "Yes, Allow" |
| 拒否ボタン | ボタン | "No, Do Not Allow" |
| クライアント情報リンク | ボタン | ClientUrl設定時のみ表示 |

## イベント仕様

### 1-許可ボタン押下（Yes, Allow）

ユーザーが「Yes, Allow」ボタンを押下すると、選択されたスコープの同意情報がIdentityServerに記録され、クライアントアプリケーションにリダイレクトされる。

**処理フロー**:
1. ConsentController.Index(POST)が呼び出される
2. ProcessConsent()で同意内容を処理
3. ScopesConsentedが空でないことを検証
4. ConsentResponseを作成し、IIdentityServerInteractionService.GrantConsentAsync()を呼び出す
5. ConsentGrantedEventを発行
6. returnUrlへリダイレクト

### 2-拒否ボタン押下（No, Do Not Allow）

ユーザーが「No, Do Not Allow」ボタンを押下すると、アクセス拒否レスポンスがクライアントアプリケーションに返却される。

**処理フロー**:
1. ConsentController.Index(POST)が呼び出される
2. ProcessConsent()でbutton="no"を検出
3. ConsentResponse { Error = AuthorizationError.AccessDenied }を作成
4. ConsentDeniedEventを発行
5. クライアントアプリケーションにaccess_deniedエラーをリダイレクト

### 3-スコープチェックボックス変更

ユーザーがスコープのチェックボックスを変更すると、ScopesConsentedの内容が更新される。Required属性を持つスコープはdisabledで常にチェック状態となる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 許可ボタン押下（RememberConsent=true） | PersistedGrants | INSERT | 同意情報を永続化 |
| - | - | - | 拒否時はDB更新なし |

### テーブル別更新項目詳細

#### PersistedGrants（IdentityServer管理）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | Key | 自動生成 | 同意の一意キー |
| INSERT | Type | "user_consent" | 同意タイプ |
| INSERT | SubjectId | User.GetSubjectId() | ユーザーID |
| INSERT | ClientId | request.Client.ClientId | クライアントID |
| INSERT | CreationTime | DateTime.UtcNow | 作成日時 |
| INSERT | Data | シリアライズされた同意情報 | 同意スコープ等 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "{ClientName} is requesting your permission" | 常時表示 |
| MSG-002 | "Uncheck the permissions you do not wish to grant." | 常時表示 |
| MSG-003 | "Personal Information" | IdentityScopes存在時 |
| MSG-004 | "Application Access" | ApiScopes存在時 |
| MSG-005 | "Remember My Decision" | AllowRememberConsent=true時 |
| ERR-001 | "You must pick at least one permission" | 許可時にスコープ未選択 |
| ERR-002 | "Invalid selection" | 不正なボタン選択 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| returnUrlが無効 | Errorビューを表示 |
| 認可コンテキストが取得できない | Errorビューを表示、ログ出力 |
| スコープ未選択で許可 | バリデーションエラーメッセージを表示 |

## 備考

- ConsentOptionsクラスでオフラインアクセススコープの表示設定が可能
- ネイティブクライアント（IsNativeClient=true）の場合はLoadingPageを経由してリダイレクト
- AllowRememberConsentはクライアント設定で制御される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelとInputModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConsentViewModel.cs | `src/Identity.API/Quickstart/Consent/ConsentViewModel.cs` | ConsentInputModelを継承し、クライアント情報とスコープ一覧を保持 |
| 1-2 | ConsentInputModel.cs | `src/Identity.API/Quickstart/Consent/ConsentInputModel.cs` | フォーム送信データ（Button、ScopesConsented、RememberConsent等） |
| 1-3 | ScopeViewModel.cs | `src/Identity.API/Quickstart/Consent/ScopeViewModel.cs` | 各スコープの表示情報（Value、DisplayName、Required、Checked等） |
| 1-4 | ConsentOptions.cs | `src/Identity.API/Quickstart/Consent/ConsentOptions.cs` | オフラインアクセスやエラーメッセージの設定 |

**読解のコツ**: ConsentViewModelはConsentInputModelを継承しており、GET/POST両方で同じモデルを使用できる構造になっている。ScopeViewModelのRequired属性がtrueのスコープは必須であり、ユーザーは解除できない。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConsentController.cs | `src/Identity.API/Quickstart/Consent/ConsentController.cs` | Index GET（行32-42）とPOST（行47-77）の処理フローを確認 |

**主要処理フロー（GET）**:
1. **行32-33**: HttpGet属性でGETリクエストを受け付け、returnUrlを受け取る
2. **行35**: BuildViewModelAsync(returnUrl)でViewModelを構築
3. **行36-38**: ViewModelがnullでなければViewを返却
4. **行41**: nullの場合はErrorビューを表示

**主要処理フロー（POST）**:
1. **行47-49**: HttpPost属性でPOSTリクエストを受け付け、ConsentInputModelを受け取る
2. **行51**: ProcessConsent(model)で同意処理を実行
3. **行53-63**: リダイレクトが必要な場合の処理（ネイティブクライアント判定含む）
4. **行66-68**: バリデーションエラーがある場合はModelStateにエラー追加
5. **行70-73**: ビュー再表示が必要な場合

#### Step 3: 同意処理ロジックを理解する

ProcessConsentメソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ConsentController.cs | `src/Identity.API/Quickstart/Consent/ConsentController.cs` | ProcessConsent（行82-148）の処理フローを確認 |

**主要処理フロー**:
- **行87-88**: GetAuthorizationContextAsyncでリクエストコンテキストを取得
- **行93-99**: button="no"の場合、AccessDeniedレスポンスを作成しイベント発行
- **行101-121**: button="yes"の場合、スコープ検証と同意レスポンス作成
- **行132-139**: 同意結果をIdentityServerに通知（GrantConsentAsync）

#### Step 4: ビュー表示を理解する

Razorビューでのデータ表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Index.cshtml | `src/Identity.API/Views/Consent/Index.cshtml` | ViewModelのプロパティに基づくフォーム表示を確認 |

**主要処理フロー**:
- **行1**: @model ConsentViewModelでViewModelを受け取る
- **行5-8**: クライアントロゴの条件付き表示
- **行9-12**: クライアント名とメッセージ表示
- **行26-42**: IdentityScopes一覧の表示（_ScopeListItemパーシャル使用）
- **行44-60**: ApiScopes一覧の表示
- **行62-72**: Description入力フィールド
- **行74-84**: RememberConsent チェックボックス（AllowRememberConsent時のみ）
- **行90-91**: Yes/Noボタン

### プログラム呼び出し階層図

```
HTTP GET /Consent?returnUrl=xxx
    │
    ▼
ConsentController.Index(GET)
    │
    ├─ BuildViewModelAsync(returnUrl)
    │      │
    │      ├─ IIdentityServerInteractionService.GetAuthorizationContextAsync(returnUrl)
    │      │      └─ AuthorizationRequest（クライアント情報、スコープ情報）
    │      │
    │      └─ CreateConsentViewModel()
    │             ├─ IdentityScopes生成
    │             └─ ApiScopes生成
    │
    └─ View("Index", ConsentViewModel)
           └─ Index.cshtml

HTTP POST /Consent
    │
    ▼
ConsentController.Index(POST)
    │
    ├─ ProcessConsent(ConsentInputModel)
    │      │
    │      ├─ GetAuthorizationContextAsync(returnUrl)
    │      │
    │      ├─ [button="no"] ConsentDeniedEvent発行
    │      │
    │      ├─ [button="yes"]
    │      │      ├─ ConsentResponse作成
    │      │      ├─ ConsentGrantedEvent発行
    │      │      └─ GrantConsentAsync()
    │      │
    │      └─ ProcessConsentResult
    │
    └─ Redirect(returnUrl) or View("Index", ViewModel)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

returnUrl ───────────────▶ GetAuthorizationContextAsync ───────▶ AuthorizationRequest
                                    │
                                    ▼
                         BuildViewModelAsync / CreateConsentViewModel
                                    │
                                    ▼
                         ConsentViewModel
                         - ClientName/Url/LogoUrl
                         - IdentityScopes[]
                         - ApiScopes[]
                         - AllowRememberConsent
                                    │
                                    ▼
                         Index.cshtml ───────────────────────▶ HTML出力
                                                                   │
                                                                   ▼
                                                         ユーザー選択（Yes/No）
                                                                   │
                                                                   ▼
ConsentInputModel ◀────────────────────────────────────────────────┘
- Button
- ScopesConsented
- RememberConsent
- Description
        │
        ▼
ProcessConsent()
        │
        ├─▶ [Yes] GrantConsentAsync() ───▶ PersistedGrants保存
        │                                        │
        │                                        ▼
        │                              Redirect(returnUrl)
        │
        └─▶ [No] AccessDenied ───────▶ Redirect(returnUrl + error)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Index.cshtml | `src/Identity.API/Views/Consent/Index.cshtml` | ビュー | 同意画面のRazorテンプレート |
| _ScopeListItem.cshtml | `src/Identity.API/Views/Consent/_ScopeListItem.cshtml` | パーシャルビュー | スコープ項目のテンプレート |
| _ValidationSummary.cshtml | `src/Identity.API/Views/Shared/_ValidationSummary.cshtml` | パーシャルビュー | バリデーションエラー表示 |
| ConsentController.cs | `src/Identity.API/Quickstart/Consent/ConsentController.cs` | コントローラー | 同意処理のエントリーポイント |
| ConsentViewModel.cs | `src/Identity.API/Quickstart/Consent/ConsentViewModel.cs` | ViewModel | 画面表示用データモデル |
| ConsentInputModel.cs | `src/Identity.API/Quickstart/Consent/ConsentInputModel.cs` | InputModel | フォーム送信データモデル |
| ScopeViewModel.cs | `src/Identity.API/Quickstart/Consent/ScopeViewModel.cs` | ViewModel | スコープ情報モデル |
| ConsentOptions.cs | `src/Identity.API/Quickstart/Consent/ConsentOptions.cs` | 設定 | 同意オプション設定 |
| ProcessConsentResult.cs | `src/Identity.API/Quickstart/Consent/ProcessConsentResult.cs` | モデル | 同意処理結果 |
