# 画面設計書 15-権限管理画面

## 概要

本ドキュメントは、Identity.APIの権限管理画面（Grants/Index）の画面設計書である。この画面はユーザーがクライアントアプリケーションに付与した権限（Grant）の一覧を確認し、不要な権限を取り消すための管理画面である。

### 本画面の処理概要

権限管理画面は、OAuth2.0/OpenID Connect認証フローにおいてユーザーが同意した権限付与（Grant）の一覧を表示し、個別に取り消し（Revoke）できる機能を提供する。

**業務上の目的・背景**：ユーザーは過去に複数のクライアントアプリケーションへ権限を付与している可能性がある。プライバシーやセキュリティの観点から、ユーザーが自身の権限付与状況を把握し、不要になった権限を取り消せることが重要である。GDPRなどのデータ保護規制にも対応し、ユーザーが自身のデータアクセス権限をコントロールできるようにする。

**画面へのアクセス方法**：Identity.APIの`/grants`にアクセスすることで表示される。ホーム画面（開発環境のみ）からのリンク、または直接URLアクセスが可能。認証が必須であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. 付与済み権限の一覧表示（クライアントアプリケーションごと）
2. 各権限の詳細表示（作成日、有効期限、Identity Grant、API Grant）
3. 「Revoke Access」ボタンによる権限取り消し

**画面遷移**：
- 遷移元：ホーム画面（/）からのリンク
- 遷移先：権限取り消し後は同画面にリダイレクト

**権限による表示制御**：Authorize属性により認証必須。ログイン済みユーザーのみがアクセス可能で、ユーザー自身の権限付与情報のみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | 付与済み権限の一覧表示 |
| 34 | サインイン処理 | 主機能 | 権限取り消し処理 |

## 画面種別

一覧/管理（権限管理）

## URL/ルーティング

- URL: `/Grants` または `/Grants/Index`
- Controller: `GrantsController`
- Action: `Index` (GET)、`Revoke` (POST)

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| クライアントID | clientId | string | 入力 | ○ | Revoke時のhidden項目 |

### 出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| Grant一覧 | Grants | IEnumerable<GrantViewModel> | 出力 | ○ | 付与済み権限一覧 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Client Application Permissions" |
| 説明文 | pテキスト | "Below is the list of applications you have given permission to and the resources they have access to." |
| 空一覧メッセージ | alertボックス | "You have not given access to any applications" |
| クライアントロゴ | img | ClientLogoUrl設定時のみ表示 |
| クライアント名 | strongテキスト | ClientName |
| Revoke Accessボタン | ボタン | 各クライアントに対して表示 |
| Description | labelテキスト | 説明（設定時のみ表示） |
| Created | labelテキスト | 作成日（yyyy-MM-dd形式） |
| Expires | labelテキスト | 有効期限（設定時のみ表示） |
| Identity Grants | リスト | 付与されたIdentityスコープ一覧 |
| API Grants | リスト | 付与されたAPIスコープ一覧 |

## イベント仕様

### 1-Revoke Accessボタン押下

ユーザーが「Revoke Access」ボタンを押下すると、該当クライアントへの権限付与が取り消される。

**処理フロー**:
1. GrantsController.Revoke(POST)が呼び出される
2. clientIdがリクエストパラメータとして送信される
3. IIdentityServerInteractionService.RevokeUserConsentAsync(clientId)を呼び出し
4. GrantsRevokedEventを発行
5. Index画面へリダイレクト（権限一覧が更新される）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 権限一覧表示 | PersistedGrants | SELECT | ユーザーの付与済み権限を取得 |
| Revoke Access押下 | PersistedGrants | DELETE | 該当クライアントの権限を削除 |

### テーブル別更新項目詳細

#### PersistedGrants（IdentityServer管理）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | SubjectId | User.GetSubjectId()と一致 | ユーザーの権限のみ取得 |
| DELETE | SubjectId | User.GetSubjectId()と一致 | ユーザーの権限のみ削除 |
| DELETE | ClientId | リクエストパラメータと一致 | 指定クライアントの権限のみ削除 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Client Application Permissions" | 常時表示（タイトル） |
| MSG-002 | "Below is the list of applications you have given permission to and the resources they have access to." | 常時表示（説明） |
| MSG-003 | "You have not given access to any applications" | 権限なしの場合 |
| MSG-004 | "Identity Grants" | IdentityGrantNamesが存在する場合 |
| MSG-005 | "API Grants" | ApiGrantNamesが存在する場合 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| 権限付与なし | 情報メッセージを表示（エラーではない） |
| クライアント情報取得失敗 | 該当Grantをスキップ（リストに表示しない） |

## 備考

- 権限取り消し後、該当クライアントアプリケーションは再度同意を求める必要がある
- GrantsRevokedEventはイベントログや監査ログに記録される
- Description項目は同意時にユーザーが入力した説明文（デバイス名など）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GrantsViewModel.cs | `src/Identity.API/Quickstart/Grants/GrantsViewModel.cs` | GrantsとGrantViewModelの構造を確認 |

**読解のコツ**: GrantsViewModelはGrantViewModelのコレクションを保持するシンプルな構造。GrantViewModelはクライアント情報（ClientId、ClientName等）と権限情報（IdentityGrantNames、ApiGrantNames）を保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GrantsController.cs | `src/Identity.API/Quickstart/Grants/GrantsController.cs` | Index GET（行32-36）とRevoke POST（行41-49）の処理フローを確認 |

**主要処理フロー（Index GET）**:
1. **行32-33**: HttpGet属性でGETリクエストを受け付け
2. **行35**: BuildViewModelAsync()でViewModelを構築
3. **行35**: View("Index", vm)を返却

**主要処理フロー（Revoke POST）**:
1. **行41-43**: HttpPost属性でPOSTリクエストを受け付け、clientIdを受け取る
2. **行45**: RevokeUserConsentAsync(clientId)で権限を取り消し
3. **行46**: GrantsRevokedEventを発行
4. **行48**: Index画面へリダイレクト

#### Step 3: ViewModel構築ロジックを理解する

BuildViewModelAsyncメソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GrantsController.cs | `src/Identity.API/Quickstart/Grants/GrantsController.cs` | BuildViewModelAsync（行51-84）の処理フローを確認 |

**主要処理フロー**:
- **行53**: GetAllUserGrantsAsync()でユーザーの全権限を取得
- **行55-77**: 各Grantに対してクライアント情報とリソース情報を取得
- **行58-59**: FindClientByIdAsyncでクライアント情報を取得
- **行61**: FindResourcesByScopeAsyncでスコープに対応するリソース情報を取得
- **行63-74**: GrantViewModelを構築（クライアント情報、作成日、有効期限、権限一覧）
- **行80-83**: GrantsViewModelを返却

#### Step 4: ビュー表示を理解する

Razorビューでのデータ表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Index.cshtml | `src/Identity.API/Views/Grants/Index.cshtml` | ViewModelのプロパティに基づく一覧表示を確認 |

**主要処理フロー**:
- **行1**: @model GrantsViewModelでViewModelを受け取る
- **行9-18**: 権限なしの場合のメッセージ表示
- **行21-86**: 各Grantに対するカード表示（foreach）
- **行35-39**: Revoke Accessフォーム
- **行44-49**: Description表示（条件付き）
- **行50-52**: Created日付表示
- **行53-58**: Expires日付表示（条件付き）
- **行59-70**: Identity Grants一覧表示
- **行71-82**: API Grants一覧表示

### プログラム呼び出し階層図

```
HTTP GET /Grants
    │
    ▼
GrantsController.Index(GET)
    │
    └─ BuildViewModelAsync()
           │
           ├─ IIdentityServerInteractionService.GetAllUserGrantsAsync()
           │      └─ IEnumerable<Grant>（ユーザーの全権限）
           │
           ├─ IClientStore.FindClientByIdAsync(clientId)
           │      └─ Client（クライアント情報）
           │
           ├─ IResourceStore.FindResourcesByScopeAsync(scopes)
           │      └─ Resources（リソース情報）
           │
           └─ GrantsViewModel構築
                  └─ View("Index", GrantsViewModel)

HTTP POST /Grants/Revoke
    │
    ▼
GrantsController.Revoke(POST)
    │
    ├─ IIdentityServerInteractionService.RevokeUserConsentAsync(clientId)
    │      └─ PersistedGrants DELETE
    │
    ├─ IEventService.RaiseAsync(GrantsRevokedEvent)
    │      └─ イベント発行
    │
    └─ RedirectToAction("Index")
```

### データフロー図

```
[入力]                         [処理]                              [出力]

HTTP GET /Grants ────────▶ GetAllUserGrantsAsync()
                                    │
                                    ▼
                            IEnumerable<Grant>
                                    │
                     ┌──────────────┼──────────────┐
                     ▼              ▼              ▼
              Grant1           Grant2          Grant N
                     │              │              │
                     ▼              ▼              ▼
              FindClientByIdAsync  ...           ...
                     │
                     ▼
              Client情報
                     │
                     ▼
              FindResourcesByScopeAsync
                     │
                     ▼
              Resources情報
                     │
                     ▼
              GrantViewModel構築
                     │
                     ▼
              GrantsViewModel
                     │
                     ▼
              Index.cshtml ───────────────────────▶ HTML出力
                                                        │
                                                        ▼
                                              ユーザー操作（Revoke）
                                                        │
                                                        ▼
clientId ◀──────────────────────────────────────────────┘
    │
    ▼
RevokeUserConsentAsync(clientId)
    │
    ▼
PersistedGrants DELETE
    │
    ▼
RedirectToAction("Index") ──────────────────────▶ 画面更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Index.cshtml | `src/Identity.API/Views/Grants/Index.cshtml` | ビュー | 権限管理画面のRazorテンプレート |
| GrantsController.cs | `src/Identity.API/Quickstart/Grants/GrantsController.cs` | コントローラー | 権限管理のエントリーポイント |
| GrantsViewModel.cs | `src/Identity.API/Quickstart/Grants/GrantsViewModel.cs` | ViewModel | 画面表示用データモデル |
