# 画面設計書 16-診断画面

## 概要

本ドキュメントは、Identity.APIの診断画面（Diagnostics/Index）の画面設計書である。この画面は認証Cookieに含まれるクレーム（Claims）とプロパティ（Properties）を表示するデバッグ・診断用の画面である。

### 本画面の処理概要

診断画面は、現在のユーザーセッションの認証情報を詳細に表示するデバッグ用画面である。認証Cookieに含まれるクレームとプロパティを確認でき、認証関連の問題調査やデバッグに使用される。

**業務上の目的・背景**：OAuth2.0/OpenID Connect認証フローのデバッグやトラブルシューティングにおいて、認証状態を確認する必要がある。本画面は開発者や管理者が現在のセッションのクレーム情報（subject、name、email等）やプロパティ情報（session_id、issued、expires等）を確認するために使用される。また、どのクライアントアプリケーションがセッションを利用しているかも確認できる。

**画面へのアクセス方法**：Identity.APIの`/diagnostics`にアクセスすることで表示される。ホーム画面（開発環境のみ）からのリンク、または直接URLアクセスが可能。認証が必須であり、さらにローカルホストからのアクセスのみ許可される（セキュリティ制限）。

**主要な操作・処理内容**：
1. 認証Cookieのクレーム一覧表示（Type: Value形式）
2. 認証Cookieのプロパティ一覧表示（Key: Value形式）
3. セッションを利用しているクライアント一覧表示

**画面遷移**：
- 遷移元：ホーム画面（/）からのリンク
- 遷移先：特になし（表示専用）

**権限による表示制御**：Authorize属性により認証必須。さらにローカルホスト（127.0.0.1、::1、LocalIpAddress）からのアクセスのみ許可され、外部からのアクセスは404を返す。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | 認証クッキーのクレーム・プロパティ表示 |

## 画面種別

詳細表示（デバッグ/診断）

## URL/ルーティング

- URL: `/Diagnostics` または `/Diagnostics/Index`
- Controller: `DiagnosticsController`
- Action: `Index` (GET)

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| 認証結果 | AuthenticateResult | AuthenticateResult | 出力 | ○ | 認証情報全体 |
| クライアント一覧 | Clients | IEnumerable<string> | 出力 | - | セッション利用クライアント |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Authentication Cookie" |
| クレームセクション | カード | "Claims"ヘッダー |
| クレーム一覧 | dl（定義リスト） | Type: Value形式 |
| プロパティセクション | カード | "Properties"ヘッダー |
| プロパティ一覧 | dl（定義リスト） | Key: Value形式 |
| クライアント一覧 | dl内リスト | "Clients"ラベル |

## イベント仕様

本画面はユーザー操作可能なイベントは存在しない。表示専用の診断画面である。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面は認証Cookieの情報を表示するのみであり、データベースへの操作は行わない。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Authentication Cookie" | 常時表示（タイトル） |
| MSG-002 | "Claims" | 常時表示（セクションヘッダー） |
| MSG-003 | "Properties" | 常時表示（セクションヘッダー） |
| MSG-004 | "Clients" | クライアントが存在する場合 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| 非ローカルホストからのアクセス | 404 NotFoundを返却 |
| 未認証アクセス | ログイン画面へリダイレクト |

## 備考

- セキュリティ上の理由から、ローカルホストからのアクセスのみ許可される
- client_listはBase64Urlエンコードされており、DiagnosticsViewModelでデコードされる
- 本画面は開発・デバッグ目的であり、本番環境での利用は推奨されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiagnosticsViewModel.cs | `src/Identity.API/Quickstart/Diagnostics/DiagnosticsViewModel.cs` | AuthenticateResultとClientsプロパティの構造を確認 |

**読解のコツ**: DiagnosticsViewModelはコンストラクタでAuthenticateResultを受け取り、client_listプロパティをBase64Urlデコードしてクライアント一覧を抽出する。AuthenticateResultにはPrincipal（クレーム情報）とProperties（プロパティ情報）が含まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DiagnosticsController.cs | `src/Identity.API/Quickstart/Diagnostics/DiagnosticsController.cs` | Index GET（行11-21）のアクセス制限とViewModel構築を確認 |

**主要処理フロー**:
1. **行11**: Indexアクションが呼び出される
2. **行13-17**: ローカルホストチェック（127.0.0.1、::1、LocalIpAddress）
3. **行13-14**: ローカルアドレスの配列を作成
4. **行14-17**: RemoteIpAddressがローカルでなければNotFound()を返却
5. **行19**: HttpContext.AuthenticateAsync()で認証情報を取得
6. **行20**: DiagnosticsViewModelを構築してViewを返却

#### Step 3: クライアント一覧のデコードロジックを理解する

DiagnosticsViewModelでのclient_listデコード処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiagnosticsViewModel.cs | `src/Identity.API/Quickstart/Diagnostics/DiagnosticsViewModel.cs` | コンストラクタ（行12-24）のデコードロジックを確認 |

**主要処理フロー**:
- **行14**: AuthenticateResultを保持
- **行16-23**: client_listプロパティが存在する場合のデコード処理
- **行18**: Base64Urlデコード
- **行19**: UTF8文字列に変換
- **行21**: JSONデシリアライズしてstring[]に変換

#### Step 4: ビュー表示を理解する

Razorビューでのデータ表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Index.cshtml | `src/Identity.API/Views/Diagnostics/Index.cshtml` | ViewModelのプロパティに基づくクレーム・プロパティ表示を確認 |

**主要処理フロー**:
- **行1**: @model DiagnosticsViewModelでViewModelを受け取る
- **行14-21**: Principal.Claimsをforeachでイテレートし、Type/Valueを表示
- **行33-53**: Properties.Itemsをforeachでイテレートし、Key/Valueを表示
- **行38-53**: Clientsが存在する場合、クライアント一覧を表示

### プログラム呼び出し階層図

```
HTTP GET /Diagnostics
    │
    ▼
DiagnosticsController.Index(GET)
    │
    ├─ ローカルホストチェック
    │      │
    │      ├─ ローカル: 処理続行
    │      │
    │      └─ 非ローカル: NotFound()
    │
    ├─ HttpContext.AuthenticateAsync()
    │      └─ AuthenticateResult（Principal、Properties）
    │
    └─ DiagnosticsViewModel(AuthenticateResult)
           │
           ├─ AuthenticateResult保持
           │
           └─ client_listデコード
                  ├─ Base64Url.Decode()
                  ├─ UTF8.GetString()
                  └─ JsonSerializer.Deserialize<string[]>()
                         │
                         ▼
                  View("Index", DiagnosticsViewModel)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

HTTP GET /Diagnostics ───▶ ローカルホストチェック
                                    │
                                    ├─▶ [非ローカル] NotFound()
                                    │
                                    └─▶ [ローカル] AuthenticateAsync()
                                                │
                                                ▼
                                        AuthenticateResult
                                        - Principal
                                          - Claims[]
                                        - Properties
                                          - Items[]
                                                │
                                                ▼
                                        DiagnosticsViewModel
                                        - AuthenticateResult
                                        - Clients[]（デコード済み）
                                                │
                                                ▼
                                        Index.cshtml
                                                │
                                                ▼
                                        HTML出力
                                        - クレーム一覧
                                        - プロパティ一覧
                                        - クライアント一覧
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Index.cshtml | `src/Identity.API/Views/Diagnostics/Index.cshtml` | ビュー | 診断画面のRazorテンプレート |
| DiagnosticsController.cs | `src/Identity.API/Quickstart/Diagnostics/DiagnosticsController.cs` | コントローラー | 診断画面のエントリーポイント |
| DiagnosticsViewModel.cs | `src/Identity.API/Quickstart/Diagnostics/DiagnosticsViewModel.cs` | ViewModel | 画面表示用データモデル |
