# 画面設計書 17-デバイスコード入力画面

## 概要

本ドキュメントは、Identity.APIのデバイスコード入力画面（Device/UserCodeCapture）の画面設計書である。この画面はOAuth2.0 Device Authorization Grant（RFC 8628）フローにおいて、ユーザーがデバイスに表示されたユーザーコードを入力するための画面である。

### 本画面の処理概要

デバイスコード入力画面は、テレビやIoTデバイスなどのブラウザを持たない・入力が制限されたデバイスでの認証フロー（デバイスフロー）において、ユーザーがPCやスマートフォンのブラウザからユーザーコードを入力するための画面である。

**業務上の目的・背景**：スマートテレビ、ゲームコンソール、IoTデバイスなど、フルブラウザや標準的な入力インターフェースを持たないデバイスでもOAuth2.0認証を行う必要がある。Device Authorization Grant（デバイスフロー）は、このようなデバイスでの認証を可能にするOAuth2.0の拡張仕様である。ユーザーは制限されたデバイスに表示された短いユーザーコードを、PCやスマートフォンのブラウザで入力することで認証を完了できる。

**画面へのアクセス方法**：Identity.APIの`/device`にアクセスすることで表示される。URLパラメータにuserCodeが含まれていない場合にこの入力画面が表示される。認証が必須であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. ユーザーコード入力フィールドの表示
2. Submitボタンによるコード送信
3. 入力されたコードの検証

**画面遷移**：
- 遷移元：デバイスに表示されたURL（/device）への直接アクセス
- 遷移先（成功時）：デバイス確認画面（UserCodeConfirmation）
- 遷移先（エラー時）：エラー画面

**権限による表示制御**：Authorize属性により認証必須。ログイン済みユーザーのみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 主機能 | デバイスフロー認証用ユーザーコード入力 |

## 画面種別

入力（ユーザーコード入力フォーム）

## URL/ルーティング

- URL: `/Device`（userCodeパラメータなし）
- Controller: `DeviceController`
- Action: `Index` (GET)、`UserCodeCapture` (POST)

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| ユーザーコード | userCode | string | 入力 | ○ | デバイスに表示されたコード |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "User Code" |
| 説明文 | pテキスト | "Please enter the code displayed on your device." |
| バリデーションサマリー | パーシャルビュー | _ValidationSummary |
| ユーザーコードラベル | label | "User Code:" |
| ユーザーコード入力 | テキストボックス | autofocus属性付き |
| 送信ボタン | ボタン | "Submit" |

## イベント仕様

### 1-Submitボタン押下

ユーザーが「Submit」ボタンを押下すると、入力されたユーザーコードが検証され、有効な場合はデバイス確認画面へ遷移する。

**処理フロー**:
1. DeviceController.UserCodeCapture(POST)が呼び出される
2. userCodeがリクエストパラメータとして送信される
3. BuildViewModelAsync(userCode)でコードを検証
4. 有効な場合：UserCodeConfirmationビューを表示
5. 無効な場合：Errorビューを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（入力のみ） |

本画面はユーザーコードの入力のみを行い、データベースへの操作は行わない。コードの検証はIdentityServerのメモリストアまたはデータベースに保存されたデバイス認可リクエストと照合される。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "User Code" | 常時表示（タイトル） |
| MSG-002 | "Please enter the code displayed on your device." | 常時表示（説明） |
| MSG-003 | "User Code:" | 常時表示（ラベル） |
| MSG-004 | "Submit" | 常時表示（ボタン） |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| 無効なユーザーコード | Errorビューを表示 |
| コード有効期限切れ | Errorビューを表示 |

## 備考

- ユーザーコードは通常、短い英数字の組み合わせ（例：BCDF-GHKM）
- デバイスフロー認証は、制限付きデバイスでの認証を可能にするOAuth2.0 Device Authorization Grant（RFC 8628）の実装
- autofocus属性により、ページ読み込み時に自動的に入力フィールドにフォーカスされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面のViewModelはシンプルなstring型である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UserCodeCapture.cshtml | `src/Identity.API/Views/Device/UserCodeCapture.cshtml` | @model stringでユーザーコードを受け取ることを確認 |

**読解のコツ**: 本画面は入力フォームのみであり、ViewModelは使用しない。送信されたuserCodeはPOSTパラメータとして直接受け取る。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | Index GET（行27-39）とUserCodeCapture POST（行41-49）の処理フローを確認 |

**主要処理フロー（Index GET）**:
1. **行27-28**: HttpGet属性でGETリクエストを受け付け
2. **行30**: IdentityServerOptionsからuserCodeパラメータ名を取得
3. **行31**: Request.QueryからuserCodeを取得
4. **行32**: userCodeが空の場合、View("UserCodeCapture")を返却
5. **行34-38**: userCodeがある場合、検証してUserCodeConfirmationビューへ

**主要処理フロー（UserCodeCapture POST）**:
1. **行41-43**: HttpPost属性でPOSTリクエストを受け付け、userCodeを受け取る
2. **行45**: BuildViewModelAsync(userCode)でコードを検証
3. **行46**: 無効な場合、View("Error")を返却
4. **行48**: 有効な場合、View("UserCodeConfirmation", vm)を返却

#### Step 3: ビュー表示を理解する

Razorビューでの入力フォーム表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UserCodeCapture.cshtml | `src/Identity.API/Views/Device/UserCodeCapture.cshtml` | 入力フォームの構造を確認 |

**主要処理フロー**:
- **行1**: @model stringでモデル型を定義
- **行5-6**: タイトルと説明文を表示
- **行9**: _ValidationSummaryパーシャルを表示
- **行13**: asp-action="UserCodeCapture"でPOSTアクションを指定
- **行14-16**: userCode入力フィールド（autofocus付き）
- **行19**: Submitボタン

### プログラム呼び出し階層図

```
HTTP GET /Device
    │
    ▼
DeviceController.Index(GET)
    │
    ├─ userCodeパラメータ確認
    │      │
    │      ├─ [空] View("UserCodeCapture")
    │      │          │
    │      │          ▼
    │      │     UserCodeCapture.cshtml
    │      │
    │      └─ [あり] BuildViewModelAsync(userCode)
    │                    │
    │                    └─ View("UserCodeConfirmation")

HTTP POST /Device/UserCodeCapture
    │
    ▼
DeviceController.UserCodeCapture(POST)
    │
    ├─ BuildViewModelAsync(userCode)
    │      │
    │      ├─ IDeviceFlowInteractionService.GetAuthorizationContextAsync(userCode)
    │      │      │
    │      │      └─ DeviceFlowAuthorizationRequest（またはnull）
    │      │
    │      └─ [null] null返却
    │         [有効] DeviceAuthorizationViewModel返却
    │
    ├─ [vm == null] View("Error")
    │
    └─ [vm != null] View("UserCodeConfirmation", vm)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

HTTP GET /Device ────────▶ userCodeパラメータ確認
                                    │
                                    ├─▶ [空] UserCodeCapture.cshtml
                                    │
                                    └─▶ [あり] BuildViewModelAsync()

ユーザー入力
    │
    ▼
userCode ───────────────▶ UserCodeCapture(POST)
                                    │
                                    ▼
                         GetAuthorizationContextAsync(userCode)
                                    │
                         ┌──────────┴──────────┐
                         ▼                      ▼
                    [無効]                  [有効]
                         │                      │
                         ▼                      ▼
                    Error.cshtml          UserCodeConfirmation.cshtml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UserCodeCapture.cshtml | `src/Identity.API/Views/Device/UserCodeCapture.cshtml` | ビュー | ユーザーコード入力画面のRazorテンプレート |
| DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | コントローラー | デバイスフロー処理のエントリーポイント |
| _ValidationSummary.cshtml | `src/Identity.API/Views/Shared/_ValidationSummary.cshtml` | パーシャルビュー | バリデーションエラー表示 |
