# 画面設計書 18-デバイス確認画面

## 概要

本ドキュメントは、Identity.APIのデバイス確認画面（Device/UserCodeConfirmation）の画面設計書である。この画面はOAuth2.0 Device Authorization Grant（RFC 8628）フローにおいて、ユーザーがデバイスへの権限付与を確認・承認するための画面である。

### 本画面の処理概要

デバイス確認画面は、デバイスフロー認証においてユーザーコードが検証された後に表示される権限確認画面である。同意画面（Consent）と同様の機能を提供するが、デバイスフロー特有のユーザーコード確認機能を含む。

**業務上の目的・背景**：Device Authorization Grant（デバイスフロー）において、ユーザーがPCやスマートフォンのブラウザでユーザーコードを入力した後、そのコードに対応するクライアントアプリケーションへの権限付与を確認する必要がある。本画面はユーザーコードの正当性を確認させつつ、要求されたスコープ（権限）の許可/拒否を選択させる。

**画面へのアクセス方法**：デバイスコード入力画面からの遷移、またはURLパラメータにuserCodeを含む`/device`への直接アクセスで表示される。認証が必須であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. クライアントアプリケーション情報の表示（名前、ロゴ、URL）
2. ユーザーコードの確認表示（ConfirmUserCode=true時）
3. 要求されたIdentity Scopes（Personal Information）の一覧表示
4. 要求されたAPI Scopes（Application Access）の一覧表示
5. 各スコープのチェックボックスによる選択/解除
6. デバイス説明の入力（オプション）
7. 「Remember My Decision」チェックボックスで同意の記憶
8. 「Yes, Allow」ボタンで許可、「No, Do Not Allow」ボタンで拒否

**画面遷移**：
- 遷移元：デバイスコード入力画面（UserCodeCapture）
- 遷移先（許可時）：デバイス認証成功画面（Success）
- 遷移先（拒否/エラー時）：エラー画面

**権限による表示制御**：Authorize属性により認証必須。ログイン済みユーザーのみがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 主機能 | デバイスフロー認証の権限確認 |
| 34 | サインイン処理 | 補助機能 | デバイス認証同意後の処理 |

## 画面種別

確認/入力（デバイスフロー権限同意フォーム）

## URL/ルーティング

- URL: `/Device?user_code={code}` または POST `/Device/Callback`
- Controller: `DeviceController`
- Action: `Index` (GET - userCode付き)、`Callback` (POST)

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| ユーザーコード | UserCode | string | 入力 | ○ | hidden項目 |
| 同意スコープ | ScopesConsented | IEnumerable<string> | 入力 | △ | 許可時は1つ以上必須 |
| 同意を記憶 | RememberConsent | bool | 入力 | - | デフォルトtrue |
| デバイス説明 | Description | string | 入力 | - | 任意入力 |
| ボタン選択 | Button | string | 入力 | ○ | "yes" または "no" |

### 出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| ユーザーコード | UserCode | string | 出力 | ○ | 確認表示用 |
| コード確認フラグ | ConfirmUserCode | bool | 出力 | ○ | コード確認表示の有無 |
| クライアント名 | ClientName | string | 出力 | ○ | アプリケーション名 |
| クライアントURL | ClientUrl | string | 出力 | - | アプリケーションURL |
| クライアントロゴURL | ClientLogoUrl | string | 出力 | - | アプリケーションロゴ |
| 同意記憶許可 | AllowRememberConsent | bool | 出力 | ○ | 同意記憶の可否 |
| Identity Scopes | IdentityScopes | IEnumerable<ScopeViewModel> | 出力 | - | 個人情報スコープ一覧 |
| API Scopes | ApiScopes | IEnumerable<ScopeViewModel> | 出力 | - | APIアクセススコープ一覧 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| クライアントロゴ | img | ClientLogoUrl設定時のみ表示 |
| クライアント名 | h1テキスト | "{ClientName} is requesting your permission" |
| ユーザーコード確認 | strongテキスト | ConfirmUserCode=true時のみ表示 |
| 説明文 | pテキスト | "Uncheck the permissions you do not wish to grant." |
| Identity Scopes一覧 | カード/チェックボックス | "Personal Information"セクション |
| API Scopes一覧 | カード/チェックボックス | "Application Access"セクション |
| デバイス説明入力 | テキストボックス | "Description or name of device" |
| 同意記憶チェック | チェックボックス | "Remember My Decision" |
| 許可ボタン | ボタン | "Yes, Allow" |
| 拒否ボタン | ボタン | "No, Do Not Allow" |
| クライアント情報リンク | ボタン | ClientUrl設定時のみ表示 |

## イベント仕様

### 1-許可ボタン押下（Yes, Allow）

ユーザーが「Yes, Allow」ボタンを押下すると、選択されたスコープの同意情報がIdentityServerに記録され、デバイス認証成功画面へ遷移する。

**処理フロー**:
1. DeviceController.Callback(POST)が呼び出される
2. ProcessConsent()で同意内容を処理
3. ScopesConsentedが空でないことを検証
4. ConsentResponseを作成し、IDeviceFlowInteractionService.HandleRequestAsync()を呼び出す
5. ConsentGrantedEventを発行
6. View("Success")を返却

### 2-拒否ボタン押下（No, Do Not Allow）

ユーザーが「No, Do Not Allow」ボタンを押下すると、アクセス拒否レスポンスがデバイスに返却される。

**処理フロー**:
1. DeviceController.Callback(POST)が呼び出される
2. ProcessConsent()でbutton="no"を検出
3. ConsentResponse { Error = AuthorizationError.AccessDenied }を作成
4. ConsentDeniedEventを発行
5. View("Error")を返却（バリデーションエラー時）またはView("Success")

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 許可ボタン押下 | DeviceCodes | UPDATE | デバイスコードのステータスを更新 |
| 許可ボタン押下（RememberConsent=true） | PersistedGrants | INSERT | 同意情報を永続化 |

### テーブル別更新項目詳細

#### DeviceCodes（IdentityServer管理）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | UserCode | 入力されたUserCode | 検索条件 |
| UPDATE | Subject | User.GetSubjectId() | 認証ユーザーを設定 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "{ClientName} is requesting your permission" | 常時表示 |
| MSG-002 | "Please confirm that the authorization request quotes the code: {UserCode}." | ConfirmUserCode=true時 |
| MSG-003 | "Uncheck the permissions you do not wish to grant." | 常時表示 |
| MSG-004 | "Personal Information" | IdentityScopes存在時 |
| MSG-005 | "Application Access" | ApiScopes存在時 |
| MSG-006 | "Remember My Decision" | AllowRememberConsent=true時 |
| ERR-001 | "You must pick at least one permission" | 許可時にスコープ未選択 |
| ERR-002 | "Invalid selection" | 不正なボタン選択 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| 無効なユーザーコード | Errorビューを表示 |
| コード有効期限切れ | Errorビューを表示 |
| スコープ未選択で許可 | バリデーションエラー |

## 備考

- DeviceAuthorizationViewModelはConsentViewModelを継承しており、UserCodeとConfirmUserCodeプロパティが追加されている
- 同意画面（Consent）との違いは、returnUrlではなくUserCodeを使用する点とデバイスフロー専用のIDeviceFlowInteractionServiceを使用する点
- ConfirmUserCodeがtrueの場合、ユーザーコードの確認メッセージが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeviceAuthorizationViewModel.cs | `src/Identity.API/Quickstart/Device/DeviceAuthorizationViewModel.cs` | ConsentViewModelを継承し、UserCodeとConfirmUserCodeが追加されていることを確認 |
| 1-2 | ConsentViewModel.cs | `src/Identity.API/Quickstart/Consent/ConsentViewModel.cs` | 基底クラスのプロパティ（ClientName、IdentityScopes等）を確認 |
| 1-3 | DeviceAuthorizationInputModel.cs | `src/Identity.API/Quickstart/Device/DeviceAuthorizationInputModel.cs` | フォーム送信データの構造を確認 |

**読解のコツ**: DeviceAuthorizationViewModelはConsentViewModelを継承しており、同意画面と同様の構造にUserCode関連のプロパティが追加されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | Index GET（行27-39）とCallback POST（行51-61）の処理フローを確認 |

**主要処理フロー（Index GET - userCode付き）**:
1. **行30-31**: IdentityServerOptionsからuserCodeパラメータ名を取得し、Request.Queryから取得
2. **行34**: BuildViewModelAsync(userCode)でViewModelを構築
3. **行35**: 無効な場合、View("Error")を返却
4. **行37**: ConfirmUserCode = trueを設定
5. **行38**: View("UserCodeConfirmation", vm)を返却

**主要処理フロー（Callback POST）**:
1. **行51-53**: HttpPost属性でPOSTリクエストを受け付け、DeviceAuthorizationInputModelを受け取る
2. **行57**: ProcessConsent(model)で同意処理を実行
3. **行58**: バリデーションエラーがある場合、View("Error")を返却
4. **行60**: View("Success")を返却

#### Step 3: 同意処理ロジックを理解する

ProcessConsentメソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | ProcessConsent（行63-128）の処理フローを確認 |

**主要処理フロー**:
- **行67-68**: GetAuthorizationContextAsync(userCode)でリクエストコンテキストを取得
- **行73-79**: button="no"の場合、AccessDeniedレスポンスを作成しイベント発行
- **行81-106**: button="yes"の場合、スコープ検証と同意レスポンス作成
- **行113-115**: HandleRequestAsync(userCode, grantedConsent)で結果をIdentityServerに通知

#### Step 4: ビュー表示を理解する

Razorビューでのデータ表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | UserCodeConfirmation.cshtml | `src/Identity.API/Views/Device/UserCodeConfirmation.cshtml` | ViewModelのプロパティに基づくフォーム表示を確認 |

**主要処理フロー**:
- **行1**: @model DeviceAuthorizationViewModelでViewModelを受け取る
- **行5-8**: クライアントロゴの条件付き表示
- **行13-16**: ConfirmUserCode=trueの場合、ユーザーコード確認メッセージを表示
- **行26**: asp-action="Callback"でPOSTアクションを指定
- **行27**: UserCodeをhiddenフィールドで保持
- **行30-46**: IdentityScopes一覧の表示
- **行48-64**: ApiScopes一覧の表示

### プログラム呼び出し階層図

```
HTTP GET /Device?user_code=xxx
    │
    ▼
DeviceController.Index(GET)
    │
    ├─ userCodeパラメータ取得
    │
    ├─ BuildViewModelAsync(userCode)
    │      │
    │      └─ IDeviceFlowInteractionService.GetAuthorizationContextAsync(userCode)
    │             │
    │             └─ DeviceFlowAuthorizationRequest（またはnull）
    │
    ├─ [null] View("Error")
    │
    └─ [有効] vm.ConfirmUserCode = true
                │
                └─ View("UserCodeConfirmation", vm)

HTTP POST /Device/Callback
    │
    ▼
DeviceController.Callback(POST)
    │
    ├─ ProcessConsent(DeviceAuthorizationInputModel)
    │      │
    │      ├─ GetAuthorizationContextAsync(userCode)
    │      │
    │      ├─ [button="no"] ConsentDeniedEvent発行
    │      │
    │      ├─ [button="yes"]
    │      │      ├─ ConsentResponse作成
    │      │      ├─ ConsentGrantedEvent発行
    │      │      └─ HandleRequestAsync(userCode, grantedConsent)
    │      │
    │      └─ ProcessConsentResult
    │
    ├─ [HasValidationError] View("Error")
    │
    └─ [成功] View("Success")
```

### データフロー図

```
[入力]                         [処理]                              [出力]

userCode ─────────────────▶ GetAuthorizationContextAsync ───────▶ DeviceFlowAuthorizationRequest
                                    │
                                    ▼
                         BuildViewModelAsync / CreateConsentViewModel
                                    │
                                    ▼
                         DeviceAuthorizationViewModel
                         - UserCode
                         - ConfirmUserCode
                         - ClientName/Url/LogoUrl
                         - IdentityScopes[]
                         - ApiScopes[]
                                    │
                                    ▼
                         UserCodeConfirmation.cshtml ─────────▶ HTML出力
                                                                   │
                                                                   ▼
                                                         ユーザー選択（Yes/No）
                                                                   │
                                                                   ▼
DeviceAuthorizationInputModel ◀────────────────────────────────────┘
- UserCode
- Button
- ScopesConsented
- RememberConsent
- Description
        │
        ▼
ProcessConsent()
        │
        ├─▶ [Yes] HandleRequestAsync() ───▶ DeviceCodes更新
        │                                        │
        │                                        ▼
        │                                  View("Success")
        │
        └─▶ [No] AccessDenied ───────────▶ View("Error") or View("Success")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UserCodeConfirmation.cshtml | `src/Identity.API/Views/Device/UserCodeConfirmation.cshtml` | ビュー | デバイス確認画面のRazorテンプレート |
| Success.cshtml | `src/Identity.API/Views/Device/Success.cshtml` | ビュー | 認証成功画面のRazorテンプレート |
| DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | コントローラー | デバイスフロー処理のエントリーポイント |
| DeviceAuthorizationViewModel.cs | `src/Identity.API/Quickstart/Device/DeviceAuthorizationViewModel.cs` | ViewModel | 画面表示用データモデル |
| DeviceAuthorizationInputModel.cs | `src/Identity.API/Quickstart/Device/DeviceAuthorizationInputModel.cs` | InputModel | フォーム送信データモデル |
| _ScopeListItem.cshtml | `src/Identity.API/Views/Consent/_ScopeListItem.cshtml` | パーシャルビュー | スコープ項目のテンプレート |
