# 画面設計書 19-デバイス認証成功画面

## 概要

本ドキュメントは、Identity.APIのデバイス認証成功画面（Device/Success）の画面設計書である。この画面はOAuth2.0 Device Authorization Grant（RFC 8628）フローにおいて、デバイスへの認証が正常に完了したことをユーザーに通知するための画面である。

### 本画面の処理概要

デバイス認証成功画面は、デバイスフロー認証においてユーザーがデバイスへの権限付与を承認した後に表示される完了メッセージ画面である。

**業務上の目的・背景**：Device Authorization Grant（デバイスフロー）において、ユーザーがブラウザでの認証・認可処理を完了した後、その結果をユーザーに明確に伝える必要がある。本画面はデバイス認証が成功したことをユーザーに通知し、ユーザーがブラウザを閉じてデバイス側で操作を続行できることを示す。デバイス側では、この時点で認証トークンを取得でき、アプリケーションが利用可能になる。

**画面へのアクセス方法**：デバイス確認画面（UserCodeConfirmation）で「Yes, Allow」ボタンを押下した後に遷移する。直接URLアクセスはできない（Callback POSTの結果としてのみ表示）。

**主要な操作・処理内容**：
1. 成功メッセージの表示（"Success"）
2. デバイス認証完了の説明表示（"You have successfully authorized the device"）

**画面遷移**：
- 遷移元：デバイス確認画面（UserCodeConfirmation）- 許可時
- 遷移先：特になし（ユーザーはブラウザを閉じてデバイスで操作を継続）

**権限による表示制御**：Callback POSTの結果として表示されるため、認証済みユーザーのコンテキストで表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | デバイス認証成功メッセージ表示 |

## 画面種別

メッセージ表示（認証成功確認）

## URL/ルーティング

- URL: POST `/Device/Callback` の結果として表示
- Controller: `DeviceController`
- Action: `Callback` (POST) -> View("Success")

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| - | - | - | - | - | 本画面はViewModelを使用しない静的表示 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Success" |
| 説明メッセージ | pテキスト | "You have successfully authorized the device" |

## イベント仕様

本画面にはユーザー操作可能なイベントは存在しない。表示専用の完了メッセージ画面である。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面は静的な成功メッセージを表示するのみであり、データベースへの操作は行わない。データベースへの更新はCallback処理（デバイス確認画面での許可ボタン押下時）で既に完了している。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Success" | 常時表示（タイトル） |
| MSG-002 | "You have successfully authorized the device" | 常時表示（説明） |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| - | 本画面自体が成功結果画面であり、例外処理は特になし |

## 備考

- 本画面はViewModelを使用せず、静的なHTMLコンテンツを表示するシンプルな構造
- デバイス側では、ポーリングにより認証完了を検知し、アクセストークンを取得可能になる
- ユーザーはこの画面を確認後、ブラウザを閉じてデバイス側で操作を継続できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はViewModelを使用しないシンプルな構造であるため、データ構造の理解は不要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| - | - | - | ViewModelなし（静的HTML） |

**読解のコツ**: 本画面は静的な成功メッセージを表示するのみで、動的なデータバインディングは行われない。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | Callback POST（行51-61）の処理フローを確認 |

**主要処理フロー**:
1. **行51-53**: HttpPost属性でPOSTリクエストを受け付け
2. **行57**: ProcessConsent(model)で同意処理を実行
3. **行58**: バリデーションエラーがある場合、View("Error")を返却
4. **行60**: エラーがなければView("Success")を返却

#### Step 3: ビュー表示を理解する

Razorビューでの静的表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Success.cshtml | `src/Identity.API/Views/Device/Success.cshtml` | シンプルな静的HTML構造を確認 |

**主要処理フロー**:
- **行2**: div.page-device-successでコンテナを定義
- **行3-4**: div.leadクラスでリードスタイルを適用
- **行4**: h1で"Success"タイトルを表示
- **行5**: pで説明メッセージを表示

### プログラム呼び出し階層図

```
HTTP POST /Device/Callback（許可ボタン押下後）
    │
    ▼
DeviceController.Callback(POST)
    │
    ├─ ProcessConsent(DeviceAuthorizationInputModel)
    │      │
    │      └─ [成功] ProcessConsentResult { HasValidationError = false }
    │
    └─ View("Success")
           │
           ▼
       Success.cshtml
           │
           └─ 静的HTML出力
                  ├─ "Success"
                  └─ "You have successfully authorized the device"
```

### データフロー図

```
[入力]                         [処理]                              [出力]

DeviceAuthorizationInputModel
（許可選択）
    │
    ▼
ProcessConsent()
    │
    ├─ HandleRequestAsync()
    │      └─ デバイスコード承認
    │
    └─ ProcessConsentResult
           │
           ▼
    [HasValidationError = false]
           │
           ▼
    View("Success")
           │
           ▼
    Success.cshtml
           │
           ▼
    静的HTMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Success.cshtml | `src/Identity.API/Views/Device/Success.cshtml` | ビュー | デバイス認証成功画面のRazorテンプレート |
| DeviceController.cs | `src/Identity.API/Quickstart/Device/DeviceController.cs` | コントローラー | デバイスフロー処理のエントリーポイント |
