# 画面設計書 2-商品詳細画面

## 概要

本ドキュメントは、eShop WebAppの商品詳細画面の設計仕様を定義する。個別商品の詳細情報（商品名、価格、説明、ブランド情報）を表示し、ショッピングカートへの追加機能を提供する画面である。

### 本画面の処理概要

商品詳細画面は、カタログ画面から選択された商品の詳細情報を表示し、購入検討からカート追加までの導線を提供する重要な画面である。

**業務上の目的・背景**：ECサイトにおいて、顧客が商品の詳細を確認し購入を決定するための情報提供画面である。商品の説明、価格、ブランド情報を詳しく表示することで、顧客の購買意思決定を支援する。また、ログイン状態に応じたカート追加機能により、スムーズな購入フローを実現する。

**画面へのアクセス方法**：カタログ画面の商品カードをクリックするか、直接URL（/item/{itemId}）にアクセスする。認証は不要だが、カートへの追加にはログインが必要である。

**主要な操作・処理内容**：
1. 商品詳細情報の閲覧：商品名、価格、説明、ブランド名、商品画像を確認できる
2. カートへの追加（ログイン済み）：「Add to shopping bag」ボタンでカートに商品を追加
3. ログイン誘導（未ログイン）：「Log in to purchase」ボタンでログイン画面へリダイレクト
4. カート内数量の確認：カートに既に入っている同一商品の数量を表示
5. カート画面への遷移：カート内商品がある場合、「shopping bag」リンクからカート画面へ

**画面遷移**：
- 遷移元：カタログ画面（商品カードクリック）、ログイン成功後のリダイレクト
- 遷移先：ログイン画面（未ログイン時のカート追加試行）、カート画面（shopping bagリンク）

**権限による表示制御**：
- 未ログイン時：「Log in to purchase」ボタンが表示され、クリック時にログイン画面へリダイレクト
- ログイン済み時：「Add to shopping bag」ボタンが表示され、直接カートへ追加可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 商品詳細取得 | 主機能 | CatalogService.GetCatalogItemで商品詳細情報を取得 |
| 4 | 商品画像取得 | 補助機能 | IProductImageUrlProviderで商品画像URLを取得 |
| 14 | かご取得 | API連携 | BasketState.GetBasketItemsAsyncでカート内商品数を取得 |
| 15 | かご更新 | API連携 | AddToCartAsyncでBasketState.AddAsyncを呼び出しカートに追加 |
| 42 | 商品詳細画面 | 主機能 | 商品詳細表示・カート追加のUI機能 |
| 47 | ログイン画面 | 遷移先機能 | 未ログイン時にログイン画面へリダイレクト |

## 画面種別

詳細

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/item/{itemId:int}` |
| ルートパラメータ | `itemId`: 商品ID（整数、必須） |
| クエリパラメータ | なし |

## 入出力項目

### 入力項目（ルートパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 商品ID | itemId | int | 必須 | 表示する商品の一意識別子 |

### 出力項目（API取得データ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 商品詳細 | CatalogItem | 商品の詳細情報 |
| カート内数量 | int | 同一商品のカート内数量 |
| ログイン状態 | bool | ユーザーのログイン状態 |

## 表示項目

### 商品詳細セクション

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| 商品名 | CatalogItem.Name | ページタイトル、ヘッダータイトル | ブラウザタイトルにも反映 |
| ブランド名 | CatalogItem.CatalogBrand.Brand | ヘッダーサブタイトル、本文中 | null許容 |
| 商品画像 | IProductImageUrlProvider | img要素 | alt属性に商品名 |
| 説明 | CatalogItem.Description | pタグ | |
| 価格 | CatalogItem.Price | 通貨形式（$0.00） | 小数点以下2桁固定 |
| カート内数量 | numInCart | "{数量} in shopping bag" | 0の場合は非表示 |

### アクションボタン

| 項目名 | 条件 | 表示内容 | 備考 |
|--------|------|---------|------|
| カート追加ボタン | isLoggedIn == true | "Add to shopping bag" | バスケットアイコン付き |
| ログインボタン | isLoggedIn == false | "Log in to purchase" | ユーザーアイコン付き |

## イベント仕様

### 1-カート追加（ログイン済み）

「Add to shopping bag」ボタンをクリックすると、商品がカートに追加される。

**トリガー**: formのsubmitイベント（ログイン済み時）
**処理内容**:
1. AddToCartAsyncメソッドが呼び出される
2. BasketState.AddAsync(item)でカートに商品を追加（既存の場合は数量+1）
3. UpdateNumInCartAsyncでカート内数量を再取得
4. 画面上のカート内数量表示が更新される

**データの流れ**:
```
ユーザー → form submit → AddToCartAsync
                            ↓
                      BasketState.AddAsync
                            ↓
                      BasketService.UpdateBasketAsync
                            ↓
                      UpdateNumInCartAsync
                            ↓
                      numInCart更新 → 画面表示更新
```

### 2-ログイン誘導（未ログイン時）

「Log in to purchase」ボタンをクリックすると、ログイン画面へリダイレクトされる。

**トリガー**: formのsubmitイベント（未ログイン時）
**処理内容**:
1. AddToCartAsyncメソッドが呼び出される
2. isLoggedIn == falseのため、Nav.NavigateTo(Pages.User.LogIn.Url(Nav))が実行される
3. ログイン画面（/user/login）へリダイレクト

### 3-カート画面遷移

「shopping bag」リンクをクリックすると、カート画面へ遷移する。

**トリガー**: aタグクリック（numInCart > 0の場合のみ表示）
**遷移先**: `/cart`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | Catalog | SELECT | 商品詳細を取得 |
| 画面表示 | Basket | SELECT | カート内数量を取得（Redis経由） |
| カート追加 | Basket | UPDATE | カートに商品を追加/数量更新（Redis経由） |

### テーブル別更新項目詳細

#### Catalog（参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | Id, Name, Description, Price, PictureUrl, CatalogBrandId, CatalogTypeId | Id = @itemId | 関連するCatalogBrandも取得 |

#### Basket（Redis）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | ProductId, Quantity | BuyerId = {認証ユーザーID} | カート内全商品を取得 |
| UPDATE | Quantity | 既存: +1, 新規: 1 | BasketService経由 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| ページタイトル | 商品取得成功 | "{商品名} \| AdventureWorks" |
| ページタイトル | 商品未発見 | "Not found" |
| 本文（エラー） | notFound == true | "Sorry, we couldn't find any such product." |
| カート内表示 | numInCart > 0 | "{numInCart} in shopping bag" |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 商品ID不正（404） | HttpRequestException (NotFound)をキャッチ、notFound=trueに設定、HTTPステータス404を返却 | 「Not found」メッセージを表示 |
| その他のAPI通信エラー | 例外がスローされる | 上位でハンドリング |

## 備考

- ブラウザタイトルとヘッダーは動的に商品名に基づいて設定される
- フォームにはAntiforgeryTokenが含まれ、CSRF対策が施されている
- data-enhance属性によりログイン状態に応じたフォームの拡張動作が制御される
- カート追加後の画面遷移は行われず、同一画面でカート内数量が更新される
- CatalogBrandはnullable（item.CatalogBrand?）として扱われている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | 商品データの構造（Id, Name, Description, Price, CatalogBrand等） |
| 1-2 | BasketItem.cs | `src/WebApp/Services/BasketItem.cs` | カート内商品の構造（ProductId, Quantity等） |

**読解のコツ**: CatalogItemはAPIから取得する商品データ、BasketItemはカート内で管理する購入予定商品データとして区別する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ItemPage.razor | `src/WebApp/Components/Pages/Item/ItemPage.razor` | ルーティング（/item/{itemId:int}）、ログイン状態判定、カート追加処理 |

**主要処理フロー**:
1. **行1**: `@page "/item/{itemId:int}"` - ルートパラメータを含むURLルーティング
2. **行69-70**: `[Parameter] public int ItemId` - URLからのパラメータバインディング
3. **行75-88**: `OnInitializedAsync` - 商品取得、ログイン状態確認、カート内数量取得
4. **行79**: `isLoggedIn = HttpContext?.User.Identity?.IsAuthenticated == true` - 認証状態判定
5. **行90-103**: `AddToCartAsync` - カート追加またはログイン画面遷移
6. **行105-109**: `UpdateNumInCartAsync` - カート内の同一商品数量を取得

#### Step 3: カート状態管理を理解する

BasketStateによるカート管理の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IBasketState.cs | `src/WebApp/Services/IBasketState.cs` | カート状態管理のインターフェース定義 |
| 3-2 | BasketState.cs | `src/WebApp/Services/BasketState.cs` | カート追加、数量取得の実装詳細 |

**主要処理フロー**:
- **行21-24**: `GetBasketItemsAsync` - 認証済みの場合のみカート内容を取得
- **行33-56**: `AddAsync` - 既存商品は数量+1、新規商品は数量1で追加
- **行117-148**: `FetchBasketItemsAsync` - BasketServiceからカート取得、CatalogServiceで商品詳細を補完

#### Step 4: サービス層を理解する

バックエンドAPIとの通信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CatalogService.cs | `src/WebAppComponents/Services/CatalogService.cs` | 商品詳細取得API呼び出し |
| 4-2 | BasketService.cs | `src/WebApp/Services/BasketService.cs` | カートAPI呼び出し |

**主要処理フロー**:
- CatalogService **行11-15**: `GetCatalogItem` - /api/catalog/items/{id}で商品詳細取得

### プログラム呼び出し階層図

```
ItemPage.razor (ページコンポーネント)
    │
    ├─ OnInitializedAsync
    │      ├─ CatalogService.GetCatalogItem() → HTTP GET /api/catalog/items/{id}
    │      └─ BasketState.GetBasketItemsAsync()
    │             └─ BasketService.GetBasketAsync() → Basket API
    │
    ├─ AddToCartAsync (ログイン済み)
    │      └─ BasketState.AddAsync()
    │             ├─ FetchBasketItemsAsync()
    │             └─ BasketService.UpdateBasketAsync() → Basket API
    │
    └─ AddToCartAsync (未ログイン)
           └─ Nav.NavigateTo() → /user/login
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ             ItemPage.razor
 - itemId ────────────────┬─ OnInitializedAsync
                          │      │
                          │      ├─ CatalogService ──────▶ item (商品詳細)
                          │      │
                          │      └─ BasketState ─────────▶ numInCart (カート内数量)
                          │
ボタンクリック ───────────┼─ AddToCartAsync
                          │      │
 (ログイン済み)           │      ├─ BasketState.AddAsync ─▶ カート更新
                          │      │
 (未ログイン)             │      └─ Nav.NavigateTo ──────▶ ログイン画面遷移

HttpContext ─────────────────────────────────────────────▶ isLoggedIn (認証状態)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ItemPage.razor | `src/WebApp/Components/Pages/Item/ItemPage.razor` | ソース | 商品詳細画面のメインページコンポーネント |
| CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | ソース | 商品データモデル定義 |
| BasketItem.cs | `src/WebApp/Services/BasketItem.cs` | ソース | カート内商品データモデル定義 |
| IBasketState.cs | `src/WebApp/Services/IBasketState.cs` | ソース | カート状態管理インターフェース |
| BasketState.cs | `src/WebApp/Services/BasketState.cs` | ソース | カート状態管理の実装 |
| CatalogService.cs | `src/WebAppComponents/Services/CatalogService.cs` | ソース | カタログAPI通信サービス |
| BasketService.cs | `src/WebApp/Services/BasketService.cs` | ソース | バスケットAPI通信サービス |
| IProductImageUrlProvider.cs | `src/WebAppComponents/Services/IProductImageUrlProvider.cs` | ソース | 商品画像URL取得インターフェース |
| LogIn.razor | `src/WebApp/Components/Pages/User/LogIn.razor` | ソース | ログイン画面（リダイレクト先） |
