# 画面設計書 20-エラー画面

## 概要

本ドキュメントは、Identity.APIのエラー画面（Shared/Error）の画面設計書である。この画面はIdentityServer4の認証フローにおいてエラーが発生した際に、エラーメッセージとリクエストIDを表示する共通エラー画面である。

### 本画面の処理概要

エラー画面は、IdentityServer4の認証・認可処理においてエラーが発生した場合に表示される共通のエラー表示画面である。エラーの種類、説明、リクエストIDを表示し、問題調査に必要な情報を提供する。

**業務上の目的・背景**：OAuth2.0/OpenID Connect認証フローにおいて、様々なエラーが発生する可能性がある（無効なクライアント、スコープ、リダイレクトURIなど）。本画面はこれらのエラーをユーザーに分かりやすく伝えるとともに、管理者やサポート担当者が問題を調査するためのリクエストIDを提供する。エラーの詳細な説明は開発環境でのみ表示され、本番環境ではセキュリティ上の理由から非表示となる。

**画面へのアクセス方法**：HomeController.Error アクションによりerrorIdパラメータ付きでアクセスされる。また、各コントローラーでエラーが発生した場合にView("Error")として表示される場合もある。

**主要な操作・処理内容**：
1. エラータイトルの表示（"Error"）
2. エラーメッセージの表示（Error.Error）
3. エラー詳細説明の表示（開発環境のみ、Error.ErrorDescription）
4. リクエストIDの表示（Error.RequestId）

**画面遷移**：
- 遷移元：認証フロー中のエラー発生時（同意拒否、無効なリクエスト等）
- 遷移先：特になし（ユーザーはブラウザの戻るボタンやナビゲーションを使用）

**権限による表示制御**：AllowAnonymous属性により認証不要でアクセス可能。ErrorDescriptionは開発環境でのみ表示される（本番環境ではセキュリティ対策としてnull化）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 補助機能 | 認証エラー時のエラーメッセージ・リクエストID表示 |

## 画面種別

エラー表示（共通エラー画面）

## URL/ルーティング

- URL: `/Home/Error?errorId={id}`
- Controller: `HomeController`
- Action: `Error` (GET)

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| エラーID | errorId | string | 入力 | - | URLパラメータ |

### 出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 備考 |
|--------|--------|----------|-----------|------|------|
| エラー情報 | Error | ErrorMessage | 出力 | - | IdentityServerのエラー情報 |

## 表示項目

| 項目名 | 表示形式 | 備考 |
|--------|----------|------|
| タイトル | h1テキスト | "Error" |
| エラーメッセージボックス | alert-danger | "Sorry, there was an error" |
| エラー種別 | strong/emテキスト | Error.Error（設定時のみ） |
| エラー詳細 | divテキスト | Error.ErrorDescription（開発環境のみ） |
| リクエストID | divテキスト | "Request Id: {RequestId}"（設定時のみ） |

## イベント仕様

本画面にはユーザー操作可能なイベントは存在しない。表示専用のエラーメッセージ画面である。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面でのDB操作なし（表示のみ） |

本画面はエラー情報を表示するのみであり、データベースへの操作は行わない。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|--------------|----------------|----------|
| MSG-001 | "Error" | 常時表示（タイトル） |
| MSG-002 | "Sorry, there was an error" | 常時表示（基本メッセージ） |
| MSG-003 | ": {Error.Error}" | Error.Error設定時 |
| MSG-004 | "{Error.ErrorDescription}" | 開発環境かつErrorDescription設定時 |
| MSG-005 | "Request Id: {RequestId}" | RequestId設定時 |

## 例外処理

| 例外パターン | 対応内容 |
|--------------|----------|
| errorIdが無効 | 基本エラーメッセージのみ表示 |
| エラーコンテキスト取得失敗 | 基本エラーメッセージのみ表示 |

## 備考

- ErrorDescriptionは本番環境ではセキュリティ上の理由からnull化される（HomeController.Error行49-53）
- ErrorViewModelはIdentityServerのErrorMessageを保持する
- requestIdはトラブルシューティング時の問題追跡に使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面に渡されるViewModelの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorViewModel.cs | `src/Identity.API/Quickstart/Home/ErrorViewModel.cs` | ErrorMessageプロパティの構造を確認 |

**読解のコツ**: ErrorViewModelはIdentityServerのErrorMessageを保持するシンプルな構造。ErrorMessageにはError（エラー種別）、ErrorDescription（詳細説明）、RequestId（リクエストID）が含まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーのアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HomeController.cs | `src/Identity.API/Quickstart/Home/HomeController.cs` | Error GET（行39-57）の処理フローを確認 |

**主要処理フロー**:
1. **行39**: Errorアクションが呼び出される
2. **行41**: ErrorViewModelを初期化
3. **行44**: GetErrorContextAsync(errorId)でエラー情報を取得
4. **行45-53**: エラー情報が取得できた場合、ViewModelに設定
5. **行49-52**: 本番環境の場合、ErrorDescriptionをnull化
6. **行56**: View("Error", vm)を返却

#### Step 3: ビュー表示を理解する

Razorビューでのエラー表示方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Error.cshtml | `src/Identity.API/Views/Shared/Error.cshtml` | ViewModelのプロパティに基づく条件付き表示を確認 |

**主要処理フロー**:
- **行1**: @model ErrorViewModelでViewModelを受け取る
- **行3-7**: ローカル変数にError、ErrorDescription、RequestIdを展開
- **行16-17**: 基本エラーメッセージを表示
- **行19-26**: Error（エラー種別）が存在する場合、強調表示
- **行27-29**: ErrorDescriptionが存在する場合、詳細を表示
- **行34-37**: RequestIdが存在する場合、表示

### プログラム呼び出し階層図

```
HTTP GET /Home/Error?errorId=xxx
    │
    ▼
HomeController.Error(GET)
    │
    ├─ ErrorViewModel初期化
    │
    ├─ IIdentityServerInteractionService.GetErrorContextAsync(errorId)
    │      │
    │      └─ ErrorMessage（またはnull）
    │             - Error（エラー種別）
    │             - ErrorDescription（詳細説明）
    │             - RequestId（リクエストID）
    │
    ├─ [本番環境] ErrorDescription = null
    │
    └─ View("Error", ErrorViewModel)
           │
           ▼
       Error.cshtml
           │
           ├─ 基本エラーメッセージ
           ├─ エラー種別（条件付き）
           ├─ エラー詳細（条件付き・開発環境のみ）
           └─ リクエストID（条件付き）
```

### データフロー図

```
[入力]                         [処理]                              [出力]

errorId ─────────────────▶ GetErrorContextAsync(errorId)
                                    │
                                    ▼
                            ErrorMessage（またはnull）
                                    │
                                    ▼
                            ErrorViewModel
                            - Error（ErrorMessage）
                                    │
                     ┌──────────────┼──────────────┐
                     ▼              │              ▼
               [開発環境]           │         [本番環境]
                     │              │              │
                     │              │              ▼
                     │              │      ErrorDescription = null
                     │              │              │
                     └──────────────┼──────────────┘
                                    ▼
                            Error.cshtml
                                    │
                                    ▼
                            HTML出力
                            - 基本メッセージ
                            - エラー種別（あれば）
                            - 詳細説明（開発環境のみ）
                            - リクエストID（あれば）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Error.cshtml | `src/Identity.API/Views/Shared/Error.cshtml` | ビュー | エラー画面のRazorテンプレート |
| HomeController.cs | `src/Identity.API/Quickstart/Home/HomeController.cs` | コントローラー | エラー画面のエントリーポイント |
| ErrorViewModel.cs | `src/Identity.API/Quickstart/Home/ErrorViewModel.cs` | ViewModel | 画面表示用データモデル |
