# 画面設計書 21-ホーム画面

## 概要

本ドキュメントは、WebhookClientアプリケーションのホーム画面（Webhook管理画面）の設計仕様を記載する。

### 本画面の処理概要

本画面は、eShopシステムにおけるWebhook管理のメイン画面である。ユーザーはこの画面を通じて、登録済みのWebhookの一覧を確認し、OrderPaidイベントによって受信したWebhookメッセージを監視することができる。

**業務上の目的・背景**：eShopシステムでは、注文が支払い完了（OrderPaid）状態に遷移した際に、外部システムへ通知を行うWebhook機能を提供している。この画面は、Webhookの登録状況と受信メッセージを一元管理するために必要であり、システム管理者やインテグレーション担当者がWebhookの動作を監視・確認するための業務課題を解決する。

**画面へのアクセス方法**：WebhookClientアプリケーションのルートURL（/）にアクセスすることで表示される。認証の有無に関わらずアクセス可能だが、登録済みWebhookの表示とWebhook追加機能は認証が必要である。

**主要な操作・処理内容**：
1. 登録済みWebhook一覧の閲覧（認証時のみ）
2. Webhook追加画面への遷移（認証時のみ）
3. 受信済みWebhookメッセージの一覧閲覧
4. 受信メッセージのリアルタイム更新監視

**画面遷移**：
- 遷移元：ログイン画面（/login）から認証後にリダイレクト
- 遷移先：Webhook追加画面（/add-webhook）へのリンク

**権限による表示制御**：認証済みユーザーは登録済みWebhook一覧とWebhook追加リンクが表示される。未認証ユーザーにはログインを促すメッセージが表示され、受信メッセージ一覧のみ閲覧可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | Webhook一覧取得 | 主機能 | WebhooksClient.LoadWebhooksで登録済みWebhook一覧を取得 |
| 49 | ホーム画面 | 主機能 | Webhook管理メイン画面のUI機能 |
| 51 | 受信メッセージ表示 | 補助機能 | HooksRepositoryで受信Webhookメッセージ一覧を表示 |
| 52 | 登録済みWebhook表示 | 補助機能 | WebhooksClientで登録済みWebhook一覧を表示 |

## 画面種別

一覧（ダッシュボード）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/` |
| ルート定義 | `@page "/"` |
| 認証要件 | 不要（ただし機能制限あり） |

## 入出力項目

本画面に入力フォームはなし。

## 表示項目

### 登録済みWebhook一覧（RegisteredHooks）

| 項目名 | 論理名 | データ型 | 説明 | ソート |
|--------|--------|----------|------|--------|
| Date | 登録日時 | DateTime | Webhook登録日時 | 可（デフォルト降順） |
| Destination | 送信先URL | string | Webhookの送信先URL | 可 |
| Token | トークン | string | 認証トークン | 可 |

### 受信メッセージ一覧（ReceivedMessages）

| 項目名 | 論理名 | データ型 | 説明 | ソート |
|--------|--------|----------|------|--------|
| When | 受信日時 | DateTime | メッセージ受信日時 | 可 |
| Data | データ | string | Webhookペイロードデータ | 可 |
| Token | トークン | string | 認証トークン | 可 |

## イベント仕様

### 1-ページ初期化

**トリガー**：ページアクセス時

**処理フロー**：
1. RegisteredHooksコンポーネントがWebhooksClient.LoadWebhooksを呼び出し
2. ReceivedMessagesコンポーネントがHooksRepository.GetAllを呼び出し
3. ReceivedMessagesコンポーネントがHooksRepository.Subscribeで変更通知を購読

**データの流れ**：
```
WebhooksClient.LoadWebhooks() → GET /api/webhooks → Webhooks API
HooksRepository.GetAll() → インメモリキュー → 受信メッセージ一覧
```

### 2-Webhook追加リンク押下

**トリガー**：「Add webhook registration」リンクのクリック

**処理フロー**：
1. NavigationManagerにより/add-webhookへ遷移

**前提条件**：認証済みであること

### 3-受信メッセージ更新

**トリガー**：新しいWebhookメッセージの受信

**処理フロー**：
1. WebhookEndpointsの/webhook-receivedエンドポイントがメッセージを受信
2. HooksRepository.AddNewでキューに追加
3. 購読中のReceivedMessagesコンポーネントにコールバック通知
4. StateHasChangedで画面を再描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ初期化 | N/A | - | 本画面からはDBへの直接アクセスなし |

### 備考

WebhookClientアプリケーションは、データベースを直接使用せず、以下の仕組みでデータを管理している：
- **登録済みWebhook一覧**：Webhooks APIへのHTTPリクエストで取得
- **受信メッセージ一覧**：HooksRepositoryのインメモリConcurrentQueueで管理

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | Loading... | データ読み込み中 |
| 情報 | None registered | 登録済みWebhookがない場合 |
| 情報 | None yet received | 受信メッセージがない場合 |
| 警告 | Log in to view or edit webhook registrations | 未認証ユーザーへの表示 |
| 補足 | Webhook messages will appear once a webhook is registered and an order transitions into "paid" status. | 受信メッセージがない場合の説明 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| HttpRequestException | Webhooks APIへの接続失敗 | DispatchExceptionAsyncで例外をスロー |
| 認証エラー | 未認証でのAPI呼び出し | AuthorizeViewで事前にブロック |

## 備考

- RegisteredHooksコンポーネントはQuickGridを使用してソート可能なテーブルを表示
- ReceivedMessagesコンポーネントはIDisposableを実装し、コンポーネント破棄時に購読を解除
- 受信メッセージはリアルタイムで更新され、手動リフレッシュは不要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータモデルの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebhookResponse.cs | `src/WebhookClient/Services/WebhookResponse.cs` | 登録済みWebhookのデータ構造（Date, DestUrl, Token） |
| 1-2 | WebHookReceived.cs | `src/WebhookClient/Services/WebHookReceived.cs` | 受信メッセージのデータ構造（When, Data, Token） |

**読解のコツ**: C#のrecord/classとプロパティの定義を確認し、APIレスポンスとの対応を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ページ構成とAuthorizeViewによる認証制御 |

**主要処理フロー**:
1. **1-2行目**: @page "/"でルート定義、usingでAuthorizationコンポーネントをインポート
2. **8-18行目**: AuthorizeViewで認証状態に応じた表示切替
3. **10行目**: RegisteredHooksコンポーネントの埋め込み
4. **22行目**: ReceivedMessagesコンポーネントの埋め込み

#### Step 3: 登録済みWebhook表示機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | QuickGridによる一覧表示とソート機能 |
| 3-2 | WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | LoadWebhooksメソッドによるAPI呼び出し |

**主要処理フロー**:
- **23-26行目（RegisteredHooks.razor）**: OnInitializedAsyncでLoadWebhooksを呼び出し
- **10-13行目（WebHooksClient.cs）**: GET /api/webhooksへのHTTPリクエスト

#### Step 4: 受信メッセージ表示機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | リアルタイム更新の購読パターン |
| 4-2 | HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | ConcurrentQueueとObserverパターン |

**主要処理フロー**:
- **28-32行目（ReceivedMessages.razor）**: OnInitializedAsyncでSubscribeとGetAllを実行
- **35-47行目（HooksRepository.cs）**: Subscribe/NotifyAsyncによる変更通知機構

#### Step 5: Webhook受信エンドポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | /webhook-receivedエンドポイントの実装 |

**主要処理フロー**:
- **31-53行目**: POST /webhook-receivedでWebhookを受信し、HooksRepository.AddNewで保存

### プログラム呼び出し階層図

```
Home.razor (/)
    │
    ├─ RegisteredHooks.razor
    │      └─ WebhooksClient.LoadWebhooks()
    │             └─ GET /api/webhooks (Webhooks API)
    │
    └─ ReceivedMessages.razor
           ├─ HooksRepository.Subscribe()
           │      └─ OnChangeSubscription (変更監視)
           └─ HooksRepository.GetAll()
                  └─ ConcurrentQueue<WebHookReceived>
```

### データフロー図

```
[入力]                     [処理]                           [出力]

外部システム ───▶ POST /webhook-received ───▶ HooksRepository
                       │                           │
                       ▼                           ▼
              WebhookEndpoints          ConcurrentQueue
                       │                           │
                       ▼                           ▼
              HooksRepository.AddNew() ───▶ Subscribe通知
                                                   │
                                                   ▼
                                          ReceivedMessages
                                          (画面更新)

Webhooks API ◀─── GET /api/webhooks ◀─── WebhooksClient
                                                   │
                                                   ▼
                                          RegisteredHooks
                                          (一覧表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ソース | メインページ |
| RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | ソース | 登録済みWebhook一覧コンポーネント |
| ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | ソース | 受信メッセージ一覧コンポーネント |
| WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | ソース | Webhooks APIクライアント |
| HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | ソース | 受信メッセージ管理リポジトリ |
| WebhookResponse.cs | `src/WebhookClient/Services/WebhookResponse.cs` | ソース | 登録済みWebhookモデル |
| WebHookReceived.cs | `src/WebhookClient/Services/WebHookReceived.cs` | ソース | 受信メッセージモデル |
| WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | ソース | Webhookエンドポイント定義 |
| Program.cs | `src/WebhookClient/Program.cs` | ソース | アプリケーション起動設定 |
