# 画面設計書 22-Webhook追加画面

## 概要

本ドキュメントは、WebhookClientアプリケーションのWebhook追加画面の設計仕様を記載する。

### 本画面の処理概要

本画面は、eShopシステムにおいてOrderPaidイベント用のWebhookを新規登録するためのフォーム画面である。ユーザーは認証トークンを入力し、Webhooks APIに対して新規Webhookサブスクリプションを登録することができる。

**業務上の目的・背景**：eShopシステムでは、注文の支払い完了時に外部システムへ通知を行うWebhook機能を提供している。この画面は、新しいWebhookエンドポイントを登録するために必要であり、外部システムとのインテグレーションを設定する管理者・開発者の業務課題を解決する。Webhook登録により、注文処理の自動化や外部システムへのリアルタイム通知が可能になる。

**画面へのアクセス方法**：ホーム画面（/）の「Add webhook registration」リンクをクリックすることでアクセスする。または直接URL（/add-webhook）にアクセスすることも可能。認証済みユーザーのみがホーム画面からリンクを確認できる。

**主要な操作・処理内容**：
1. トークン入力フィールドへの認証トークン入力
2. 「Register」ボタンによるWebhook登録の実行
3. 登録成功時のホーム画面へのリダイレクト
4. 登録失敗時のエラーメッセージ表示

**画面遷移**：
- 遷移元：ホーム画面（/）の「Add webhook registration」リンク
- 遷移先：登録成功時にホーム画面（/）へリダイレクト

**権限による表示制御**：認証済みユーザーのみがWebhook登録を実行できる。ただし、画面自体へのアクセス制御は明示的に設定されていないため、未認証でもURLを直接指定すればフォームは表示される（登録実行時にAPIで認証エラーとなる）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | Webhook登録 | 主機能 | WebhooksClient.AddWebHookAsyncでWebhook登録 |
| 40 | Grant URL検証 | 補助機能 | Webhook登録時のGrant URL検証 |
| 50 | Webhook登録画面 | 主機能 | OrderPaidイベント用Webhook登録フォーム |
| 49 | ホーム画面 | 遷移先機能 | 登録成功後にホーム画面へリダイレクト |

## 画面種別

登録

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/add-webhook` |
| ルート定義 | `@page "/add-webhook"` |
| 認証要件 | 推奨（明示的な制約なし） |

## 入出力項目

### 入力項目

| 項目名 | 論理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| token | トークン | string | はい | WebhookClientOptions.Token | Webhook認証トークン |

### 隠し項目（自動生成）

| 項目名 | 論理名 | データ型 | 生成方法 | 説明 |
|--------|--------|----------|----------|------|
| url | Webhook URL | string | `{SelfUrl or BaseUri}webhook-received` | Webhookの受信先URL |
| granturl | Grant URL | string | `{SelfUrl or BaseUri}check` | トークン検証用URL |
| Event | イベント種別 | string | 固定値 "OrderPaid" | 購読対象イベント |

## 表示項目

| 項目名 | 論理名 | データ型 | 説明 |
|--------|--------|----------|------|
| message | エラーメッセージ | string | 登録失敗時のエラー内容 |

## イベント仕様

### 1-ページ初期化（OnInitialized）

**トリガー**：ページアクセス時

**処理フロー**：
1. WebhookClientOptionsからデフォルトトークンを取得
2. tokenフィールドに初期値を設定

**データの流れ**：
```
IOptions<WebhookClientOptions> → options.Value.Token → token
```

### 2-登録ボタン押下（RegisterAsync）

**トリガー**：「Register」ボタンのクリック（フォームsubmit）

**処理フロー**：
1. トークンが空の場合は処理中断
2. エラーメッセージをクリア
3. SelfUrlまたはBaseUriからベースURLを決定
4. Grant URL（/check）とWebhook URL（/webhook-received）を構築
5. WebhookSubscriptionRequestペイロードを作成
6. WebhooksClient.AddWebHookAsyncでAPIを呼び出し
7. 成功時：ホーム画面（/）へリダイレクト
8. 失敗時：エラーメッセージを表示

**データの流れ**：
```
token入力 → WebhookSubscriptionRequest構築 → POST /api/webhooks → Webhooks API
                                              │
                                              ├─ 成功 → NavigateTo("/")
                                              └─ 失敗 → messageにエラー表示
```

### 3-ホームリンク押下

**トリガー**：説明文中の「home」リンクのクリック

**処理フロー**：
1. ホーム画面（/）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Registerボタン押下 | Subscriptions（Webhooks API側） | INSERT | Webhookサブスクリプションを新規登録 |

### 備考

WebhookClientアプリケーション自体はデータベースを直接使用しない。Webhook登録はWebhooks APIへのHTTPリクエストを通じて行われ、実際のデータ永続化はWebhooks APIサービス側で実行される。

### Webhooks APIへの登録リクエスト

| フィールド | 値 | 説明 |
|-----------|-----|------|
| Event | "OrderPaid" | 購読対象イベント種別 |
| GrantUrl | `{baseUrl}check` | トークン検証用エンドポイント |
| Url | `{baseUrl}webhook-received` | Webhook受信エンドポイント |
| Token | 入力値 | 認証トークン |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 説明 | This page registers the "OrderPaid" Webhook by sending a POST to the WebHooks API. Once the Webhook is set, you will be able to see new paid orders from the home page. | 常時表示 |
| エラー | Registation was rejected with status {StatusCode} {ReasonPhrase} | API呼び出し失敗時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| トークン未入力 | tokenが空またはnull | 処理を中断（早期リターン） |
| API接続エラー | Webhooks APIへの接続失敗 | HttpResponseMessageのStatusCodeとReasonPhraseを表示 |
| 認証エラー | 無効なトークンまたは未認証 | エラーメッセージを表示 |
| バリデーションエラー | Grant URL検証失敗 | エラーメッセージを表示 |

## 備考

- Eventは現在「OrderPaid」のみ固定でサポート
- Grant URLは、Webhooks APIがWebhook登録時にトークンを検証するためのコールバックエンドポイント
- SelfUrlが設定されている場合はそれを優先、未設定の場合はNavigationManager.BaseUriを使用
- 登録成功時は自動的にホーム画面へリダイレクトされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Webhook登録に必要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebhookSubscriptionRequest.cs | `src/WebhookClient/Services/WebhookSubscriptionRequest.cs` | 登録リクエストのデータ構造（Url, Token, Event, GrantUrl） |
| 1-2 | WebhookClientOptions.cs | `src/WebhookClient/Services/WebhookClientOptions.cs` | 設定オプション（Token, SelfUrl, ValidateToken） |

**読解のコツ**: WebhookSubscriptionRequestの4つのプロパティが、APIへのPOSTリクエストボディになることを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AddWebhook.razor | `src/WebhookClient/Components/Pages/AddWebhook.razor` | フォーム構成とRegisterAsyncメソッドの実装 |

**主要処理フロー**:
1. **1行目**: @page "/add-webhook"でルート定義
2. **3-5行目**: IOptions、NavigationManager、WebhooksClientの依存性注入
3. **11-17行目**: フォーム定義（token入力とRegisterボタン）
4. **28-30行目**: OnInitializedでデフォルトトークンを設定
5. **33-63行目**: RegisterAsyncメソッドでWebhook登録処理

#### Step 3: Webhook登録処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | AddWebHookAsyncメソッドによるAPI呼び出し |

**主要処理フロー**:
- **5-8行目**: POST /api/webhooksへのリクエスト送信

#### Step 4: Grant URL検証エンドポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | /checkエンドポイントの実装 |

**主要処理フロー**:
- **16-29行目**: OPTIONS /checkでトークン検証を実行

### プログラム呼び出し階層図

```
AddWebhook.razor (/add-webhook)
    │
    ├─ OnInitialized()
    │      └─ WebhookClientOptions.Token → token初期値
    │
    └─ RegisterAsync() [フォームsubmit時]
           │
           ├─ WebhookSubscriptionRequest構築
           │      ├─ Event: "OrderPaid"
           │      ├─ GrantUrl: {baseUrl}check
           │      ├─ Url: {baseUrl}webhook-received
           │      └─ Token: 入力値
           │
           └─ WebhooksClient.AddWebHookAsync(payload)
                  │
                  └─ POST /api/webhooks (Webhooks API)
                         │
                         ├─ 成功 → NavigateTo("")
                         └─ 失敗 → message設定
```

### データフロー図

```
[入力]                     [処理]                           [出力]

Token入力 ─────────────▶ WebhookSubscriptionRequest構築
                               │
                               ├─ Event: "OrderPaid"
                               ├─ GrantUrl構築
                               └─ Url構築
                               │
                               ▼
                        WebhooksClient.AddWebHookAsync()
                               │
                               ▼
                        POST /api/webhooks
                               │
                    ┌──────────┴──────────┐
                    ▼                      ▼
            成功: 200 OK             失敗: 4xx/5xx
                    │                      │
                    ▼                      ▼
            NavigateTo("/")         messageにエラー表示
            (ホーム画面へ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AddWebhook.razor | `src/WebhookClient/Components/Pages/AddWebhook.razor` | ソース | Webhook追加画面メインページ |
| WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | ソース | Webhooks APIクライアント |
| WebhookSubscriptionRequest.cs | `src/WebhookClient/Services/WebhookSubscriptionRequest.cs` | ソース | 登録リクエストモデル |
| WebhookClientOptions.cs | `src/WebhookClient/Services/WebhookClientOptions.cs` | ソース | 設定オプションクラス |
| WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | ソース | /checkエンドポイント定義 |
| Program.cs | `src/WebhookClient/Program.cs` | ソース | アプリケーション起動設定 |
