# 画面設計書 23-ログイン画面

## 概要

本ドキュメントは、WebhookClientアプリケーションのログイン画面の設計仕様を記載する。

### 本画面の処理概要

本画面は、WebhookClientアプリケーションにおけるログイン処理のエントリーポイントである。[Authorize]属性によりIdentity.APIへのOIDC認証フローをトリガーし、認証完了後に元のページまたは指定されたReturnUrlへリダイレクトする中継画面として機能する。

**業務上の目的・背景**：WebhookClientアプリケーションでは、Webhook管理機能（登録済みWebhookの閲覧、新規Webhook登録）にアクセスするために認証が必要である。この画面は、OIDC準拠の認証フローを開始するためのエントリーポイントとして必要であり、Identity.APIによる統一認証基盤を利用したシングルサインオン（SSO）を実現する。

**画面へのアクセス方法**：未認証状態で認証が必要なページにアクセスした際に自動的にリダイレクトされる。また、UserMenuコンポーネントのログインリンクから直接アクセスすることも可能。URLは/loginでReturnUrlクエリパラメータを受け取る。

**主要な操作・処理内容**：
1. [Authorize]属性によりOIDC認証フローを自動開始
2. Identity.APIでの認証処理（別画面）
3. 認証成功後にReturnUrl（指定がなければルート）へリダイレクト

**画面遷移**：
- 遷移元：認証が必要な任意のページ、UserMenuのログインリンク
- 遷移先（OIDC）：Identity.APIのログイン画面（/Account/Login）
- 遷移先（認証後）：ReturnUrlで指定されたURL、またはルート（/）

**権限による表示制御**：本画面は[Authorize]属性により認証を強制する。未認証ユーザーがアクセスすると自動的にIdentity.APIへリダイレクトされるため、実質的に画面コンテンツは表示されない。認証済みの場合は即座にReturnUrlへリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 遷移先機能 | Authorize属性によりIdentity.APIへリダイレクト |

## 画面種別

中継（リダイレクト）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/login` |
| ルート定義 | `@page "/login"` |
| 認証要件 | 必須（[Authorize]属性） |

## 入出力項目

### クエリパラメータ（入力）

| 項目名 | 論理名 | データ型 | 必須 | デフォルト値 | 説明 |
|--------|--------|----------|------|--------------|------|
| ReturnUrl | 戻り先URL | string | いいえ | 空文字（ルートへ） | 認証後のリダイレクト先URL |

## 表示項目

本画面は表示コンテンツを持たない。[Authorize]属性による認証チェックで即座にリダイレクトが発生するため、UIは描画されない。

## イベント仕様

### 1-ページ初期化（OnInitialized）

**トリガー**：ページアクセス時（認証済みの場合）

**処理フロー**：
1. ReturnUrlクエリパラメータを取得（未指定時は空文字）
2. ReturnUrlを相対URLとしてパース
3. NavigationManagerで指定されたURLへリダイレクト（replace: true）

**データの流れ**：
```
?ReturnUrl={url} → SupplyParameterFromQuery → new Uri(ReturnUrl, UriKind.Relative) → Nav.NavigateTo()
```

### 2-OIDC認証フロー（Authorize属性）

**トリガー**：未認証状態でのページアクセス

**処理フロー**：
1. [Authorize]属性により認証チェック
2. 未認証の場合、OIDC認証ミドルウェアがIdentity.APIへリダイレクト
3. Identity.APIでログイン画面を表示
4. 認証成功後、本画面にコールバック
5. OnInitializedが実行されReturnUrlへリダイレクト

**データの流れ**：
```
/login?ReturnUrl=xxx → [Authorize] → Identity.API(/Account/Login)
                                            │
                                            ▼
                                    ログイン処理
                                            │
                                            ▼
                                    /login?ReturnUrl=xxx（コールバック）
                                            │
                                            ▼
                                    OnInitialized → NavigateTo(ReturnUrl)
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面からはDBへのアクセスなし |

### 備考

認証処理はIdentity.API側で実行される。本画面はリダイレクトのみを担当し、データベース操作は行わない。

## メッセージ仕様

本画面にメッセージ表示機能はない。

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 無効なReturnUrl | 不正なURL形式 | UriKind.Relativeでパース失敗時は空文字として扱われる |
| 認証失敗 | Identity.APIでの認証エラー | Identity.API側でエラー処理 |

## 備考

- 本画面は実質的なUIを持たないリダイレクト専用ページ
- [Authorize]属性により、アクセス時点で認証が強制される
- ReturnUrlは相対URLのみ受け付け、絶対URLは拒否される（セキュリティ対策）
- replace: trueにより、ブラウザ履歴に本画面は残らない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 認証設定を理解する

まず、アプリケーション全体の認証設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/WebhookClient/Program.cs` | AddApplicationServicesでの認証サービス設定 |
| 1-2 | Extensions.cs | `src/WebhookClient/Extensions/Extensions.cs` | OIDC認証の設定内容 |

**読解のコツ**: AddApplicationServicesメソッドでOIDC認証がどのように設定されているかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogIn.razor | `src/WebhookClient/Components/Pages/LogIn.razor` | [Authorize]属性とリダイレクト処理 |

**主要処理フロー**:
1. **1行目**: @page "/login"でルート定義
2. **3行目**: [Authorize]属性による認証強制
3. **6行目**: ReturnUrlクエリパラメータの受け取り
4. **7-10行目**: OnInitializedでリダイレクト処理

#### Step 3: 関連コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UserMenu.razor | `src/WebhookClient/Components/Layout/UserMenu.razor` | ログインリンクの生成方法 |

### プログラム呼び出し階層図

```
/login?ReturnUrl=xxx へのアクセス
    │
    ├─ [Authorize]属性チェック
    │      │
    │      ├─ 未認証の場合
    │      │      └─ OIDC認証ミドルウェア
    │      │             └─ Identity.API (/Account/Login) へリダイレクト
    │      │                    │
    │      │                    ▼
    │      │             認証成功後コールバック
    │      │
    │      └─ 認証済みの場合
    │             └─ ページ描画開始
    │
    └─ OnInitialized()
           │
           ├─ ReturnUrl取得 (SupplyParameterFromQuery)
           │
           └─ Nav.NavigateTo(returnUrl, replace: true)
                  │
                  └─ ReturnUrl先 または ルート(/) へリダイレクト
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ReturnUrl ────────────▶ SupplyParameterFromQuery
(クエリパラメータ)              │
                               ▼
                        new Uri(ReturnUrl, UriKind.Relative)
                               │
                               ▼
                        Nav.NavigateTo(returnUrl, replace: true)
                               │
                               ▼
                        [リダイレクト先URL]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogIn.razor | `src/WebhookClient/Components/Pages/LogIn.razor` | ソース | ログイン画面（リダイレクト中継） |
| UserMenu.razor | `src/WebhookClient/Components/Layout/UserMenu.razor` | ソース | ログインリンク生成コンポーネント |
| Extensions.cs | `src/WebhookClient/Extensions/Extensions.cs` | ソース | 認証サービス設定 |
| Program.cs | `src/WebhookClient/Program.cs` | ソース | アプリケーション起動設定 |
